/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.DataOutputStream;
import java.io.IOException;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.utility.ByteBufferOutputStream;

public class RTCPCompoundPacket
extends RTCPPacket {
    public RTCPPacket[] packets;

    public RTCPCompoundPacket(Packet base) {
        super(base);
        this.type = -1;
    }

    public RTCPCompoundPacket(RTCPPacket[] packets) {
        this.packets = packets;
        this.type = -1;
        this.received = false;
    }

    @Override
    public void assemble(DataOutputStream out) throws IOException {
        throw new IllegalArgumentException("Recursive Compound Packet");
    }

    public void assemble(int len, boolean encrypted) {
        int laststart;
        this.length = len;
        this.offset = 0;
        byte[] d = new byte[len];
        ByteBufferOutputStream bbos = new ByteBufferOutputStream(d, 0, len);
        DataOutputStream dos = new DataOutputStream(bbos);
        try {
            if (encrypted) {
                this.offset += 4;
            }
            laststart = this.offset;
            for (int i = 0; i < this.packets.length; ++i) {
                laststart = bbos.size();
                this.packets[i].assemble(dos);
            }
        }
        catch (IOException e) {
            throw new NullPointerException("Impossible IO Exception");
        }
        int prelen = bbos.size();
        this.data = d;
        if (prelen > len) {
            throw new NullPointerException("RTCP Packet overflow");
        }
        if (prelen < len) {
            if (this.data.length < len) {
                this.data = new byte[len];
                System.arraycopy(this.data, 0, this.data, 0, prelen);
            }
            int n = laststart;
            this.data[n] = (byte)(this.data[n] | 0x20);
            this.data[len - 1] = (byte)(len - prelen);
            int temp = (this.data[laststart + 3] & 0xFF) + (len - prelen >> 2);
            if (temp >= 256) {
                int n2 = laststart + 2;
                this.data[n2] = (byte)(this.data[n2] + (len - prelen >> 10));
            }
            this.data[laststart + 3] = (byte)temp;
        }
    }

    @Override
    public int calcLength() {
        if (this.packets == null || this.packets.length < 1) {
            throw new IllegalArgumentException("Bad RTCP Compound Packet");
        }
        int len = 0;
        for (int i = 0; i < this.packets.length; ++i) {
            len += this.packets[i].calcLength();
        }
        return len;
    }

    @Override
    public String toString() {
        return "RTCP Packet with the following subpackets:\n" + this.toString(this.packets);
    }

    public String toString(RTCPPacket[] packets) {
        String s = "";
        for (int i = 0; i < packets.length; ++i) {
            s = s + packets[i];
        }
        return s;
    }
}

