/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntIterator;
import org.jetbrains.annotations.NotNull;

public class Enumerator<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.containers.Enumerator");
    private final TObjectIntHashMap<T> myNumbers;
    private int myNextNumber;

    public Enumerator(int expectNumber, @NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            Enumerator.$$$reportNull$$$0(0);
        }
        this.myNextNumber = 1;
        this.myNumbers = new TObjectIntHashMap(expectNumber, strategy);
    }

    @NotNull
    public int[] enumerate(@NotNull T[] objects, int startShift, int endCut) {
        if (objects == null) {
            Enumerator.$$$reportNull$$$0(3);
        }
        int[] idx = ArrayUtil.newIntArray(objects.length - startShift - endCut);
        for (int i = startShift; i < objects.length - endCut; ++i) {
            int number;
            T object = objects[i];
            idx[i - startShift] = number = this.enumerate(object);
        }
        if (idx == null) {
            Enumerator.$$$reportNull$$$0(4);
        }
        return idx;
    }

    public int enumerate(T object) {
        int res2 = this.enumerateImpl(object);
        return Math.max(res2, -res2);
    }

    public int enumerateImpl(T object) {
        if (object == null) {
            return 0;
        }
        int number = this.myNumbers.get(object);
        if (number == 0) {
            number = this.myNextNumber++;
            this.myNumbers.put(object, number);
            return -number;
        }
        return number;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        TObjectIntIterator iter = this.myNumbers.iterator();
        while (iter.hasNext()) {
            iter.advance();
            buffer.append(iter.value()).append(": ").append(iter.key()).append("\n");
        }
        return buffer.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/Enumerator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/Enumerator";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "enumerate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "enumerate";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

