/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.ktlint.reporter.plain;

import com.andreapivetta.kolor.Color;
import com.andreapivetta.kolor.Kolor;
import com.github.shyiko.ktlint.core.LintError;
import com.github.shyiko.ktlint.core.Reporter;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\fH\u0002J \u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\f\u0010\u001e\u001a\u00020\f*\u00020\fH\u0002R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lcom/github/shyiko/ktlint/reporter/plain/PlainReporter;", "Lcom/github/shyiko/ktlint/core/Reporter;", "out", "Ljava/io/PrintStream;", "verbose", "", "groupByFile", "color", "pad", "(Ljava/io/PrintStream;ZZZZ)V", "acc", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lcom/github/shyiko/ktlint/core/LintError;", "getColor", "()Z", "getGroupByFile", "getOut", "()Ljava/io/PrintStream;", "getPad", "getVerbose", "after", "", "file", "colorFileName", "fileName", "onLintError", "err", "corrected", "gray", "ktlint-reporter-plain"})
public final class PlainReporter
implements Reporter {
    private final ConcurrentHashMap<String, List<LintError>> acc;
    @NotNull
    private final PrintStream out;
    private final boolean verbose;
    private final boolean groupByFile;
    private final boolean color;
    private final boolean pad;

    public void onLintError(@NotNull String file, @NotNull LintError err, boolean corrected) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
        if (!corrected) {
            if (this.groupByFile) {
                ConcurrentMap $receiver$iv = this.acc;
                Object object = $receiver$iv.get(file);
                if (object == null) {
                    ArrayList arrayList = new ArrayList();
                    ArrayList default$iv = arrayList;
                    object = $receiver$iv.putIfAbsent(file, default$iv);
                    if (object == null) {
                        object = default$iv;
                    }
                }
                ((List)object).add(err);
            } else {
                String string;
                String string2 = "" + err.getCol() + ':';
                StringBuilder stringBuilder = new StringBuilder().append(':');
                PlainReporter plainReporter = this;
                StringBuilder stringBuilder2 = new StringBuilder().append("").append(this.colorFileName(file)).append("").append(this.gray(":")).append("").append(err.getLine()).append("");
                PrintStream printStream = this.out;
                String it = string2;
                if (this.pad) {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string3 = "%-4s";
                    Object[] objectArray = new Object[]{it};
                    String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                    string = string4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
                } else {
                    string = it;
                }
                String string5 = string;
                printStream.println(stringBuilder2.append(plainReporter.gray(stringBuilder.append(string5).toString())).append(' ').append(err.getDetail()).append("").append(this.verbose ? this.gray(" (" + err.getRuleId() + ')') : "").toString());
            }
        }
    }

    public void after(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (this.groupByFile) {
            List<LintError> list = this.acc.get(file);
            if (list == null) {
                return;
            }
            List<LintError> errList = list;
            this.out.println(this.colorFileName(file));
            for (LintError lintError : errList) {
                String string;
                int line = lintError.component1();
                int col = lintError.component2();
                String ruleId = lintError.component3();
                String detail = lintError.component4();
                PrintStream printStream = this.out;
                StringBuilder stringBuilder = new StringBuilder().append("  ").append(line).append("");
                PlainReporter plainReporter = this;
                StringBuilder stringBuilder2 = new StringBuilder().append(':');
                if (this.pad) {
                    String string2;
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string3 = "%-3s";
                    Object[] objectArray = new Object[]{col};
                    StringBuilder stringBuilder3 = stringBuilder2;
                    PlainReporter plainReporter2 = plainReporter;
                    StringBuilder stringBuilder4 = stringBuilder;
                    PrintStream printStream2 = printStream;
                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string3, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                    printStream = printStream2;
                    stringBuilder = stringBuilder4;
                    plainReporter = plainReporter2;
                    stringBuilder2 = stringBuilder3;
                    string = string2;
                } else {
                    string = "" + col;
                }
                printStream.println(stringBuilder.append(plainReporter.gray(stringBuilder2.append(string).toString())).append(' ').append(detail).append("").append(this.verbose ? this.gray(" (" + ruleId + ')') : "").toString());
            }
        }
    }

    private final String colorFileName(String fileName) {
        String string = File.separator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.separator");
        String name = StringsKt.substringAfterLast$default((String)fileName, (String)string, null, (int)2, null);
        String string2 = fileName;
        int n = 0;
        int n2 = fileName.length() - name.length();
        PlainReporter plainReporter = this;
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string5 = string4;
        return stringBuilder.append(plainReporter.gray(string5)).append(name).toString();
    }

    private final String gray(@NotNull String $receiver) {
        return this.color ? Kolor.INSTANCE.foreground($receiver, Color.DARK_GRAY) : $receiver;
    }

    @NotNull
    public final PrintStream getOut() {
        return this.out;
    }

    public final boolean getVerbose() {
        return this.verbose;
    }

    public final boolean getGroupByFile() {
        return this.groupByFile;
    }

    public final boolean getColor() {
        return this.color;
    }

    public final boolean getPad() {
        return this.pad;
    }

    public PlainReporter(@NotNull PrintStream out, boolean verbose, boolean groupByFile, boolean color, boolean pad) {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        this.out = out;
        this.verbose = verbose;
        this.groupByFile = groupByFile;
        this.color = color;
        this.pad = pad;
        this.acc = new ConcurrentHashMap();
    }

    public /* synthetic */ PlainReporter(PrintStream printStream, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        if ((n & 0x10) != 0) {
            bl4 = false;
        }
        this(printStream, bl, bl2, bl3, bl4);
    }

    public void afterAll() {
        Reporter.DefaultImpls.afterAll((Reporter)this);
    }

    public void before(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Reporter.DefaultImpls.before((Reporter)this, (String)file);
    }

    public void beforeAll() {
        Reporter.DefaultImpls.beforeAll((Reporter)this);
    }
}

