/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.klob.internal;

import com.github.shyiko.klob.Glob;
import com.github.shyiko.klob.internal.Glob;
import com.github.shyiko.klob.internal.GlobFileFilter;
import com.github.shyiko.klob.internal.HiddenFileFilter;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a(\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0000\u001a2\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0002\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0010H\u0000\u001a\u0014\u0010\u0011\u001a\u00020\n*\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0000\u00a8\u0006\u0013"}, d2={"fromSlash", "", "path", "slash", "visit", "Lkotlin/sequences/Sequence;", "Ljava/nio/file/Path;", "dir", "Ljava/io/File;", "filter", "Ljava/io/FileFilter;", "directoryModeFilter", "option", "Ljava/util/EnumSet;", "Lcom/github/shyiko/klob/Glob$IterationOption;", "patterns", "", "and", "fileFilter", "klob"})
public final class PackageKt {
    @NotNull
    public static final FileFilter and(@NotNull FileFilter $receiver, @NotNull FileFilter fileFilter) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)fileFilter, (String)"fileFilter");
        return new FileFilter($receiver, fileFilter){
            final /* synthetic */ FileFilter receiver$0;
            final /* synthetic */ FileFilter $fileFilter;

            public final boolean accept(File file) {
                return this.receiver$0.accept(file) && this.$fileFilter.accept(file);
            }
            {
                this.receiver$0 = fileFilter;
                this.$fileFilter = fileFilter2;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String slash(@NotNull String path) {
        void var2_2;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String it = string = StringsKt.replace$default((String)path, (char)'\\', (char)'/', (boolean)false, (int)4, null);
        return !StringsKt.startsWith$default((String)it, (String)"/", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)it, (CharSequence)":/", (boolean)false, (int)2, null) ? "/" + it : var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String fromSlash(@NotNull String path) {
        void var2_2;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String it = string = StringsKt.replace$default((String)path, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null);
        return StringsKt.contains$default((CharSequence)it, (CharSequence)":/", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)it, (CharSequence)"/") : var2_2;
    }

    @NotNull
    public static final Sequence<Path> visit(@NotNull File dir, @NotNull FileFilter filter, @Nullable FileFilter directoryModeFilter) {
        ArrayDeque<File> arrayDeque;
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
        ArrayDeque<File> $receiver = arrayDeque = new ArrayDeque<File>();
        $receiver.push(dir);
        ArrayDeque<File> stack = arrayDeque;
        return SequencesKt.generateSequence((Function0)((Function0)new Function0<Path>(stack, directoryModeFilter, filter){
            final /* synthetic */ ArrayDeque $stack;
            final /* synthetic */ FileFilter $directoryModeFilter;
            final /* synthetic */ FileFilter $filter;

            @Nullable
            public final Path invoke() {
                File file;
                while (true) {
                    if ((file = (File)this.$stack.pollLast()) == null || file.isFile() && this.$directoryModeFilter == null) {
                        File file2 = file;
                        return file2 != null ? file2.toPath() : null;
                    }
                    if (!file.isDirectory()) continue;
                    File[] fileList = file.listFiles(this.$filter);
                    ArraysKt.sortDescending((Comparable[])fileList);
                    if (fileList != null) {
                        CollectionsKt.addAll((Collection)this.$stack, (Object[])fileList);
                    }
                    if (this.$directoryModeFilter != null && this.$directoryModeFilter.accept(file)) break;
                }
                return file.toPath();
            }
            {
                this.$stack = arrayDeque;
                this.$directoryModeFilter = fileFilter;
                this.$filter = fileFilter2;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Sequence<Path> visit(@NotNull Path path, @NotNull EnumSet<Glob.IterationOption> option, @NotNull List<String> patterns) {
        String v;
        String it;
        String[] $receiver$iv$iv;
        GlobFileFilter globFileFilter;
        Object $receiver$iv;
        FileFilter filter;
        void $receiver$iv32422;
        GlobFileFilter globFileFilter2;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull(option, (String)"option");
        Intrinsics.checkParameterIsNotNull(patterns, (String)"patterns");
        boolean includeChildren = !option.contains((Object)Glob.IterationOption.SKIP_CHILDREN);
        boolean directoryMode = option.contains((Object)Glob.IterationOption.DIRECTORY);
        if (includeChildren && directoryMode) {
            throw (Throwable)new UnsupportedOperationException("Glob.IterationOption.DIRECTORY must be used together with Glob.IterationOption.SKIP_CHILDREN (please create a ticket at https://github.com/shyiko/klob/issue if it doesn't fit your needs)");
        }
        String baseDir = ((Object)path).toString();
        Collection collection = patterns;
        boolean bl = includeChildren;
        String string = baseDir;
        Sequence<Path> sequence = globFileFilter2;
        Object object = globFileFilter2;
        String[] thisCollection$iv = $receiver$iv32422;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray2 = stringArray;
        boolean $receiver$iv32422 = false;
        thisCollection$iv = Arrays.copyOf(stringArray2, stringArray2.length);
        boolean $i$f$toTypedArray = bl;
        sequence(string, thisCollection$iv, $i$f$toTypedArray, $receiver$iv32422, 8, null);
        GlobFileFilter $receiver$iv32422 = object;
        Object it2 = $receiver$iv32422;
        FileFilter fileFilter = filter = option.contains((Object)Glob.IterationOption.SKIP_HIDDEN) ? PackageKt.and((FileFilter)it2, new HiddenFileFilter(true)) : (FileFilter)it2;
        if (option.contains((Object)Glob.IterationOption.DIRECTORY)) {
            GlobFileFilter globFileFilter3;
            it2 = patterns;
            boolean bl2 = true;
            bl = includeChildren;
            string = baseDir;
            sequence = globFileFilter3;
            object = globFileFilter3;
            String[] thisCollection$iv232 = $receiver$iv;
            String[] stringArray3 = thisCollection$iv232.toArray(new String[thisCollection$iv232.size()]);
            if (stringArray3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray4 = stringArray3;
            globFileFilter = object;
            $receiver$iv = Arrays.copyOf(stringArray4, stringArray4.length);
            boolean thisCollection$iv232 = bl2;
            boolean $i$f$toTypedArray2 = bl;
            sequence(string, (String[])$receiver$iv, $i$f$toTypedArray2, thisCollection$iv232);
        } else {
            globFileFilter = null;
        }
        GlobFileFilter directoryModeFilter = globFileFilter;
        $receiver$iv = (String[])patterns;
        String[] thisCollection$iv232 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object t : $receiver$iv$iv) {
            String string2 = (String)t;
            object = destination$iv$iv;
            sequence = Glob.Companion.prefix(PackageKt.slash(it));
            object.add(sequence);
        }
        $receiver$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object t : $receiver$iv$iv) {
            it = (String)t;
            object = destination$iv$iv;
            sequence = (StringsKt.startsWith$default((String)it, (String)"/", (boolean)false, (int)2, null) ? new File(PackageKt.fromSlash(it)) : new File(baseDir, PackageKt.fromSlash(it))).getCanonicalPath();
            object.add(sequence);
        }
        $receiver$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        Object initial$iv = new ArrayList<void>();
        ArrayList<void> accumulator$iv = initial$iv;
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            it = (String)t;
            ArrayList<void> r = accumulator$iv;
            if (r.isEmpty() || !StringsKt.startsWith$default((String)v, (String)((String)CollectionsKt.last((List)r)), (boolean)false, (int)2, null)) {
                r.add((void)v);
            }
            accumulator$iv = r;
        }
        $receiver$iv = accumulator$iv;
        initial$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object t : $receiver$iv$iv) {
            v = (String)t;
            object = destination$iv$iv;
            sequence = PackageKt.visit(new File(it), filter, directoryModeFilter);
            object.add(sequence);
        }
        return SequencesKt.flatten((Sequence)CollectionsKt.asSequence((Iterable)((List)destination$iv$iv)));
    }
}

