/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import aQute.lib.osgi.Analyzer;
import aQute.libg.header.OSGiHeader;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.felix.bundleplugin.AbstractDependencyFilter;
import org.apache.felix.bundleplugin.BundlePlugin;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.StringUtils;

public final class DependencyEmbedder
extends AbstractDependencyFilter {
    public static final String EMBED_DEPENDENCY = "Embed-Dependency";
    public static final String EMBED_DIRECTORY = "Embed-Directory";
    public static final String EMBED_STRIP_GROUP = "Embed-StripGroup";
    public static final String EMBED_STRIP_VERSION = "Embed-StripVersion";
    public static final String EMBED_TRANSITIVE = "Embed-Transitive";
    private static final String MAVEN_DEPENDENCIES = "{maven-dependencies}";
    private String m_embedDirectory;
    private String m_embedStripGroup;
    private String m_embedStripVersion;
    private final Collection m_inlinedPaths = new HashSet();
    private final Collection m_embeddedArtifacts = new HashSet();

    public DependencyEmbedder(Collection dependencyArtifacts) {
        super(dependencyArtifacts);
    }

    public void processHeaders(Analyzer analyzer) throws MojoExecutionException {
        StringBuffer includeResource = new StringBuffer();
        StringBuffer bundleClassPath = new StringBuffer();
        this.m_inlinedPaths.clear();
        this.m_embeddedArtifacts.clear();
        String embedDependencyHeader = analyzer.getProperty(EMBED_DEPENDENCY);
        if (null != embedDependencyHeader && embedDependencyHeader.length() > 0) {
            this.m_embedDirectory = analyzer.getProperty(EMBED_DIRECTORY);
            this.m_embedStripGroup = analyzer.getProperty(EMBED_STRIP_GROUP, "true");
            this.m_embedStripVersion = analyzer.getProperty(EMBED_STRIP_VERSION);
            Map embedInstructions = OSGiHeader.parseHeader((String)embedDependencyHeader);
            this.processInstructions(embedInstructions);
            Iterator i = this.m_inlinedPaths.iterator();
            while (i.hasNext()) {
                DependencyEmbedder.inlineDependency((String)i.next(), includeResource);
            }
            i = this.m_embeddedArtifacts.iterator();
            while (i.hasNext()) {
                this.embedDependency((Artifact)i.next(), includeResource, bundleClassPath);
            }
        }
        if (bundleClassPath.length() > 0 && analyzer.getProperty("Bundle-ClassPath") == null) {
            analyzer.setProperty("Bundle-ClassPath", ".");
        }
        DependencyEmbedder.appendDependencies(analyzer, "Include-Resource", includeResource.toString());
        DependencyEmbedder.appendDependencies(analyzer, "Bundle-ClassPath", bundleClassPath.toString());
    }

    protected void processDependencies(String inline, Collection filteredDependencies) {
        if (null == inline || "false".equalsIgnoreCase(inline)) {
            this.m_embeddedArtifacts.addAll(filteredDependencies);
        } else {
            Iterator i = filteredDependencies.iterator();
            while (i.hasNext()) {
                DependencyEmbedder.addInlinedPaths((Artifact)i.next(), inline, this.m_inlinedPaths);
            }
        }
    }

    private static void addInlinedPaths(Artifact dependency, String inline, Collection inlinedPaths) {
        File path = dependency.getFile();
        if (null != path && path.exists()) {
            if ("true".equalsIgnoreCase(inline) || inline.length() == 0) {
                inlinedPaths.add(path.getPath());
            } else {
                String[] filters = inline.split("\\|");
                for (int i = 0; i < filters.length; ++i) {
                    if (filters[i].length() <= 0) continue;
                    inlinedPaths.add(path + "!/" + filters[i]);
                }
            }
        }
    }

    private void embedDependency(Artifact dependency, StringBuffer includeResource, StringBuffer bundleClassPath) {
        File sourceFile = dependency.getFile();
        if (null != sourceFile && sourceFile.exists()) {
            String extension;
            String embedDirectory = this.m_embedDirectory;
            if ("".equals(embedDirectory) || ".".equals(embedDirectory)) {
                embedDirectory = null;
            }
            if (!Boolean.valueOf(this.m_embedStripGroup).booleanValue()) {
                embedDirectory = new File(embedDirectory, dependency.getGroupId()).getPath();
            }
            File targetFile = Boolean.valueOf(this.m_embedStripVersion).booleanValue() ? ((extension = dependency.getArtifactHandler().getExtension()) != null ? new File(embedDirectory, dependency.getArtifactId() + "." + extension) : new File(embedDirectory, dependency.getArtifactId())) : new File(embedDirectory, sourceFile.getName());
            String targetFilePath = targetFile.getPath();
            if (File.separatorChar != '/') {
                targetFilePath = targetFilePath.replace(File.separatorChar, '/');
            }
            if (includeResource.length() > 0) {
                includeResource.append(',');
            }
            includeResource.append(targetFilePath);
            includeResource.append('=');
            includeResource.append(sourceFile);
            if (bundleClassPath.length() > 0) {
                bundleClassPath.append(',');
            }
            bundleClassPath.append(targetFilePath);
        }
    }

    private static void inlineDependency(String path, StringBuffer includeResource) {
        if (includeResource.length() > 0) {
            includeResource.append(',');
        }
        includeResource.append('@');
        includeResource.append(path);
    }

    public Collection getInlinedPaths() {
        return this.m_inlinedPaths;
    }

    public Collection getEmbeddedArtifacts() {
        return this.m_embeddedArtifacts;
    }

    private static void appendDependencies(Analyzer analyzer, String directiveName, String mavenDependencies) {
        String instruction = analyzer.getProperty(directiveName);
        if (instruction != null && instruction.length() > 0) {
            if (instruction.indexOf(MAVEN_DEPENDENCIES) >= 0) {
                if (mavenDependencies.length() == 0) {
                    String cleanInstruction = BundlePlugin.removeTagFromInstruction(instruction, MAVEN_DEPENDENCIES);
                    analyzer.setProperty(directiveName, cleanInstruction);
                } else {
                    String mergedInstruction = StringUtils.replace((String)instruction, (String)MAVEN_DEPENDENCIES, (String)mavenDependencies);
                    analyzer.setProperty(directiveName, mergedInstruction);
                }
            } else if (mavenDependencies.length() > 0) {
                if ("Include-Resource".equalsIgnoreCase(directiveName)) {
                    analyzer.setProperty(directiveName, mavenDependencies + ',' + instruction);
                } else {
                    analyzer.setProperty(directiveName, instruction + ',' + mavenDependencies);
                }
            }
        } else if (mavenDependencies.length() > 0) {
            analyzer.setProperty(directiveName, mavenDependencies);
        }
    }
}

