/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.ktlint.reporter.checkstyle;

import com.github.shyiko.ktlint.core.LintError;
import com.github.shyiko.ktlint.core.Reporter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00020\u0007*\u00020\u0007H\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/github/shyiko/ktlint/reporter/checkstyle/CheckStyleReporter;", "Lcom/github/shyiko/ktlint/core/Reporter;", "out", "Ljava/io/PrintStream;", "(Ljava/io/PrintStream;)V", "acc", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lcom/github/shyiko/ktlint/core/LintError;", "getOut", "()Ljava/io/PrintStream;", "afterAll", "", "onLintError", "file", "err", "corrected", "", "escapeXMLAttrValue", "ktlint-reporter-checkstyle"})
public final class CheckStyleReporter
implements Reporter {
    private final ConcurrentHashMap<String, List<LintError>> acc;
    @NotNull
    private final PrintStream out;

    public void onLintError(@NotNull String file, @NotNull LintError err, boolean corrected) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
        if (!corrected) {
            ConcurrentMap $receiver$iv = this.acc;
            Object object = $receiver$iv.get(file);
            if (object == null) {
                ArrayList arrayList = new ArrayList();
                ArrayList default$iv = arrayList;
                object = $receiver$iv.putIfAbsent(file, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            ((List)object).add(err);
        }
    }

    public void afterAll() {
        Iterable $receiver$iv;
        this.out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.out.println("<checkstyle version=\"8.0\">");
        Iterable iterable = $receiver$iv = (Iterable)this.acc.entrySet();
        Object object2 = new Comparator<T>(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                String string = (String)it.getKey();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        for (Map.Entry entry : CollectionsKt.sortedWith((Iterable)iterable, (Comparator)object2)) {
            object2 = entry;
            String file = (String)object2.getKey();
            object2 = entry;
            List errList = (List)object2.getValue();
            this.out.println("\t<file name=\"" + this.escapeXMLAttrValue(file) + "\">");
            for (Object object2 : errList) {
                int line = object2.component1();
                int col = object2.component2();
                String ruleId = object2.component3();
                String detail = object2.component4();
                this.out.println("\t\t<error line=\"" + line + "\" column=\"" + col + "\" severity=\"error\" message=\"" + this.escapeXMLAttrValue(detail) + "\" source=\"" + ruleId + "\" />");
            }
            this.out.println("\t</file>");
        }
        this.out.println("</checkstyle>");
    }

    private final String escapeXMLAttrValue(@NotNull String $receiver) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$receiver, (String)"&", (String)"&amp;", (boolean)false, (int)4, null), (String)"\"", (String)"&quot;", (boolean)false, (int)4, null), (String)"'", (String)"&apos;", (boolean)false, (int)4, null), (String)"<", (String)"&lt;", (boolean)false, (int)4, null), (String)">", (String)"&gt;", (boolean)false, (int)4, null);
    }

    @NotNull
    public final PrintStream getOut() {
        return this.out;
    }

    public CheckStyleReporter(@NotNull PrintStream out) {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        this.out = out;
        this.acc = new ConcurrentHashMap();
    }

    public void after(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Reporter.DefaultImpls.after((Reporter)this, (String)file);
    }

    public void before(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Reporter.DefaultImpls.before((Reporter)this, (String)file);
    }

    public void beforeAll() {
        Reporter.DefaultImpls.beforeAll((Reporter)this);
    }
}

