/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNLogEntryPath;

public class SVNLogEntry
implements Serializable {
    private long myRevision;
    private String myAuthor;
    private Date myDate;
    private String myMessage;
    private Map myChangedPaths;

    public SVNLogEntry(Map changedPaths, long revision, String author, Date date, String message) {
        this.myRevision = revision;
        this.myAuthor = author;
        this.myDate = date;
        this.myMessage = message;
        this.myChangedPaths = changedPaths;
    }

    public Map getChangedPaths() {
        return this.myChangedPaths;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public Date getDate() {
        return this.myDate;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(this.myRevision ^ this.myRevision >>> 32);
        result = 31 * result + (this.myAuthor == null ? 0 : this.myAuthor.hashCode());
        result = 31 * result + (this.myDate == null ? 0 : this.myDate.hashCode());
        result = 31 * result + (this.myMessage == null ? 0 : this.myMessage.hashCode());
        result = 31 * result + (this.myChangedPaths == null ? 0 : ((Object)this.myChangedPaths).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SVNLogEntry other = (SVNLogEntry)obj;
        return this.myRevision == other.myRevision && SVNLogEntry.compare(this.myAuthor, other.myAuthor) && SVNLogEntry.compare(this.myMessage, other.myMessage) && SVNLogEntry.compare(this.myDate, other.myDate) && SVNLogEntry.compare(this.myChangedPaths, other.myChangedPaths);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.myRevision);
        if (this.myDate != null) {
            result.append(' ');
            result.append(this.myDate);
        }
        if (this.myAuthor != null) {
            result.append(' ');
            result.append(this.myAuthor);
        }
        if (this.myMessage != null) {
            result.append('\n');
            result.append(this.myMessage);
        }
        if (this.myChangedPaths != null && !this.myChangedPaths.isEmpty()) {
            Iterator paths = this.myChangedPaths.values().iterator();
            while (paths.hasNext()) {
                result.append('\n');
                SVNLogEntryPath path = (SVNLogEntryPath)paths.next();
                result.append(path.toString());
            }
        }
        return result.toString();
    }

    static boolean compare(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }
}

