/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.io.fs.CountingStream;
import org.tmatesoft.svn.core.internal.io.fs.FSCopyInheritance;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChange;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChangeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNProperties;

public class FSTransactionRoot
extends FSRoot {
    public static final int SVN_FS_TXN_CHECK_OUT_OF_DATENESS = 1;
    public static final int SVN_FS_TXN_CHECK_LOCKS = 2;
    private static final int MAX_KEY_SIZE = 200;
    private String myTxnID;
    private int myTxnFlags;
    private File myTxnChangesFile;
    private File myTxnRevFile;

    public FSTransactionRoot(FSFS owner, String txnID, int flags) {
        super(owner);
        this.myTxnID = txnID;
        this.myTxnFlags = flags;
    }

    public FSCopyInheritance getCopyInheritance(FSParentPath child) throws SVNException {
        if (child == null || child.getParent() == null || this.myTxnID == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "FATAL error: invalid txn name or child");
            SVNErrorManager.error(err);
        }
        FSID childID = child.getRevNode().getId();
        FSID parentID = child.getParent().getRevNode().getId();
        String childCopyID = childID.getCopyID();
        String parentCopyID = parentID.getCopyID();
        if (childID.isTxn()) {
            return new FSCopyInheritance(1, null);
        }
        FSCopyInheritance copyInheritance = new FSCopyInheritance(2, null);
        if (childCopyID.compareTo("0") == 0) {
            return copyInheritance;
        }
        if (childCopyID.compareTo(parentCopyID) == 0) {
            return copyInheritance;
        }
        long copyrootRevision = child.getRevNode().getCopyRootRevision();
        String copyrootPath = child.getRevNode().getCopyRootPath();
        FSRevisionRoot copyrootRoot = this.getOwner().createRevisionRoot(copyrootRevision);
        FSRevisionNode copyrootNode = copyrootRoot.getRevisionNode(copyrootPath);
        FSID copyrootID = copyrootNode.getId();
        if (copyrootID.compareTo(childID) == -1) {
            return copyInheritance;
        }
        String idPath = child.getRevNode().getCreatedPath();
        if (idPath.compareTo(child.getAbsPath()) == 0) {
            copyInheritance.setStyle(1);
            return copyInheritance;
        }
        copyInheritance.setStyle(3);
        copyInheritance.setCopySourcePath(idPath);
        return copyInheritance;
    }

    public FSRevisionNode getRootRevisionNode() throws SVNException {
        if (this.myRootRevisionNode == null) {
            FSTransactionInfo txn = this.getTxn();
            this.myRootRevisionNode = this.getOwner().getRevisionNode(txn.getRootID());
        }
        return this.myRootRevisionNode;
    }

    public FSRevisionNode getTxnBaseRootNode() throws SVNException {
        FSTransactionInfo txn = this.getTxn();
        FSRevisionNode baseRootNode = this.getOwner().getRevisionNode(txn.getBaseID());
        return baseRootNode;
    }

    public FSTransactionInfo getTxn() throws SVNException {
        FSID rootID = FSID.createTxnId("0", "0", this.myTxnID);
        FSRevisionNode revNode = this.getOwner().getRevisionNode(rootID);
        FSTransactionInfo txn = new FSTransactionInfo(revNode.getId(), revNode.getPredecessorId());
        return txn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getChangedPaths() throws SVNException {
        FSFile file = this.getOwner().getTransactionChangesFile(this.myTxnID);
        try {
            Map map = this.fetchAllChanges(file, false);
            return map;
        }
        finally {
            file.close();
        }
    }

    public int getTxnFlags() {
        return this.myTxnFlags;
    }

    public void setTxnFlags(int txnFlags) {
        this.myTxnFlags = txnFlags;
    }

    public String getTxnID() {
        return this.myTxnID;
    }

    public Map unparseDirEntries(Map entries) {
        HashMap<String, String> unparsedEntries = new HashMap<String, String>();
        for (String name : entries.keySet()) {
            FSEntry dirEntry = (FSEntry)entries.get(name);
            String unparsedVal = dirEntry.toString();
            unparsedEntries.put(name, unparsedVal);
        }
        return unparsedEntries;
    }

    public static FSTransactionInfo beginTransaction(long baseRevision, int flags, FSFS owner) throws SVNException {
        FSTransactionInfo txn = FSTransactionRoot.createTxn(baseRevision, owner);
        String commitTime = SVNTimeUtil.formatDate(new Date(System.currentTimeMillis()));
        owner.setTransactionProperty(txn.getTxnId(), "svn:date", commitTime);
        if ((flags & 1) != 0) {
            owner.setTransactionProperty(txn.getTxnId(), "svn:check-ood", SVNProperty.toString(true));
        }
        if ((flags & 2) != 0) {
            owner.setTransactionProperty(txn.getTxnId(), "svn:check-locks", SVNProperty.toString(true));
        }
        return txn;
    }

    private static FSTransactionInfo createTxn(long baseRevision, FSFS owner) throws SVNException {
        String txnID = FSTransactionRoot.createTxnDir(baseRevision, owner);
        FSTransactionInfo txn = new FSTransactionInfo(baseRevision, txnID);
        FSRevisionRoot root = owner.createRevisionRoot(baseRevision);
        FSRevisionNode rootNode = root.getRootRevisionNode();
        owner.createNewTxnNodeRevisionFromRevision(txnID, rootNode);
        SVNFileUtil.createEmptyFile(new File(owner.getTransactionDir(txn.getTxnId()), "rev"));
        SVNFileUtil.createEmptyFile(new File(owner.getTransactionDir(txn.getTxnId()), "changes"));
        owner.writeNextIDs(txnID, "0", "0");
        return txn;
    }

    private static String createTxnDir(long revision, FSFS owner) throws SVNException {
        File parent = owner.getTransactionsParentDir();
        File uniquePath = null;
        for (int i = 1; i < 99999; ++i) {
            uniquePath = new File(parent, revision + "-" + i + ".txn");
            if (uniquePath.exists() || !uniquePath.mkdirs()) continue;
            return revision + "-" + i;
        }
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_UNIQUE_NAMES_EXHAUSTED, "Unable to create transaction directory in ''{0}'' for revision {1,number,integer}", new Object[]{parent, new Long(revision)});
        SVNErrorManager.error(err);
        return null;
    }

    public void deleteEntry(FSRevisionNode parent, String entryName) throws SVNException {
        Map entries;
        FSEntry dirEntry;
        SVNErrorMessage err;
        if (parent.getType() != SVNNodeKind.DIR) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_DIRECTORY, "Attempted to delete entry ''{0}'' from *non*-directory node", entryName);
            SVNErrorManager.error(err);
        }
        if (!parent.getId().isTxn()) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_MUTABLE, "Attempted to delete entry ''{0}'' from immutable directory node", entryName);
            SVNErrorManager.error(err);
        }
        if (!SVNPathUtil.isSinglePathComponent(entryName)) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_SINGLE_PATH_COMPONENT, "Attempted to delete a node with an illegal name ''{0}''", entryName);
            SVNErrorManager.error(err);
        }
        if ((dirEntry = (FSEntry)(entries = parent.getDirEntries(this.getOwner())).get(entryName)) == null) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_ENTRY, "Delete failed--directory has no entry ''{0}''", entryName);
            SVNErrorManager.error(err2);
        }
        this.getOwner().getRevisionNode(dirEntry.getId());
        this.deleteEntryIfMutable(dirEntry.getId());
        this.setEntry(parent, entryName, null, SVNNodeKind.UNKNOWN);
    }

    private void deleteEntryIfMutable(FSID id) throws SVNException {
        FSRevisionNode node = this.getOwner().getRevisionNode(id);
        if (!node.getId().isTxn()) {
            return;
        }
        if (node.getType() == SVNNodeKind.DIR) {
            Map entries = node.getDirEntries(this.getOwner());
            for (String name : entries.keySet()) {
                FSEntry entry = (FSEntry)entries.get(name);
                this.deleteEntryIfMutable(entry.getId());
            }
        }
        this.removeRevisionNode(id);
    }

    private void removeRevisionNode(FSID id) throws SVNException {
        FSRevisionNode node = this.getOwner().getRevisionNode(id);
        if (!node.getId().isTxn()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_MUTABLE, "Attempted removal of immutable node");
            SVNErrorManager.error(err);
        }
        if (node.getPropsRepresentation() != null && node.getPropsRepresentation().isTxn()) {
            SVNFileUtil.deleteFile(this.getTransactionRevNodePropsFile(id));
        }
        if (node.getTextRepresentation() != null && node.getTextRepresentation().isTxn() && node.getType() == SVNNodeKind.DIR) {
            SVNFileUtil.deleteFile(this.getTransactionRevNodeChildrenFile(id));
        }
        SVNFileUtil.deleteFile(this.getOwner().getTransactionRevNodeFile(id));
    }

    public void setProplist(FSRevisionNode node, Map properties) throws SVNException {
        if (!node.getId().isTxn()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_MUTABLE, "Can't set proplist on *immutable* node-revision {0}", node.getId());
            SVNErrorManager.error(err);
        }
        File propsFile = this.getTransactionRevNodePropsFile(node.getId());
        SVNProperties.setProperties(properties, propsFile, SVNFileUtil.createUniqueFile(propsFile.getParentFile(), ".props", ".tmp"), "END");
        if (node.getPropsRepresentation() == null || !node.getPropsRepresentation().isTxn()) {
            FSRepresentation mutableRep = new FSRepresentation();
            mutableRep.setTxnId(node.getId().getTxnID());
            node.setPropsRepresentation(mutableRep);
            this.getOwner().putTxnRevisionNode(node.getId(), node);
        }
    }

    public FSID createSuccessor(FSID oldId, FSRevisionNode newRevNode, String copyId) throws SVNException {
        if (copyId == null) {
            copyId = oldId.getCopyID();
        }
        FSID id = FSID.createTxnId(oldId.getNodeID(), copyId, this.myTxnID);
        newRevNode.setId(id);
        if (newRevNode.getCopyRootPath() == null) {
            newRevNode.setCopyRootPath(newRevNode.getCreatedPath());
            newRevNode.setCopyRootRevision(newRevNode.getId().getRevision());
        }
        this.getOwner().putTxnRevisionNode(newRevNode.getId(), newRevNode);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntry(FSRevisionNode parentRevNode, String entryName, FSID entryId, SVNNodeKind kind) throws SVNException {
        SVNErrorMessage err;
        if (parentRevNode.getType() != SVNNodeKind.DIR) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_DIRECTORY, "Attempted to set entry in non-directory node");
            SVNErrorManager.error(err);
        }
        if (!parentRevNode.getId().isTxn()) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_MUTABLE, "Attempted to set entry in immutable node");
            SVNErrorManager.error(err);
        }
        FSRepresentation textRep = parentRevNode.getTextRepresentation();
        File childrenFile = this.getTransactionRevNodeChildrenFile(parentRevNode.getId());
        OutputStream dst = null;
        try {
            if (textRep == null || !textRep.isTxn()) {
                Map entries = parentRevNode.getDirEntries(this.getOwner());
                Map unparsedEntries = this.unparseDirEntries(entries);
                dst = SVNFileUtil.openFileForWriting(childrenFile);
                SVNProperties.setProperties(unparsedEntries, dst, "END");
                textRep = new FSRepresentation();
                textRep.setRevision(-1L);
                textRep.setTxnId(this.myTxnID);
                parentRevNode.setTextRepresentation(textRep);
                this.getOwner().putTxnRevisionNode(parentRevNode.getId(), parentRevNode);
            } else {
                dst = SVNFileUtil.openFileForWriting(childrenFile, true);
            }
            Map dirContents = parentRevNode.getDirContents();
            if (entryId != null) {
                SVNProperties.appendProperty(entryName, kind + " " + entryId.toString(), dst);
                if (dirContents != null) {
                    dirContents.put(entryName, new FSEntry(entryId, kind, entryName));
                }
            } else {
                SVNProperties.appendPropertyDeleted(entryName, dst);
                if (dirContents != null) {
                    dirContents.remove(entryName);
                }
            }
        }
        catch (Throwable throwable) {
            SVNFileUtil.closeFile(dst);
            throw throwable;
        }
        SVNFileUtil.closeFile(dst);
    }

    public void writeChangeEntry(OutputStream changesFile, FSPathChange pathChange) throws SVNException, IOException {
        FSPathChangeKind changeKind = pathChange.getChangeKind();
        if (changeKind != FSPathChangeKind.FS_PATH_CHANGE_ADD && changeKind != FSPathChangeKind.FS_PATH_CHANGE_DELETE && changeKind != FSPathChangeKind.FS_PATH_CHANGE_MODIFY && changeKind != FSPathChangeKind.FS_PATH_CHANGE_REPLACE && changeKind != FSPathChangeKind.FS_PATH_CHANGE_RESET) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid change type");
            SVNErrorManager.error(err);
        }
        String changeString = changeKind.toString();
        String idString = null;
        idString = pathChange.getRevNodeId() != null ? pathChange.getRevNodeId().toString() : "reset";
        String output = idString + " " + changeString + " " + SVNProperty.toString(pathChange.isTextModified()) + " " + SVNProperty.toString(pathChange.arePropertiesModified()) + " " + pathChange.getPath() + "\n";
        changesFile.write(output.getBytes("UTF-8"));
        String copyfromPath = pathChange.getCopyPath();
        long copyfromRevision = pathChange.getCopyRevision();
        if (copyfromPath != null && copyfromRevision != -1L) {
            String copyfromLine = copyfromRevision + " " + copyfromPath;
            changesFile.write(copyfromLine.getBytes("UTF-8"));
        }
        changesFile.write("\n".getBytes("UTF-8"));
    }

    public long writeFinalChangedPathInfo(CountingStream protoFile) throws SVNException, IOException {
        long offset = protoFile.getPosition();
        Map changedPaths = this.getChangedPaths();
        for (String path : changedPaths.keySet()) {
            FSPathChange change = (FSPathChange)changedPaths.get(path);
            FSID id = change.getRevNodeId();
            if (change.getChangeKind() != FSPathChangeKind.FS_PATH_CHANGE_DELETE && !id.isTxn()) {
                FSRevisionNode revNode = this.getOwner().getRevisionNode(id);
                change.setRevNodeId(revNode.getId());
            }
            this.writeChangeEntry(protoFile, change);
        }
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] readNextIDs() throws SVNException {
        String[] ids = new String[2];
        String idsToParse = null;
        FSFile idsFile = new FSFile(this.getOwner().getNextIDsFile(this.myTxnID));
        try {
            idsToParse = idsFile.readLine(403);
        }
        finally {
            idsFile.close();
        }
        int delimiterInd = idsToParse.indexOf(32);
        if (delimiterInd == -1) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "next-ids file corrupt");
            SVNErrorManager.error(err);
        }
        ids[0] = idsToParse.substring(0, delimiterInd);
        ids[1] = idsToParse.substring(delimiterInd + 1);
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFinalCurrentFile(long newRevision, String startNodeId, String startCopyId) throws SVNException, IOException {
        String[] txnIds = this.readNextIDs();
        String txnNodeId = txnIds[0];
        String txnCopyId = txnIds[1];
        String newNodeId = FSTransactionRoot.addKeys(startNodeId, txnNodeId);
        String newCopyId = FSTransactionRoot.addKeys(startCopyId, txnCopyId);
        String line = newRevision + " " + newNodeId + " " + newCopyId + "\n";
        File currentFile = this.getOwner().getCurrentFile();
        File tmpCurrentFile = SVNFileUtil.createUniqueFile(currentFile.getParentFile(), ".txnfile", ".tmp");
        OutputStream currentOS = null;
        try {
            currentOS = SVNFileUtil.openFileForWriting(tmpCurrentFile);
            currentOS.write(line.getBytes("UTF-8"));
        }
        finally {
            SVNFileUtil.closeFile(currentOS);
        }
        SVNFileUtil.rename(tmpCurrentFile, currentFile);
    }

    public FSID writeFinalRevision(FSID newId, CountingStream protoFile, long revision, FSID id, String startNodeId, String startCopyId) throws SVNException, IOException {
        newId = null;
        if (!id.isTxn()) {
            return newId;
        }
        FSFS owner = this.getOwner();
        FSRevisionNode revNode = owner.getRevisionNode(id);
        if (revNode.getType() == SVNNodeKind.DIR) {
            Map namesToEntries = revNode.getDirEntries(owner);
            for (FSEntry dirEntry : namesToEntries.values()) {
                if ((newId = this.writeFinalRevision(newId, protoFile, revision, dirEntry.getId(), startNodeId, startCopyId)) == null || newId.getRevision() != revision) continue;
                dirEntry.setId(newId);
            }
            if (revNode.getTextRepresentation() != null && revNode.getTextRepresentation().isTxn()) {
                Map unparsedEntries = this.unparseDirEntries(namesToEntries);
                FSRepresentation textRep = revNode.getTextRepresentation();
                textRep.setTxnId(null);
                textRep.setRevision(revision);
                try {
                    textRep.setOffset(protoFile.getPosition());
                    MessageDigest checksum = MessageDigest.getInstance("MD5");
                    long size = this.writeHashRepresentation(unparsedEntries, protoFile, checksum);
                    String hexDigest = SVNFileUtil.toHexDigest(checksum);
                    textRep.setSize(size);
                    textRep.setHexDigest(hexDigest);
                    textRep.setExpandedSize(textRep.getSize());
                }
                catch (NoSuchAlgorithmException nsae) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", nsae.getLocalizedMessage());
                    SVNErrorManager.error(err, nsae);
                }
            }
        } else if (revNode.getTextRepresentation() != null && revNode.getTextRepresentation().isTxn()) {
            FSRepresentation textRep = revNode.getTextRepresentation();
            textRep.setTxnId(null);
            textRep.setRevision(revision);
        }
        if (revNode.getPropsRepresentation() != null && revNode.getPropsRepresentation().isTxn()) {
            Map props = revNode.getProperties(owner);
            FSRepresentation propsRep = revNode.getPropsRepresentation();
            try {
                propsRep.setOffset(protoFile.getPosition());
                MessageDigest checksum = MessageDigest.getInstance("MD5");
                long size = this.writeHashRepresentation(props, protoFile, checksum);
                String hexDigest = SVNFileUtil.toHexDigest(checksum);
                propsRep.setSize(size);
                propsRep.setHexDigest(hexDigest);
                propsRep.setTxnId(null);
                propsRep.setRevision(revision);
                propsRep.setExpandedSize(size);
            }
            catch (NoSuchAlgorithmException nsae) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", nsae.getLocalizedMessage());
                SVNErrorManager.error(err, nsae);
            }
        }
        long myOffset = protoFile.getPosition();
        String myNodeId = null;
        String nodeId = revNode.getId().getNodeID();
        myNodeId = nodeId.startsWith("_") ? FSTransactionRoot.addKeys(startNodeId, nodeId.substring(1)) : nodeId;
        String myCopyId = null;
        String copyId = revNode.getId().getCopyID();
        myCopyId = copyId.startsWith("_") ? FSTransactionRoot.addKeys(startCopyId, copyId.substring(1)) : copyId;
        if (revNode.getCopyRootRevision() == -1L) {
            revNode.setCopyRootRevision(revision);
        }
        newId = FSID.createRevId(myNodeId, myCopyId, revision, myOffset);
        revNode.setId(newId);
        this.getOwner().writeTxnNodeRevision(protoFile, revNode);
        this.getOwner().putTxnRevisionNode(id, revNode);
        return newId;
    }

    public FSRevisionNode cloneChild(FSRevisionNode parent, String parentPath, String childName, String copyId, boolean isParentCopyRoot) throws SVNException {
        SVNErrorMessage err;
        if (!parent.getId().isTxn()) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_MUTABLE, "Attempted to clone child of non-mutable node");
            SVNErrorManager.error(err);
        }
        if (!SVNPathUtil.isSinglePathComponent(childName)) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_SINGLE_PATH_COMPONENT, "Attempted to make a child clone with an illegal name ''{0}''", childName);
            SVNErrorManager.error(err);
        }
        FSRevisionNode childNode = parent.getChildDirNode(childName, this.getOwner());
        FSID newNodeId = null;
        if (childNode.getId().isTxn()) {
            newNodeId = childNode.getId();
        } else {
            if (isParentCopyRoot) {
                childNode.setCopyRootPath(parent.getCopyRootPath());
                childNode.setCopyRootRevision(parent.getCopyRootRevision());
            }
            childNode.setCopyFromPath(null);
            childNode.setCopyFromRevision(-1L);
            childNode.setPredecessorId(childNode.getId());
            if (childNode.getCount() != -1L) {
                childNode.setCount(childNode.getCount() + 1L);
            }
            childNode.setCreatedPath(SVNPathUtil.concatToAbs(parentPath, childName));
            newNodeId = this.createSuccessor(childNode.getId(), childNode, copyId);
            this.setEntry(parent, childName, newNodeId, childNode.getType());
        }
        return this.getOwner().getRevisionNode(newNodeId);
    }

    private long writeHashRepresentation(Map hashContents, OutputStream protoFile, MessageDigest digest) throws IOException, SVNException {
        HashRepresentationStream targetFile = new HashRepresentationStream(protoFile, digest);
        String header = "PLAIN\n";
        protoFile.write(header.getBytes("UTF-8"));
        SVNProperties.setProperties(hashContents, targetFile, "END");
        String trailer = "ENDREP\n";
        protoFile.write(trailer.getBytes("UTF-8"));
        return targetFile.mySize;
    }

    public File getTransactionRevNodePropsFile(FSID id) {
        return new File(this.getOwner().getTransactionDir(id.getTxnID()), "node." + id.getNodeID() + "." + id.getCopyID() + ".props");
    }

    public File getTransactionRevNodeChildrenFile(FSID id) {
        return new File(this.getOwner().getTransactionDir(id.getTxnID()), "node." + id.getNodeID() + "." + id.getCopyID() + ".children");
    }

    public File getTransactionRevFile() {
        if (this.myTxnRevFile == null) {
            this.myTxnRevFile = new File(this.getOwner().getTransactionDir(this.myTxnID), "rev");
        }
        return this.myTxnRevFile;
    }

    public File getTransactionChangesFile() {
        if (this.myTxnChangesFile == null) {
            this.myTxnChangesFile = new File(this.getOwner().getTransactionDir(this.myTxnID), "changes");
        }
        return this.myTxnChangesFile;
    }

    public static String generateNextKey(String oldKey) throws SVNException {
        char[] nextKey = new char[oldKey.length() + 1];
        boolean carry = true;
        if (oldKey.length() > 1 && oldKey.charAt(0) == '0') {
            return null;
        }
        for (int i = oldKey.length() - 1; i >= 0; --i) {
            char c = oldKey.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z')) {
                return null;
            }
            if (carry) {
                if (c == 'z') {
                    nextKey[i] = 48;
                    continue;
                }
                carry = false;
                if (c == '9') {
                    nextKey[i] = 97;
                    continue;
                }
                nextKey[i] = (char)(c + '\u0001');
                continue;
            }
            nextKey[i] = c;
        }
        int nextKeyLength = oldKey.length() + (carry ? 1 : 0);
        if (nextKeyLength >= 200) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "FATAL error: new key length is greater than the threshold {0,number,integer}", new Integer(200));
            SVNErrorManager.error(err);
        }
        if (carry) {
            System.arraycopy(nextKey, 0, nextKey, 1, oldKey.length());
            nextKey[0] = 49;
        }
        return new String(nextKey, 0, nextKeyLength);
    }

    private static String addKeys(String key1, String key2) {
        int i1 = key1.length() - 1;
        int i2 = key2.length() - 1;
        int carry = 0;
        StringBuffer result = new StringBuffer();
        while (i1 >= 0 || i2 >= 0 || carry > 0) {
            int val = carry;
            if (i1 >= 0) {
                val += key1.charAt(i1) <= '9' ? key1.charAt(i1) - 48 : key1.charAt(i1) - 97 + 10;
            }
            if (i2 >= 0) {
                val += key2.charAt(i2) <= '9' ? key2.charAt(i2) - 48 : key2.charAt(i2) - 97 + 10;
            }
            carry = val / 36;
            char sym = (val %= 36) <= 9 ? (char)(48 + val) : (char)(val - 10 + 97);
            result.append(sym);
            if (i1 >= 0) {
                --i1;
            }
            if (i2 < 0) continue;
            --i2;
        }
        return result.reverse().toString();
    }

    private static class HashRepresentationStream
    extends OutputStream {
        long mySize = 0L;
        MessageDigest myChecksum;
        OutputStream myProtoFile;

        public HashRepresentationStream(OutputStream protoFile, MessageDigest digest) {
            this.myChecksum = digest;
            this.myProtoFile = protoFile;
        }

        public void write(int b) throws IOException {
            this.myProtoFile.write(b);
            if (this.myChecksum != null) {
                this.myChecksum.update((byte)b);
            }
            ++this.mySize;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.myProtoFile.write(b, off, len);
            if (this.myChecksum != null) {
                this.myChecksum.update(b, off, len);
            }
            this.mySize += (long)len;
        }

        public void write(byte[] b) throws IOException {
            this.myProtoFile.write(b);
            if (this.myChecksum != null) {
                this.myChecksum.update(b);
            }
            this.mySize += (long)b.length;
        }
    }
}

