/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSInputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.PathInfo;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.util.SVNDebugLog;

public class FSUpdateContext {
    private File myReportFile;
    private String myTarget;
    private OutputStream myReportOS;
    private FSFile myReportIS;
    private ISVNEditor myEditor;
    private long myTargetRevision;
    private boolean isRecursive;
    private PathInfo myCurrentPathInfo;
    private boolean ignoreAncestry;
    private boolean sendTextDeltas;
    private String myTargetPath;
    private boolean isSwitch;
    private FSRevisionRoot myTargetRoot;
    private LinkedList myRootsCache;
    private FSFS myFSFS;
    private FSRepository myRepository;
    private SVNDeltaGenerator myDeltaGenerator;
    private SVNDeltaCombiner myDeltaCombiner;

    public FSUpdateContext(FSRepository repository, FSFS owner, long revision, File reportFile, String target, String targetPath, boolean isSwitch, boolean recursive, boolean ignoreAncestry, boolean textDeltas, ISVNEditor editor) {
        this.myRepository = repository;
        this.myFSFS = owner;
        this.myTargetRevision = revision;
        this.myReportFile = reportFile;
        this.myTarget = target;
        this.myEditor = editor;
        this.isRecursive = recursive;
        this.ignoreAncestry = ignoreAncestry;
        this.sendTextDeltas = textDeltas;
        this.myTargetPath = targetPath;
        this.isSwitch = isSwitch;
    }

    public void reset(FSRepository repository, FSFS owner, long revision, File reportFile, String target, String targetPath, boolean isSwitch, boolean recursive, boolean ignoreAncestry, boolean textDeltas, ISVNEditor editor) throws SVNException {
        this.dispose();
        this.myRepository = repository;
        this.myFSFS = owner;
        this.myTargetRevision = revision;
        this.myReportFile = reportFile;
        this.myTarget = target;
        this.myEditor = editor;
        this.isRecursive = recursive;
        this.ignoreAncestry = ignoreAncestry;
        this.sendTextDeltas = textDeltas;
        this.myTargetPath = targetPath;
        this.isSwitch = isSwitch;
    }

    public OutputStream getReportFileForWriting() throws SVNException {
        if (this.myReportOS == null) {
            this.myReportOS = SVNFileUtil.openFileForWriting(this.myReportFile);
        }
        return this.myReportOS;
    }

    private boolean isIgnoreAncestry() {
        return this.ignoreAncestry;
    }

    private boolean isSwitch() {
        return this.isSwitch;
    }

    private boolean isSendTextDeltas() {
        return this.sendTextDeltas;
    }

    private String getReportTarget() {
        return this.myTarget;
    }

    private String getReportTargetPath() {
        return this.myTargetPath;
    }

    public void dispose() throws SVNException {
        SVNFileUtil.closeFile(this.myReportOS);
        this.myReportOS = null;
        if (this.myReportIS != null) {
            this.myReportIS.close();
            this.myReportIS = null;
        }
        if (this.myReportFile != null) {
            SVNFileUtil.deleteFile(this.myReportFile);
            this.myReportFile = null;
        }
        if (this.myDeltaCombiner != null) {
            this.myDeltaCombiner.reset();
        }
        this.myTargetRoot = null;
        this.myRootsCache = null;
    }

    private ISVNEditor getEditor() {
        return this.myEditor;
    }

    private boolean isRecursive() {
        return this.isRecursive;
    }

    private long getTargetRevision() {
        return this.myTargetRevision;
    }

    private PathInfo getNextPathInfo() throws IOException {
        if (this.myReportIS == null) {
            this.myReportIS = new FSFile(this.myReportFile);
        }
        this.myCurrentPathInfo = this.myReportIS.readPathInfoFromReportFile();
        return this.myCurrentPathInfo;
    }

    private PathInfo getCurrentPathInfo() {
        return this.myCurrentPathInfo;
    }

    private FSRevisionRoot getTargetRoot() {
        if (this.myTargetRoot == null) {
            this.myTargetRoot = this.myFSFS.createRevisionRoot(this.myTargetRevision);
        }
        return this.myTargetRoot;
    }

    private LinkedList getRootsCache() {
        if (this.myRootsCache == null) {
            this.myRootsCache = new LinkedList();
        }
        return this.myRootsCache;
    }

    private FSRevisionRoot getSourceRoot(long revision) {
        int i;
        LinkedList cache = this.getRootsCache();
        FSRevisionRoot root = null;
        for (i = 0; i < cache.size() && i < 10; ++i) {
            root = (FSRevisionRoot)this.myRootsCache.get(i);
            if (root.getRevision() == revision) {
                if (i == 0) break;
                this.myRootsCache.remove(i);
                this.myRootsCache.addFirst(root);
                break;
            }
            root = null;
        }
        if (root == null) {
            if (i == 10) {
                this.myRootsCache.removeLast();
            }
            root = this.myFSFS.createRevisionRoot(revision);
            this.myRootsCache.addFirst(root);
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drive() throws SVNException {
        SVNErrorMessage err;
        SVNErrorMessage err2;
        OutputStream reportOS = this.getReportFileForWriting();
        try {
            reportOS.write(45);
        }
        catch (IOException ioe) {
            err2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err2, ioe);
        }
        finally {
            SVNFileUtil.closeFile(reportOS);
        }
        PathInfo info = null;
        try {
            info = this.getNextPathInfo();
        }
        catch (IOException ioe) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err3, ioe);
        }
        if (info == null || !info.getPath().equals(this.getReportTarget()) || info.getLinkPath() != null || FSRepository.isInvalidRevision(info.getRevision())) {
            err2 = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_REVISION_REPORT, "Invalid report for top level of working copy");
            SVNErrorManager.error(err2);
        }
        long sourceRevision = info.getRevision();
        PathInfo lookahead = null;
        try {
            lookahead = this.getNextPathInfo();
        }
        catch (IOException ioe) {
            err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe);
        }
        if (lookahead != null && lookahead.getPath().equals(this.getReportTarget())) {
            if ("".equals(this.getReportTarget())) {
                SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_REVISION_REPORT, "Two top-level reports with no target");
                SVNErrorManager.error(err4);
            }
            info = lookahead;
            try {
                this.getNextPathInfo();
            }
            catch (IOException ioe) {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                SVNErrorManager.error(err, ioe);
            }
        }
        this.getEditor().targetRevision(this.getTargetRevision());
        String fullTargetPath = this.getReportTargetPath();
        String fullSourcePath = SVNPathUtil.concatToAbs(this.myRepository.getRepositoryPath(""), this.getReportTarget());
        FSEntry targetEntry = this.fakeDirEntry(fullTargetPath, this.getTargetRoot());
        FSRevisionRoot srcRoot = this.getSourceRoot(sourceRevision);
        FSEntry sourceEntry = this.fakeDirEntry(fullSourcePath, srcRoot);
        if (FSRepository.isValidRevision(info.getRevision()) && info.getLinkPath() == null && sourceEntry == null) {
            fullSourcePath = null;
        }
        if ("".equals(this.getReportTarget()) && (sourceEntry == null || sourceEntry.getType() != SVNNodeKind.DIR || targetEntry == null || targetEntry.getType() != SVNNodeKind.DIR)) {
            SVNErrorMessage err5 = SVNErrorMessage.create(SVNErrorCode.FS_PATH_SYNTAX, "Cannot replace a directory from within");
            SVNErrorManager.error(err5);
        }
        if (this.myDeltaGenerator == null) {
            this.myDeltaGenerator = new SVNDeltaGenerator();
        }
        if (this.myDeltaCombiner == null) {
            this.myDeltaCombiner = new SVNDeltaCombiner();
        }
        this.getEditor().openRoot(sourceRevision);
        if ("".equals(this.getReportTarget())) {
            this.diffDirs(sourceRevision, fullSourcePath, fullTargetPath, "", info.isStartEmpty());
        } else {
            this.updateEntry(sourceRevision, fullSourcePath, sourceEntry, fullTargetPath, targetEntry, this.getReportTarget(), info, true);
        }
        this.getEditor().closeDir();
        this.getEditor().closeEdit();
    }

    private void diffDirs(long sourceRevision, String sourcePath, String targetPath, String editPath, boolean startEmpty) throws SVNException {
        String entryEditPath;
        Object[] nextInfo;
        String entryName;
        this.diffProplists(sourceRevision, startEmpty ? null : sourcePath, editPath, targetPath, null, true);
        HashMap sourceEntries = null;
        if (sourcePath != null && !startEmpty) {
            FSRevisionRoot sourceRoot = this.getSourceRoot(sourceRevision);
            FSRevisionNode sourceNode = sourceRoot.getRevisionNode(sourcePath);
            sourceEntries = new HashMap(sourceNode.getDirEntries(this.myFSFS));
        }
        FSRevisionNode targetNode = this.getTargetRoot().getRevisionNode(targetPath);
        HashMap targetEntries = new HashMap(targetNode.getDirEntries(this.myFSFS));
        while ((entryName = (String)(nextInfo = this.fetchPathInfo(editPath))[0]) != null) {
            PathInfo pathInfo = (PathInfo)nextInfo[1];
            if (pathInfo != null && FSRepository.isInvalidRevision(pathInfo.getRevision())) {
                if (sourceEntries == null) continue;
                sourceEntries.remove(entryName);
                continue;
            }
            entryEditPath = SVNPathUtil.append(editPath, entryName);
            String entryTargetPath = SVNPathUtil.concatToAbs(targetPath, entryName);
            FSEntry targetEntry = (FSEntry)targetEntries.get(entryName);
            String entrySourcePath = sourcePath != null ? SVNPathUtil.concatToAbs(sourcePath, entryName) : null;
            FSEntry sourceEntry = sourceEntries != null ? (FSEntry)sourceEntries.get(entryName) : null;
            this.updateEntry(sourceRevision, entrySourcePath, sourceEntry, entryTargetPath, targetEntry, entryEditPath, pathInfo, this.isRecursive());
            targetEntries.remove(entryName);
            if (sourceEntries == null) continue;
            sourceEntries.remove(entryName);
        }
        if (sourceEntries != null) {
            Object[] srcEntries = new ArrayList(sourceEntries.values()).toArray(new FSEntry[sourceEntries.size()]);
            Arrays.sort(srcEntries);
            for (int i = 0; i < srcEntries.length; ++i) {
                Object srcEntry = srcEntries[i];
                if (targetEntries.get(((FSEntry)srcEntry).getName()) != null) continue;
                entryEditPath = SVNPathUtil.append(editPath, ((FSEntry)srcEntry).getName());
                if (!this.isRecursive() && ((FSEntry)srcEntry).getType() == SVNNodeKind.DIR) continue;
                this.getEditor().deleteEntry(entryEditPath, -1L);
            }
        }
        FSEntry[] tgtEntries = new ArrayList(targetEntries.values()).toArray(new FSEntry[targetEntries.size()]);
        final HashMap srcMap = sourceEntries;
        Arrays.sort(tgtEntries, new Comparator(){

            public int compare(Object o1, Object o2) {
                boolean has2Src;
                boolean has1Src;
                FSEntry e1 = (FSEntry)o1;
                FSEntry e2 = (FSEntry)o2;
                if (srcMap != null && (has1Src = srcMap.containsKey(e1.getName())) != (has2Src = srcMap.containsKey(e2.getName()))) {
                    return has1Src ? 1 : -1;
                }
                return e1.compareTo(e2);
            }
        });
        for (int i = 0; i < tgtEntries.length; ++i) {
            FSEntry tgtEntry = tgtEntries[i];
            String entryEditPath2 = SVNPathUtil.append(editPath, tgtEntry.getName());
            String entryTargetPath = SVNPathUtil.concatToAbs(targetPath, tgtEntry.getName());
            FSEntry srcEntry = sourceEntries != null ? (FSEntry)sourceEntries.get(tgtEntry.getName()) : null;
            String entrySourcePath = srcEntry != null ? SVNPathUtil.concatToAbs(sourcePath, tgtEntry.getName()) : null;
            this.updateEntry(sourceRevision, entrySourcePath, srcEntry, entryTargetPath, tgtEntry, entryEditPath2, null, this.isRecursive());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void diffFiles(long sourceRevision, String sourcePath, String targetPath, String editPath, String lockToken) throws SVNException {
        block5: {
            block4: {
                this.diffProplists(sourceRevision, sourcePath, editPath, targetPath, lockToken, false);
                String sourceHexDigest = null;
                FSRevisionRoot sourceRoot = null;
                if (sourcePath != null) {
                    sourceRoot = this.getSourceRoot(sourceRevision);
                    boolean changed = false;
                    changed = this.isIgnoreAncestry() ? this.checkFilesDifferent(sourceRoot, sourcePath, this.getTargetRoot(), targetPath) : FSRepositoryUtil.areFileContentsChanged(sourceRoot, sourcePath, this.getTargetRoot(), targetPath);
                    if (!changed) {
                        return;
                    }
                    FSRevisionNode sourceNode = sourceRoot.getRevisionNode(sourcePath);
                    sourceHexDigest = sourceNode.getFileChecksum();
                }
                this.getEditor().applyTextDelta(editPath, sourceHexDigest);
                if (!this.isSendTextDeltas()) break block4;
                InputStream sourceStream = null;
                InputStream targetStream = null;
                try {
                    sourceStream = sourceRoot != null && sourcePath != null ? sourceRoot.getFileStreamForPath(this.myDeltaCombiner, sourcePath) : FSInputStream.createDeltaStream(this.myDeltaCombiner, (FSRevisionNode)null, this.myFSFS);
                    targetStream = this.getTargetRoot().getFileStreamForPath(this.myDeltaCombiner, targetPath);
                    this.myDeltaGenerator.sendDelta(editPath, sourceStream, 0L, targetStream, this.getEditor(), false);
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(sourceStream);
                    SVNFileUtil.closeFile(targetStream);
                    throw throwable;
                }
                SVNFileUtil.closeFile(sourceStream);
                SVNFileUtil.closeFile(targetStream);
                break block5;
            }
            this.getEditor().textDeltaEnd(editPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkFilesDifferent(FSRoot root1, String path1, FSRoot root2, String path2) throws SVNException {
        changed = FSRepositoryUtil.areFileContentsChanged(root1, path1, root2, path2);
        if (!changed) {
            return false;
        }
        revNode1 = root1.getRevisionNode(path1);
        revNode2 = root2.getRevisionNode(path2);
        if (revNode1.getFileLength() != revNode2.getFileLength()) {
            return true;
        }
        if (!revNode1.getFileChecksum().equals(revNode2.getFileChecksum())) {
            return true;
        }
        file1IS = null;
        file2IS = null;
        try {
            file1IS = root1.getFileStreamForPath(this.myDeltaCombiner, path1);
            file2IS = root2.getFileStreamForPath(this.myDeltaCombiner, path2);
            r1 = -1;
            r2 = -1;
            while (true) {
                r1 = file1IS.read();
                if (r1 == (r2 = file2IS.read())) continue;
                var12_14 = true;
                ** GOTO lbl31
                break;
            }
        }
        catch (IOException ioe) {
            try {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                SVNErrorManager.error(err, ioe);
            }
            catch (Throwable var13_15) {
                SVNFileUtil.closeFile(file1IS);
                SVNFileUtil.closeFile(file2IS);
                throw var13_15;
            }
lbl31:
            // 1 sources

            SVNFileUtil.closeFile(file1IS);
            SVNFileUtil.closeFile(file2IS);
            return var12_14;
            {
                if (r1 != -1) ** continue;
            }
            SVNFileUtil.closeFile(file1IS);
            SVNFileUtil.closeFile(file2IS);
            return false;
            SVNFileUtil.closeFile(file1IS);
            SVNFileUtil.closeFile(file2IS);
            return false;
        }
    }

    private void updateEntry(long sourceRevision, String sourcePath, FSEntry sourceEntry, String targetPath, FSEntry targetEntry, String editPath, PathInfo pathInfo, boolean recursive) throws SVNException {
        if (pathInfo != null && pathInfo.getLinkPath() != null && !this.isSwitch()) {
            targetPath = pathInfo.getLinkPath();
            targetEntry = this.fakeDirEntry(targetPath, this.getTargetRoot());
        }
        if (pathInfo != null && FSRepository.isInvalidRevision(pathInfo.getRevision())) {
            sourcePath = null;
            sourceEntry = null;
        } else if (pathInfo != null && sourcePath != null) {
            sourcePath = pathInfo.getLinkPath() != null ? pathInfo.getLinkPath() : sourcePath;
            sourceRevision = pathInfo.getRevision();
            FSRevisionRoot srcRoot = this.getSourceRoot(sourceRevision);
            sourceEntry = this.fakeDirEntry(sourcePath, srcRoot);
        }
        if (sourcePath != null && sourceEntry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Working copy path ''{0}'' does not exist in repository", editPath);
            SVNErrorManager.error(err);
        }
        if (!recursive && (sourceEntry != null && sourceEntry.getType() == SVNNodeKind.DIR || targetEntry != null && targetEntry.getType() == SVNNodeKind.DIR)) {
            this.skipPathInfo(editPath);
            return;
        }
        boolean related = false;
        if (sourceEntry != null && targetEntry != null && sourceEntry.getType() == targetEntry.getType()) {
            int distance = sourceEntry.getId().compareTo(targetEntry.getId());
            if (distance == 0 && !PathInfo.isRelevant(this.getCurrentPathInfo(), editPath) && (pathInfo == null || !pathInfo.isStartEmpty() && pathInfo.getLockToken() == null)) {
                return;
            }
            if (distance != -1 || this.isIgnoreAncestry()) {
                related = true;
            }
        }
        if (sourceEntry != null && !related) {
            this.getEditor().deleteEntry(editPath, -1L);
            sourcePath = null;
        }
        if (targetEntry == null) {
            this.skipPathInfo(editPath);
            return;
        }
        if (targetEntry.getType() == SVNNodeKind.DIR) {
            if (related) {
                this.getEditor().openDir(editPath, sourceRevision);
            } else {
                this.getEditor().addDir(editPath, null, -1L);
            }
            this.diffDirs(sourceRevision, sourcePath, targetPath, editPath, pathInfo != null ? pathInfo.isStartEmpty() : false);
            this.getEditor().closeDir();
        } else {
            SVNDebugLog.getDefaultLog().info("processing file: " + editPath);
            if (related) {
                this.getEditor().openFile(editPath, sourceRevision);
            } else {
                this.getEditor().addFile(editPath, null, -1L);
            }
            this.diffFiles(sourceRevision, sourcePath, targetPath, editPath, pathInfo != null ? pathInfo.getLockToken() : null);
            FSRevisionNode targetNode = this.getTargetRoot().getRevisionNode(targetPath);
            String targetHexDigest = targetNode.getFileChecksum();
            this.getEditor().closeFile(editPath, targetHexDigest);
        }
    }

    private void diffProplists(long sourceRevision, String sourcePath, String editPath, String targetPath, String lockToken, boolean isDir) throws SVNException {
        SVNLock lock;
        FSRevisionNode targetNode = this.getTargetRoot().getRevisionNode(targetPath);
        long createdRevision = targetNode.getId().getRevision();
        if (FSRepository.isValidRevision(createdRevision)) {
            String uuid;
            String lastAuthor;
            Map entryProps = this.myFSFS.compoundMetaProperties(createdRevision);
            this.changeProperty(editPath, "svn:entry:committed-rev", (String)entryProps.get("svn:entry:committed-rev"), isDir);
            String committedDate = (String)entryProps.get("svn:entry:committed-date");
            if (committedDate != null || sourcePath != null) {
                this.changeProperty(editPath, "svn:entry:committed-date", committedDate, isDir);
            }
            if ((lastAuthor = (String)entryProps.get("svn:entry:last-author")) != null || sourcePath != null) {
                this.changeProperty(editPath, "svn:entry:last-author", lastAuthor, isDir);
            }
            if ((uuid = (String)entryProps.get("svn:entry:uuid")) != null || sourcePath != null) {
                this.changeProperty(editPath, "svn:entry:uuid", uuid, isDir);
            }
        }
        if (!(lockToken == null || (lock = this.myFSFS.getLockHelper(targetPath, false)) != null && lockToken.equals(lock.getID()))) {
            this.changeProperty(editPath, "svn:entry:lock-token", null, isDir);
        }
        Map sourceProps = null;
        if (sourcePath != null) {
            boolean propsChanged;
            FSRevisionRoot sourceRoot = this.getSourceRoot(sourceRevision);
            FSRevisionNode sourceNode = sourceRoot.getRevisionNode(sourcePath);
            boolean bl = propsChanged = !FSRepositoryUtil.arePropertiesEqual(sourceNode, targetNode);
            if (!propsChanged) {
                return;
            }
            sourceProps = sourceNode.getProperties(this.myFSFS);
        } else {
            sourceProps = new HashMap();
        }
        Map targetProps = targetNode.getProperties(this.myFSFS);
        Map propsDiffs = FSRepositoryUtil.getPropsDiffs(sourceProps, targetProps);
        Object[] names = propsDiffs.keySet().toArray();
        for (int i = 0; i < names.length; ++i) {
            String propName = (String)names[i];
            this.changeProperty(editPath, propName, (String)propsDiffs.get(propName), isDir);
        }
    }

    private Object[] fetchPathInfo(String prefix) throws SVNException {
        Object[] result = new Object[2];
        PathInfo pathInfo = this.getCurrentPathInfo();
        if (!PathInfo.isRelevant(pathInfo, prefix)) {
            result[0] = null;
            result[1] = null;
        } else {
            String relPath;
            String string = relPath = "".equals(prefix) ? pathInfo.getPath() : pathInfo.getPath().substring(prefix.length() + 1);
            if (relPath.indexOf(47) != -1) {
                result[0] = relPath.substring(0, relPath.indexOf(47));
                result[1] = null;
            } else {
                result[0] = relPath;
                result[1] = pathInfo;
                try {
                    this.getNextPathInfo();
                }
                catch (IOException ioe) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                    SVNErrorManager.error(err);
                }
            }
        }
        return result;
    }

    private void changeProperty(String path, String name, String value, boolean isDir) throws SVNException {
        if (isDir) {
            this.getEditor().changeDirProperty(name, value);
        } else {
            this.getEditor().changeFileProperty(path, name, value);
        }
    }

    private FSEntry fakeDirEntry(String reposPath, FSRevisionRoot root) throws SVNException {
        if (root.checkNodeKind(reposPath) == SVNNodeKind.NONE) {
            return null;
        }
        FSRevisionNode node = root.getRevisionNode(reposPath);
        FSEntry dirEntry = new FSEntry(node.getId(), node.getType(), SVNPathUtil.tail(node.getCreatedPath()));
        return dirEntry;
    }

    private void skipPathInfo(String prefix) throws SVNException {
        while (PathInfo.isRelevant(this.getCurrentPathInfo(), prefix)) {
            try {
                this.getNextPathInfo();
            }
            catch (IOException ioe) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                SVNErrorManager.error(err);
            }
        }
    }

    private void writeSingleString(String s, OutputStream out) throws IOException {
        if (s != null) {
            byte[] b = s.getBytes("UTF-8");
            out.write(43);
            out.write(String.valueOf(b.length).getBytes("UTF-8"));
            out.write(58);
            out.write(b);
        } else {
            out.write(45);
        }
    }

    public void writePathInfoToReportFile(String path, String linkPath, String lockToken, long revision, boolean startEmpty) throws SVNException {
        String anchorRelativePath = SVNPathUtil.append(this.getReportTarget(), path);
        String revisionRep = FSRepository.isValidRevision(revision) ? "+" + String.valueOf(revision) + ":" : "-";
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeSingleString(anchorRelativePath, baos);
            this.writeSingleString(linkPath, baos);
            baos.write(revisionRep.getBytes("UTF-8"));
            baos.write(startEmpty ? 43 : 45);
            this.writeSingleString(lockToken, baos);
            OutputStream reportOS = this.getReportFileForWriting();
            reportOS.write(baos.toByteArray());
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe);
        }
    }
}

