/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.tmatesoft.svn.core.SVNException;

public abstract class SVNVersionedProperties {
    private Map myProperties;
    private boolean myIsModified;

    protected SVNVersionedProperties(Map props) {
        this.myProperties = props;
        this.myIsModified = false;
    }

    public abstract boolean containsProperty(String var1) throws SVNException;

    public abstract String getPropertyValue(String var1) throws SVNException;

    public boolean isModified() {
        return this.myIsModified;
    }

    protected void setModified(boolean modified) {
        this.myIsModified = modified;
    }

    public boolean isEmpty() throws SVNException {
        Map props = this.loadProperties();
        return props == null || props.isEmpty();
    }

    public Collection getPropertyNames(Collection target) throws SVNException {
        Map props = this.loadProperties();
        Collection collection = target = target == null ? new TreeSet() : target;
        if (this.isEmpty()) {
            return target;
        }
        Iterator names = props.keySet().iterator();
        while (names.hasNext()) {
            target.add(names.next());
        }
        return target;
    }

    public void setPropertyValue(String name, String value) throws SVNException {
        Map props = this.loadProperties();
        if (value != null) {
            props.put(name, value);
        } else {
            props.remove(name);
        }
        this.myIsModified = true;
    }

    public SVNVersionedProperties compareTo(SVNVersionedProperties properties) throws SVNException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.isEmpty()) {
            result.putAll(properties.asMap());
            return this.wrap(result);
        }
        Collection props1 = this.getPropertyNames(null);
        Collection props2 = properties.getPropertyNames(null);
        TreeSet tmp = new TreeSet(props1);
        tmp.removeAll(props2);
        for (String missing : tmp) {
            result.put(missing, null);
        }
        tmp = new TreeSet(props2);
        tmp.removeAll(props1);
        for (String added : tmp) {
            result.put(added, properties.getPropertyValue(added));
        }
        props2.retainAll(props1);
        for (String changed : props2) {
            String value2;
            String value1 = this.getPropertyValue(changed);
            if (value1.equals(value2 = properties.getPropertyValue(changed))) continue;
            result.put(changed, value2);
        }
        return this.wrap(result);
    }

    public void copyTo(SVNVersionedProperties destination) throws SVNException {
        Map props = this.loadProperties();
        if (this.isEmpty()) {
            destination.removeAll();
        } else {
            destination.put(props);
        }
    }

    public void removeAll() throws SVNException {
        Map props = this.loadProperties();
        if (!this.isEmpty()) {
            props.clear();
            this.myIsModified = true;
        }
    }

    public boolean equals(SVNVersionedProperties props) throws SVNException {
        return this.compareTo(props).isEmpty();
    }

    public Map asMap() throws SVNException {
        HashMap props = this.loadProperties() != null ? new HashMap(this.loadProperties()) : new HashMap();
        return props;
    }

    protected void put(Map props) throws SVNException {
        Map thisProps = this.loadProperties();
        thisProps.clear();
        thisProps.putAll(props);
        this.myIsModified = true;
    }

    protected Map getPropertiesMap() {
        return this.myProperties;
    }

    protected void setPropertiesMap(Map props) {
        this.myProperties = props;
    }

    protected abstract SVNVersionedProperties wrap(Map var1);

    protected abstract Map loadProperties() throws SVNException;
}

