/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.io.ISVNConnectionListener;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.util.ISVNDebugLog;

public class DefaultSVNRepositoryPool
implements ISVNRepositoryPool,
ISVNSession,
ISVNConnectionListener {
    public static final int RUNTIME_POOL = 1;
    public static final int INSTANCE_POOL = 2;
    public static final int NO_POOL = 4;
    private static final long DEFAULT_IDLE_TIMEOUT = 60000L;
    private static Timer ourTimer = new Timer(true);
    private ISVNAuthenticationManager myAuthManager;
    private ISVNTunnelProvider myTunnelProvider;
    private Map myPool;
    private long myTimeout;
    private Map myInactiveRepositories = new HashMap();
    private Timer myTimer;
    private boolean myIsKeepConnection;
    private static final Logger LOGGER = Logger.getLogger(DefaultSVNRepositoryPool.class.getName());

    public DefaultSVNRepositoryPool(ISVNAuthenticationManager authManager, ISVNTunnelProvider tunnelProvider) {
        this(authManager, tunnelProvider, 60000L, true);
    }

    public DefaultSVNRepositoryPool(ISVNAuthenticationManager authManager, ISVNTunnelProvider tunnelProvider, long timeout, boolean keepConnection) {
        this.myAuthManager = authManager;
        this.myTunnelProvider = tunnelProvider;
        this.myTimeout = timeout > 0L ? timeout : 60000L;
        this.myIsKeepConnection = keepConnection;
        this.myTimeout = timeout;
        if (this.myIsKeepConnection) {
            this.myTimer = ourTimer;
            ourTimer.schedule((TimerTask)new TimeoutTask(), 10000L);
        }
    }

    public DefaultSVNRepositoryPool(ISVNAuthenticationManager authManager, ISVNTunnelProvider tunnelProvider, boolean keepConnections, int poolMode) {
        this(authManager, tunnelProvider);
    }

    public synchronized SVNRepository createRepository(SVNURL url, boolean mayReuse) throws SVNException {
        if (this.myIsKeepConnection && this.myTimer == null && ourTimer != null) {
            this.myTimer = ourTimer;
            ourTimer.schedule((TimerTask)new TimeoutTask(), 10000L);
        }
        SVNRepository repos = null;
        Map pool = this.getPool();
        if (!mayReuse || pool == null) {
            repos = SVNRepositoryFactory.create(url, this);
            repos.setAuthenticationManager(this.myAuthManager);
            repos.setTunnelProvider(this.myTunnelProvider);
            return repos;
        }
        repos = (SVNRepository)pool.get(url.getProtocol());
        if (repos != null) {
            repos.setLocation(url, false);
        } else {
            repos = SVNRepositoryFactory.create(url, this);
            if (this.myIsKeepConnection) {
                repos.addConnectionListener(this);
            }
            pool.put(url.getProtocol(), repos);
        }
        repos.setAuthenticationManager(this.myAuthManager);
        repos.setTunnelProvider(this.myTunnelProvider);
        return repos;
    }

    public void setAuthenticationManager(ISVNAuthenticationManager authManager) {
        this.myAuthManager = authManager;
        Map pool = this.getPool();
        for (String key : pool.keySet()) {
            SVNRepository repository = (SVNRepository)pool.get(key);
            repository.setAuthenticationManager(this.myAuthManager);
        }
    }

    public boolean keepConnection(SVNRepository repository) {
        return this.myIsKeepConnection;
    }

    public synchronized void shutdownConnections(boolean shutdownAll) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map map = this.myInactiveRepositories;
        synchronized (map) {
            this.myInactiveRepositories.clear();
            this.myTimer = null;
        }
        Map pool = this.getPool();
        for (String key : pool.keySet()) {
            SVNRepository repository = (SVNRepository)pool.get(key);
            repository.closeSession();
        }
        this.myPool = null;
    }

    private Map getPool() {
        if (this.myPool == null) {
            this.myPool = new HashMap();
        }
        return this.myPool;
    }

    public void saveCommitMessage(SVNRepository repository, long revision, String message) {
    }

    public String getCommitMessage(SVNRepository repository, long revision) {
        return null;
    }

    public boolean hasCommitMessage(SVNRepository repository, long revision) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(SVNRepository repository) {
        Map map = this.myInactiveRepositories;
        synchronized (map) {
            this.myInactiveRepositories.put(repository, new Long(System.currentTimeMillis()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionOpened(SVNRepository repository) {
        Map map = this.myInactiveRepositories;
        synchronized (map) {
            this.myInactiveRepositories.remove(repository);
        }
    }

    private long getTimeout() {
        return this.myTimeout;
    }

    public void setCanceller(ISVNCanceller canceller) {
        Map pool = this.getPool();
        for (String key : pool.keySet()) {
            SVNRepository repository = (SVNRepository)pool.get(key);
            repository.setCanceller(canceller);
        }
    }

    public void setDebugLog(ISVNDebugLog log) {
        Map pool = this.getPool();
        for (String key : pool.keySet()) {
            SVNRepository repository = (SVNRepository)pool.get(key);
            repository.setDebugLog(log);
        }
    }

    private class TimeoutTask
    extends TimerTask {
        private TimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                long currentTime = System.currentTimeMillis();
                Map map = DefaultSVNRepositoryPool.this.myInactiveRepositories;
                synchronized (map) {
                    Iterator repositories = DefaultSVNRepositoryPool.this.myInactiveRepositories.keySet().iterator();
                    while (repositories.hasNext()) {
                        SVNRepository repos = (SVNRepository)repositories.next();
                        long time = (Long)DefaultSVNRepositoryPool.this.myInactiveRepositories.get(repos);
                        if (currentTime - time < DefaultSVNRepositoryPool.this.getTimeout()) continue;
                        repositories.remove();
                        repos.closeSession();
                    }
                    if (DefaultSVNRepositoryPool.this.myTimer != null) {
                        DefaultSVNRepositoryPool.this.myTimer.schedule((TimerTask)new TimeoutTask(), 10000L);
                    }
                }
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "Timer task " + this + " failed", t);
            }
        }
    }
}

