/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.fs.FSCommitter;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNUUIDGenerator;
import org.tmatesoft.svn.core.internal.wc.DefaultLoadHandler;
import org.tmatesoft.svn.core.internal.wc.ISVNLoadHandler;
import org.tmatesoft.svn.core.internal.wc.SVNAdminHelper;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNDumpEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNSynchronizeEditor;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.replicator.SVNRepositoryReplicator;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;
import org.tmatesoft.svn.core.wc.admin.SVNUUIDAction;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNAdminClient
extends SVNBasicClient {
    private ISVNLogEntryHandler mySyncHandler;
    private ISVNLoadHandler myLoadHandler;
    private ISVNAdminEventHandler myEventHandler;

    public SVNAdminClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNAdminClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public void setReplayHandler(ISVNLogEntryHandler handler) {
        this.mySyncHandler = handler;
    }

    public void setEventHandler(ISVNEventHandler handler) {
        super.setEventHandler(handler);
        if (handler instanceof ISVNAdminEventHandler) {
            this.myEventHandler = (ISVNAdminEventHandler)handler;
        }
    }

    public SVNURL doCreateRepository(File path, String uuid, boolean enableRevisionProperties, boolean force) throws SVNException {
        return SVNRepositoryFactory.createLocalRepository(path, uuid, enableRevisionProperties, force);
    }

    public SVNURL doCreateRepository(File path, String uuid, boolean enableRevisionProperties, boolean force, boolean pre14Compatible) throws SVNException {
        return SVNRepositoryFactory.createLocalRepository(path, uuid, enableRevisionProperties, force, pre14Compatible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCopyRevisionProperties(SVNURL toURL, long revision) throws SVNException {
        SVNRepository toRepos = this.createRepository(toURL, true);
        this.checkIfRepositoryIsAtRoot(toRepos, toURL);
        SVNException error = null;
        SVNException error2 = null;
        this.lock(toRepos);
        try {
            SessionInfo info = this.openSourceRepository(toRepos);
            if (revision > info.myLastMergedRevision) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot copy revprops for a revision that has not been synchronized yet");
                SVNErrorManager.error(err);
            }
            this.copyRevisionProperties(info.myRepository, toRepos, revision, false);
        }
        catch (SVNException svne) {
            error = svne;
        }
        finally {
            try {
                this.unlock(toRepos);
            }
            catch (SVNException svne) {
                error2 = svne;
            }
        }
        if (error != null) {
            throw error;
        }
        if (error2 != null) {
            throw error2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInitialize(SVNURL fromURL, SVNURL toURL) throws SVNException {
        SVNRepository toRepos = this.createRepository(toURL, true);
        this.checkIfRepositoryIsAtRoot(toRepos, toURL);
        SVNException error = null;
        SVNException error2 = null;
        this.lock(toRepos);
        try {
            String fromURLProp;
            long latestRevision = toRepos.getLatestRevision();
            if (latestRevision != 0L) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot initialize a repository with content in it");
                SVNErrorManager.error(err);
            }
            if ((fromURLProp = toRepos.getRevisionPropertyValue(0L, "svn:sync-from-url")) != null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Destination repository is already synchronizing from ''{0}''", fromURLProp);
                SVNErrorManager.error(err);
            }
            SVNRepository fromRepos = this.createRepository(fromURL, false);
            this.checkIfRepositoryIsAtRoot(fromRepos, fromURL);
            toRepos.setRevisionPropertyValue(0L, "svn:sync-from-url", fromURL.toDecodedString());
            String uuid = fromRepos.getRepositoryUUID(true);
            toRepos.setRevisionPropertyValue(0L, "svn:sync-from-uuid", uuid);
            toRepos.setRevisionPropertyValue(0L, "svn:sync-last-merged-rev", "0");
            this.copyRevisionProperties(fromRepos, toRepos, 0L, false);
        }
        catch (SVNException svne) {
            error = svne;
        }
        finally {
            try {
                this.unlock(toRepos);
            }
            catch (SVNException svne) {
                error2 = svne;
            }
        }
        if (error != null) {
            throw error;
        }
        if (error2 != null) {
            throw error2;
        }
    }

    public void doCompleteSynchronize(SVNURL fromURL, SVNURL toURL) throws SVNException {
        try {
            this.doInitialize(fromURL, toURL);
            this.doSynchronize(toURL);
            return;
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() != SVNErrorCode.RA_NOT_IMPLEMENTED) {
                throw svne;
            }
            SVNRepositoryReplicator replicator = SVNRepositoryReplicator.newInstance();
            SVNRepository fromRepos = this.createRepository(fromURL, true);
            SVNRepository toRepos = this.createRepository(toURL, false);
            replicator.replicateRepository(fromRepos, toRepos, 1L, -1L);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSynchronize(SVNURL toURL) throws SVNException {
        SVNRepository toRepos = this.createRepository(toURL, true);
        this.checkIfRepositoryIsAtRoot(toRepos, toURL);
        SVNException error = null;
        SVNException error2 = null;
        this.lock(toRepos);
        try {
            SessionInfo info = this.openSourceRepository(toRepos);
            SVNRepository fromRepos = info.myRepository;
            long lastMergedRevision = info.myLastMergedRevision;
            String currentlyCopying = toRepos.getRevisionPropertyValue(0L, "svn:sync-currently-copying");
            long toLatestRevision = toRepos.getLatestRevision();
            if (currentlyCopying != null) {
                long copyingRev = Long.parseLong(currentlyCopying);
                if (copyingRev < lastMergedRevision || copyingRev > lastMergedRevision + 1L || toLatestRevision != lastMergedRevision && toLatestRevision != copyingRev) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Revision being currently copied ({0,number,integer}), last merged revision ({1,number,integer}), and destination HEAD ({2,number,integer}) are inconsistent; have you committed to the destination without using svnsync?", new Long[]{new Long(copyingRev), new Long(lastMergedRevision), new Long(toLatestRevision)});
                    SVNErrorManager.error(err);
                } else if (copyingRev == toLatestRevision) {
                    if (copyingRev > lastMergedRevision) {
                        this.copyRevisionProperties(fromRepos, toRepos, toLatestRevision, true);
                        lastMergedRevision = copyingRev;
                    }
                    toRepos.setRevisionPropertyValue(0L, "svn:sync-last-merged-rev", SVNProperty.toString(lastMergedRevision));
                    toRepos.setRevisionPropertyValue(0L, "svn:sync-currently-copying", null);
                }
            } else if (toLatestRevision != lastMergedRevision) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Destination HEAD ({0,number,integer}) is not the last merged revision ({1,number,integer}); have you committed to the destination without using svnsync?", new Long[]{new Long(toLatestRevision), new Long(lastMergedRevision)});
                SVNErrorManager.error(err);
            }
            long fromLatestRevision = fromRepos.getLatestRevision();
            if (fromLatestRevision < lastMergedRevision) {
                return;
            }
            for (long currentRev = lastMergedRevision + 1L; currentRev <= fromLatestRevision; ++currentRev) {
                toRepos.setRevisionPropertyValue(0L, "svn:sync-currently-copying", SVNProperty.toString(currentRev));
                SVNSynchronizeEditor syncEditor = new SVNSynchronizeEditor(toRepos, this.mySyncHandler, currentRev - 1L);
                ISVNEditor cancellableEditor = SVNCancellableEditor.newInstance(syncEditor, this, this.getDebugLog());
                try {
                    fromRepos.replay(0L, currentRev, true, cancellableEditor);
                }
                catch (SVNException e) {
                    try {
                        cancellableEditor.abortEdit();
                    }
                    catch (SVNException abortError) {
                        // empty catch block
                    }
                    throw e;
                }
                cancellableEditor.closeEdit();
                if (syncEditor.getCommitInfo().getNewRevision() != currentRev) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Commit created rev {0,number,integer} but should have created {1,number,integer}", new Long[]{new Long(syncEditor.getCommitInfo().getNewRevision()), new Long(currentRev)});
                    SVNErrorManager.error(err);
                }
                this.copyRevisionProperties(fromRepos, toRepos, currentRev, true);
                toRepos.setRevisionPropertyValue(0L, "svn:sync-last-merged-rev", SVNProperty.toString(currentRev));
                toRepos.setRevisionPropertyValue(0L, "svn:sync-currently-copying", null);
            }
        }
        catch (SVNException svne) {
            error = svne;
        }
        finally {
            try {
                this.unlock(toRepos);
            }
            catch (SVNException svne) {
                error2 = svne;
            }
        }
        if (error != null) {
            throw error;
        }
        if (error2 != null) {
            throw error2;
        }
    }

    public void doListLocks(File repositoryRoot) throws SVNException {
        FSFS fsfs = SVNAdminHelper.openRepository(repositoryRoot);
        File digestFile = fsfs.getDigestFileFromRepositoryPath("/");
        ISVNLockHandler handler = new ISVNLockHandler(){

            public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                SVNAdminClient.this.checkCancelled();
                if (SVNAdminClient.this.myEventHandler != null) {
                    SVNAdminEvent event = new SVNAdminEvent(SVNAdminEventAction.LOCK_LISTED, lock, error, null);
                    SVNAdminClient.this.myEventHandler.handleAdminEvent(event, -1.0);
                }
            }

            public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
            }
        };
        fsfs.walkDigestFiles(digestFile, handler, false);
    }

    public void doRemoveLocks(File repositoryRoot, String[] paths) throws SVNException {
        if (paths == null) {
            return;
        }
        FSFS fsfs = SVNAdminHelper.openRepository(repositoryRoot);
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            if (path == null) continue;
            this.checkCancelled();
            SVNLock lock = null;
            try {
                SVNAdminEvent event;
                lock = fsfs.getLockHelper(path, false);
                if (lock == null) {
                    if (this.myEventHandler == null) continue;
                    event = new SVNAdminEvent(SVNAdminEventAction.NOT_LOCKED, lock, null, "Path '" + path + "' isn't locked.");
                    this.myEventHandler.handleAdminEvent(event, -1.0);
                    continue;
                }
                fsfs.unlockPath(path, lock.getID(), null, true, false);
                if (this.myEventHandler == null) continue;
                event = new SVNAdminEvent(SVNAdminEventAction.UNLOCKED, lock, null, "Removed lock on '" + path + "'.");
                this.myEventHandler.handleAdminEvent(event, -1.0);
                continue;
            }
            catch (SVNException svne) {
                if (this.myEventHandler == null) continue;
                SVNAdminEvent event = new SVNAdminEvent(SVNAdminEventAction.UNLOCK_FAILED, lock, svne.getErrorMessage(), "svnadmin: " + svne.getErrorMessage().getFullMessage());
                this.myEventHandler.handleAdminEvent(event, -1.0);
            }
        }
    }

    public void doListTransactions(File repositoryRoot) throws SVNException {
        FSFS fsfs = SVNAdminHelper.openRepository(repositoryRoot);
        Map txns = fsfs.listTransactions();
        for (String txnName : txns.keySet()) {
            File txnDir = (File)txns.get(txnName);
            SVNDebugLog.getDefaultLog().info(txnName + "\n");
            if (this.myEventHandler == null) continue;
            SVNAdminEvent event = new SVNAdminEvent(txnName, txnDir, SVNAdminEventAction.TRANSACTION_LISTED);
            this.myEventHandler.handleAdminEvent(event, -1.0);
        }
    }

    public void doRemoveTransactions(File repositoryRoot, String[] transactions) throws SVNException {
        if (transactions == null) {
            return;
        }
        FSFS fsfs = SVNAdminHelper.openRepository(repositoryRoot);
        for (int i = 0; i < transactions.length; ++i) {
            String txnName = transactions[i];
            fsfs.openTxn(txnName);
            FSCommitter.purgeTxn(fsfs, txnName);
            SVNDebugLog.getDefaultLog().info("Transaction '" + txnName + "' removed.\n");
            if (this.myEventHandler == null) continue;
            SVNAdminEvent event = new SVNAdminEvent(txnName, fsfs.getTransactionDir(txnName), SVNAdminEventAction.TRANSACTION_REMOVED);
            this.myEventHandler.handleAdminEvent(event, -1.0);
        }
    }

    public void doVerify(File repositoryRoot) throws SVNException {
        this.doVerify(repositoryRoot, SVNRevision.create(0L), SVNRevision.HEAD);
    }

    public void doVerify(File repositoryRoot, SVNRevision startRevision, SVNRevision endRevision) throws SVNException {
        FSFS fsfs = SVNAdminHelper.openRepository(repositoryRoot);
        long startRev = startRevision.getNumber();
        long endRev = endRevision.getNumber();
        if (startRev < 0L) {
            startRev = 0L;
        }
        if (endRev < 0L) {
            endRev = fsfs.getYoungestRevision();
        }
        try {
            this.dump(fsfs, SVNFileUtil.DUMMY_OUT, startRev, endRev, false, false);
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe);
        }
    }

    public void doDump(File repositoryRoot, OutputStream dumpStream, SVNRevision startRevision, SVNRevision endRevision, boolean isIncremental, boolean useDeltas) throws SVNException {
        FSFS fsfs = SVNAdminHelper.openRepository(repositoryRoot);
        long youngestRevision = fsfs.getYoungestRevision();
        long lowerR = SVNAdminHelper.getRevisionNumber(startRevision, youngestRevision, fsfs);
        long upperR = SVNAdminHelper.getRevisionNumber(endRevision, youngestRevision, fsfs);
        if (!SVNRevision.isValidRevisionNumber(lowerR)) {
            lowerR = 0L;
            upperR = youngestRevision;
        } else if (!SVNRevision.isValidRevisionNumber(upperR)) {
            upperR = lowerR;
        }
        if (lowerR > upperR) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "First revision cannot be higher than second");
            SVNErrorManager.error(err);
        }
        try {
            this.dump(fsfs, dumpStream, lowerR, upperR, isIncremental, useDeltas);
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe);
        }
    }

    public void doLoad(File repositoryRoot, InputStream dumpStream) throws SVNException {
        this.doLoad(repositoryRoot, dumpStream, false, false, SVNUUIDAction.DEFAULT, null);
    }

    public void doLoad(File repositoryRoot, InputStream dumpStream, boolean usePreCommitHook, boolean usePostCommitHook, SVNUUIDAction uuidAction, String parentDir) throws SVNException {
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        ISVNLoadHandler handler = this.getLoadHandler(repositoryRoot, usePreCommitHook, usePostCommitHook, uuidAction, parentDir, decoder);
        String line = null;
        int version = -1;
        StringBuffer buffer = new StringBuffer();
        try {
            SVNErrorMessage err;
            line = SVNFileUtil.readLineFromStream(dumpStream, buffer, decoder);
            if (line == null) {
                SVNAdminHelper.generateIncompleteDataError();
            }
            if (!line.startsWith("SVN-fs-dump-format-version:")) {
                err = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header");
                SVNErrorManager.error(err);
            }
            try {
                line = line.substring("SVN-fs-dump-format-version".length() + 1);
                line = line.trim();
                version = Integer.parseInt(line);
                if (version > 3) {
                    err = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Unsupported dumpfile version: {0,number,integer}", new Integer(version));
                    SVNErrorManager.error(err);
                }
            }
            catch (NumberFormatException nfe) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header");
                SVNErrorManager.error(err2, nfe);
            }
            while (true) {
                SVNErrorMessage err3;
                int length;
                boolean isDelta;
                String delta;
                this.checkCancelled();
                boolean foundNode = false;
                buffer.setLength(0);
                line = SVNFileUtil.readLineFromStream(dumpStream, buffer, decoder);
                if (line == null) {
                    if (buffer.length() <= 0) break;
                    SVNAdminHelper.generateIncompleteDataError();
                }
                if (line.length() == 0 || Character.isWhitespace(line.charAt(0))) continue;
                Map headers = this.readHeaderBlock(dumpStream, line, decoder);
                if (headers.containsKey("Revision-number")) {
                    handler.closeRevision();
                    handler.openRevision(headers);
                } else if (headers.containsKey("Node-path")) {
                    handler.openNode(headers);
                    foundNode = true;
                } else if (headers.containsKey("UUID")) {
                    String uuid = (String)headers.get("UUID");
                    handler.parseUUID(uuid);
                } else if (headers.containsKey("SVN-fs-dump-format-version")) {
                    try {
                        version = Integer.parseInt((String)headers.get("SVN-fs-dump-format-version"));
                    }
                    catch (NumberFormatException nfe) {
                        SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header");
                        SVNErrorManager.error(err4, nfe);
                    }
                } else {
                    SVNErrorMessage err5 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Unrecognized record type in stream");
                    SVNErrorManager.error(err5);
                }
                String contentLength = (String)headers.get("Content-length");
                String propContentLength = (String)headers.get("Prop-content-length");
                String textContentLength = (String)headers.get("Text-content-length");
                boolean isOldVersion = version == 1 && contentLength != null && propContentLength == null && textContentLength == null;
                int actualPropLength = 0;
                if (propContentLength != null || isOldVersion) {
                    delta = (String)headers.get("Prop-delta");
                    boolean bl = isDelta = delta != null && "true".equals(delta);
                    if (foundNode && !isDelta) {
                        handler.removeNodeProperties();
                    }
                    length = 0;
                    try {
                        length = Integer.parseInt(propContentLength != null ? propContentLength : contentLength);
                    }
                    catch (NumberFormatException nfe) {
                        err3 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse property block length header");
                        SVNErrorManager.error(err3, nfe);
                    }
                    actualPropLength += handler.parsePropertyBlock(dumpStream, length, foundNode);
                }
                if (textContentLength != null) {
                    delta = (String)headers.get("Text-delta");
                    isDelta = delta != null && "true".equals(delta);
                    length = 0;
                    try {
                        length = Integer.parseInt(textContentLength);
                    }
                    catch (NumberFormatException nfe) {
                        err3 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse text block length header");
                        SVNErrorManager.error(err3, nfe);
                    }
                    handler.parseTextBlock(dumpStream, length, isDelta);
                } else if (isOldVersion) {
                    int length2 = 0;
                    try {
                        length2 = Integer.parseInt(contentLength);
                    }
                    catch (NumberFormatException nfe) {
                        SVNErrorMessage err6 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse content length header");
                        SVNErrorManager.error(err6, nfe);
                    }
                    if ((length2 -= actualPropLength) > 0 || SVNNodeKind.parseKind((String)headers.get("Node-kind")) == SVNNodeKind.FILE) {
                        handler.parseTextBlock(dumpStream, length2, false);
                    }
                }
                if (contentLength != null && !isOldVersion) {
                    SVNErrorMessage err7;
                    int remaining = 0;
                    try {
                        remaining = Integer.parseInt(contentLength);
                    }
                    catch (NumberFormatException nfe) {
                        SVNErrorMessage err8 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse content length header");
                        SVNErrorManager.error(err8, nfe);
                    }
                    int propertyContentLength = 0;
                    if (propContentLength != null) {
                        try {
                            propertyContentLength = Integer.parseInt(propContentLength);
                        }
                        catch (NumberFormatException nfe) {
                            err7 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse property block length header");
                            SVNErrorManager.error(err7, nfe);
                        }
                    }
                    remaining -= propertyContentLength;
                    int txtContentLength = 0;
                    if (textContentLength != null) {
                        try {
                            txtContentLength = Integer.parseInt(textContentLength);
                        }
                        catch (NumberFormatException nfe) {
                            err3 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse text block length header");
                            SVNErrorManager.error(err3, nfe);
                        }
                    }
                    if ((remaining -= txtContentLength) < 0) {
                        err7 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Sum of subblock sizes larger than total block content length");
                        SVNErrorManager.error(err7);
                    }
                    byte[] buf = new byte[16384];
                    while (remaining > 0) {
                        int numToRead = remaining >= 16384 ? 16384 : remaining;
                        int numRead = dumpStream.read(buf, 0, numToRead);
                        remaining -= numRead;
                        if (numRead == numToRead) continue;
                        SVNAdminHelper.generateIncompleteDataError();
                    }
                }
                if (!foundNode) continue;
                handler.closeNode();
                foundNode = false;
            }
            handler.closeRevision();
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe);
        }
    }

    private void dump(FSFS fsfs, OutputStream dumpStream, long start, long end, boolean isIncremental, boolean useDeltas) throws SVNException, IOException {
        SVNErrorMessage err;
        boolean isDumping = dumpStream != null;
        long youngestRevision = fsfs.getYoungestRevision();
        if (!SVNRevision.isValidRevisionNumber(start)) {
            start = 0L;
        }
        if (!SVNRevision.isValidRevisionNumber(end)) {
            end = youngestRevision;
        }
        if (dumpStream == null) {
            dumpStream = SVNFileUtil.DUMMY_OUT;
        }
        if (start > end) {
            err = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "Start revision {0,number,integer} is greater than end revision {1,number,integer}", new Object[]{new Long(start), new Long(end)});
            SVNErrorManager.error(err);
        }
        if (end > youngestRevision) {
            err = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "End revision {0,number,integer} is invalid (youngest revision is {1,number,integer})", new Object[]{new Long(end), new Long(youngestRevision)});
            SVNErrorManager.error(err);
        }
        if (start == 0L && isIncremental) {
            isIncremental = false;
        }
        String uuid = fsfs.getUUID();
        int version = 3;
        if (!useDeltas) {
            --version;
        }
        this.writeDumpData(dumpStream, "SVN-fs-dump-format-version: " + version + "\n\n");
        this.writeDumpData(dumpStream, "UUID: " + uuid + "\n\n");
        for (long i = start; i <= end; ++i) {
            long fromRev;
            long toRev;
            this.checkCancelled();
            if (i == start && !isIncremental) {
                if (i == 0L) {
                    this.writeRevisionRecord(dumpStream, fsfs, 0L);
                    toRev = 0L;
                    String message = (isDumping ? "* Dumped" : "* Verified") + " revision " + toRev + ".";
                    if (this.myEventHandler == null) continue;
                    SVNAdminEvent event = new SVNAdminEvent(toRev, SVNAdminEventAction.REVISION_DUMPED, message);
                    this.myEventHandler.handleAdminEvent(event, -1.0);
                    continue;
                }
                fromRev = 0L;
                toRev = i;
            } else {
                fromRev = i - 1L;
                toRev = i;
            }
            this.writeRevisionRecord(dumpStream, fsfs, toRev);
            boolean useDeltasForRevision = useDeltas && (isIncremental || i != start);
            FSRevisionRoot toRoot = fsfs.createRevisionRoot(toRev);
            SVNDumpEditor dumpEditor = new SVNDumpEditor(fsfs, toRoot, toRev, start, "/", dumpStream, useDeltasForRevision);
            if (i == start && !isIncremental) {
                FSRevisionRoot fromRoot = fsfs.createRevisionRoot(fromRev);
                SVNAdminHelper.deltifyDir(fsfs, fromRoot, "/", "", toRoot, "/", dumpEditor);
            } else {
                FSRepositoryUtil.replay(fsfs, toRoot, "", -1L, false, dumpEditor);
            }
            String message = (isDumping ? "* Dumped" : "* Verified") + " revision " + toRev + ".";
            if (this.myEventHandler == null) continue;
            SVNAdminEvent event = new SVNAdminEvent(toRev, SVNAdminEventAction.REVISION_DUMPED, message);
            this.myEventHandler.handleAdminEvent(event, -1.0);
        }
    }

    private void writeRevisionRecord(OutputStream dumpStream, FSFS fsfs, long revision) throws SVNException, IOException {
        Map revProps = fsfs.getRevisionProperties(revision);
        String revisionDate = (String)revProps.get("svn:date");
        if (revisionDate != null) {
            SVNDate date = SVNDate.parseDatestamp(revisionDate);
            revProps.put("svn:date", date.format());
        }
        ByteArrayOutputStream encodedProps = new ByteArrayOutputStream();
        SVNAdminHelper.writeProperties(revProps, null, encodedProps);
        this.writeDumpData(dumpStream, "Revision-number: " + revision + "\n");
        String propContents = new String(encodedProps.toByteArray(), "UTF-8");
        this.writeDumpData(dumpStream, "Prop-content-length: " + propContents.length() + "\n");
        this.writeDumpData(dumpStream, "Content-length: " + propContents.length() + "\n\n");
        this.writeDumpData(dumpStream, propContents);
        dumpStream.write(10);
    }

    private void writeDumpData(OutputStream out, String data) throws IOException {
        out.write(data.getBytes("UTF-8"));
    }

    private ISVNLoadHandler getLoadHandler(File repositoryRoot, boolean usePreCommitHook, boolean usePostCommitHook, SVNUUIDAction uuidAction, String parentDir, CharsetDecoder decoder) throws SVNException {
        if (this.myLoadHandler == null) {
            FSFS fsfs = SVNAdminHelper.openRepository(repositoryRoot);
            DefaultLoadHandler handler = new DefaultLoadHandler(usePreCommitHook, usePostCommitHook, uuidAction, parentDir, this.myEventHandler, decoder);
            handler.setFSFS(fsfs);
            this.myLoadHandler = handler;
        } else {
            this.myLoadHandler.setUsePreCommitHook(usePreCommitHook);
            this.myLoadHandler.setUsePostCommitHook(usePostCommitHook);
            this.myLoadHandler.setUUIDAction(uuidAction);
            this.myLoadHandler.setParentDir(parentDir);
        }
        return this.myLoadHandler;
    }

    private Map readHeaderBlock(InputStream dumpStream, String firstHeader, CharsetDecoder decoder) throws SVNException, IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        StringBuffer buffer = new StringBuffer();
        while (true) {
            String header = null;
            buffer.setLength(0);
            if (firstHeader != null) {
                header = firstHeader;
                firstHeader = null;
            } else {
                header = SVNFileUtil.readLineFromStream(dumpStream, buffer, decoder);
                if (header == null && buffer.length() > 0) {
                    SVNAdminHelper.generateIncompleteDataError();
                } else if (buffer.length() == 0) break;
            }
            int colonInd = header.indexOf(58);
            if (colonInd == -1) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Dump stream contains a malformed header (with no '':'') at ''{0}''", header.length() > 20 ? header.substring(0, 19) : header);
                SVNErrorManager.error(err);
            }
            String name = header.substring(0, colonInd);
            if (colonInd + 2 > header.length()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Dump stream contains a malformed header (with no value) at ''{0}''", header.length() > 20 ? header.substring(0, 19) : header);
                SVNErrorManager.error(err);
            }
            String value = header.substring(colonInd + 2);
            headers.put(name, value);
        }
        return headers;
    }

    private void copyRevisionProperties(SVNRepository fromRepository, SVNRepository toRepository, long revision, boolean sync) throws SVNException {
        Map existingRevProps = null;
        if (sync) {
            existingRevProps = toRepository.getRevisionProperties(revision, null);
        }
        boolean sawSyncProperties = false;
        Map revProps = fromRepository.getRevisionProperties(revision, null);
        for (String propName : revProps.keySet()) {
            String propValue = (String)revProps.get(propName);
            if (propName.startsWith("sync-")) {
                sawSyncProperties = true;
            } else {
                toRepository.setRevisionPropertyValue(revision, propName, propValue);
            }
            if (!sync) continue;
            existingRevProps.remove(propName);
        }
        if (sync) {
            for (String propName : existingRevProps.keySet()) {
                toRepository.setRevisionPropertyValue(revision, propName, null);
            }
        }
        if (sawSyncProperties) {
            SVNDebugLog.getDefaultLog().info("Copied properties for revision " + revision + " (sync-* properties skipped).\n");
        } else {
            SVNDebugLog.getDefaultLog().info("Copied properties for revision " + revision + ".\n");
        }
    }

    private SessionInfo openSourceRepository(SVNRepository targetRepos) throws SVNException {
        String fromURL = targetRepos.getRevisionPropertyValue(0L, "svn:sync-from-url");
        String fromUUID = targetRepos.getRevisionPropertyValue(0L, "svn:sync-from-uuid");
        String lastMergedRev = targetRepos.getRevisionPropertyValue(0L, "svn:sync-last-merged-rev");
        if (fromURL == null || fromUUID == null || lastMergedRev == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Destination repository has not been initialized");
            SVNErrorManager.error(err);
        }
        SVNURL srcURL = SVNURL.parseURIDecoded(fromURL);
        SVNRepository srcRepos = this.createRepository(srcURL, false);
        this.checkIfRepositoryIsAtRoot(srcRepos, srcURL);
        String reposUUID = srcRepos.getRepositoryUUID(true);
        if (!fromUUID.equals(reposUUID)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "UUID of destination repository ({0}) does not match expected UUID ({1})", new String[]{reposUUID, fromUUID});
            SVNErrorManager.error(err);
        }
        return new SessionInfo(srcRepos, Long.parseLong(lastMergedRev));
    }

    private void checkIfRepositoryIsAtRoot(SVNRepository repos, SVNURL url) throws SVNException {
        SVNURL reposRoot = repos.getRepositoryRoot(true);
        if (!reposRoot.equals(url)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Session is rooted at ''{0}'' but the repos root is ''{1}''", new SVNURL[]{url, reposRoot});
            SVNErrorManager.error(err);
        }
    }

    private void lock(SVNRepository repos) throws SVNException {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can't get local hostname");
            SVNErrorManager.error(err, e);
        }
        if (hostName.length() > 256) {
            hostName = hostName.substring(0, 256);
        }
        String lockToken = hostName + ":" + SVNUUIDGenerator.formatUUID(SVNUUIDGenerator.generateUUID());
        int i = 0;
        for (i = 0; i < 10; ++i) {
            String reposLockToken = repos.getRevisionPropertyValue(0L, "svn:sync-lock");
            if (reposLockToken != null) {
                if (reposLockToken.equals(lockToken)) {
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
                continue;
            }
            repos.setRevisionPropertyValue(0L, "svn:sync-lock", lockToken);
        }
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Couldn''t get lock on destination repos after {0,number,integer} attempts\n", new Integer(i));
        SVNErrorManager.error(err);
    }

    private void unlock(SVNRepository repos) throws SVNException {
        repos.setRevisionPropertyValue(0L, "svn:sync-lock", null);
    }

    private class SessionInfo {
        SVNRepository myRepository;
        long myLastMergedRevision;

        public SessionInfo(SVNRepository repos, long lastMergedRev) {
            this.myRepository = repos;
            this.myLastMergedRevision = lastMergedRev;
        }
    }
}

