/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jibri;

import org.jitsi.utils.StringUtils;
import org.jitsi.xmpp.extensions.jibri.JibriIq;
import org.jivesoftware.smack.provider.IQProvider;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.xmlpull.v1.XmlPullParser;

public class JibriIqProvider
extends IQProvider<JibriIq> {
    public JibriIq parse(XmlPullParser parser, int depth) throws Exception {
        JibriIq iq;
        String namespace = parser.getNamespace();
        if (!"http://jitsi.org/protocol/jibri".equals(namespace)) {
            return null;
        }
        String rootElement = parser.getName();
        if ("jibri".equals(rootElement)) {
            String sipAddress;
            String displayName;
            String failureStr;
            String appData;
            String sessionId;
            String youTubeBroadcastId;
            String streamId;
            String room;
            iq = new JibriIq();
            String action = parser.getAttributeValue("", "action");
            iq.setAction(JibriIq.Action.parse(action));
            String status = parser.getAttributeValue("", "status");
            iq.setStatus(JibriIq.Status.parse(status));
            String recordingMode = parser.getAttributeValue("", "recording_mode");
            if (!StringUtils.isNullOrEmpty((String)recordingMode)) {
                iq.setRecordingMode(JibriIq.RecordingMode.parse(recordingMode));
            }
            if (!StringUtils.isNullOrEmpty((String)(room = parser.getAttributeValue("", "room")))) {
                EntityBareJid roomJid = JidCreate.entityBareFrom((String)room);
                iq.setRoom(roomJid);
            }
            if (!StringUtils.isNullOrEmpty((String)(streamId = parser.getAttributeValue("", "streamid")))) {
                iq.setStreamId(streamId);
            }
            if (!StringUtils.isNullOrEmpty((String)(youTubeBroadcastId = parser.getAttributeValue("", "you_tube_broadcast_id")))) {
                iq.setYouTubeBroadcastId(youTubeBroadcastId);
            }
            if (!StringUtils.isNullOrEmpty((String)(sessionId = parser.getAttributeValue("", "session_id")))) {
                iq.setSessionId(sessionId);
            }
            if (!StringUtils.isNullOrEmpty((String)(appData = parser.getAttributeValue("", "app_data")))) {
                iq.setAppData(appData);
            }
            if (!StringUtils.isNullOrEmpty((String)(failureStr = parser.getAttributeValue("", "failure_reason")))) {
                iq.setFailureReason(JibriIq.FailureReason.parse(failureStr));
            }
            if (!StringUtils.isNullOrEmpty((String)(displayName = parser.getAttributeValue("", "displayname")))) {
                iq.setDisplayName(displayName);
            }
            if (!StringUtils.isNullOrEmpty((String)(sipAddress = parser.getAttributeValue("", "sipaddress")))) {
                iq.setSipAddress(sipAddress);
            }
        } else {
            return null;
        }
        return iq;
    }
}

