#ifndef SSL_GCACHE_H
#define SSL_GCACHE_H 1

#ifndef UCHAR
#define UCHAR uchar
typedef unsigned char uchar;
#endif

enum Command {
    ADD_TO_CACHE,
    GET_FROM_CACHE
};

typedef struct _Cache {
    uchar *aucKey;
    int    nKey;
    uchar *aucData;
    int    nData;
    time_t tExpiresAt;
} Cache;

void   WriteThing(int, uchar *, int);
uchar *ReadThing(int, int *);
Cache *LocalCacheFind(uchar *, int);
Cache *LocalCacheAdd(uchar *, int, time_t);
void   InitGlobalCache(const char *);
void   GlobalCacheAdd(uchar *, int, uchar *, int, time_t);
uchar *GlobalCacheGet(uchar *, int, int *, time_t *);

#endif /* SSL_GCACHE_H */
