/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2003 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 */

#include <jni.h>
#include <sys/types.h>
#include <libgtkhtml/gtkhtml.h>
#include <libgtkhtml/view/htmlselection.h>
#include <libgtk-java/jg_jnu.h>

#ifndef _Included_org_gnu_gtkhtml_HTMLView
#define _Included_org_gnu_gtkhtml_HTMLView
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1get_1type
(JNIEnv *env, jclass cls)
{
    return (jint) html_view_get_type();
}

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_new
 * Signature: ()I
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1new
(JNIEnv *env, jclass cls)
{
    return getHandleFromPointer(env, html_view_new());
}

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_set_document
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1set_1document
(JNIEnv *env, jclass cls, jobject view, jobject document)
{
    html_view_set_document((HtmlView *)getPointerFromHandle(env, view), 
                           (HtmlDocument *)getPointerFromHandle(env, document));
}

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_jump_to_anchor
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1jump_1to_1anchor
(JNIEnv *env, jclass cls, jobject view, jstring anch)
{
    const gchar *anchor = NULL;
  
    if (anch != NULL)
        anchor = (gchar*)(*env)->GetStringUTFChars(env, anch, 0);
  
    html_view_jump_to_anchor((HtmlView *)getPointerFromHandle(env, view), anchor);
	
    if (anch != NULL)
        (*env)->ReleaseStringUTFChars(env, anch, anchor);
}

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_get_magnification
 * Signature: (I)D
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1get_1magnification
(JNIEnv *env, jclass cls, jobject view)
{
    return (jdouble) html_view_get_magnification((HtmlView *)getPointerFromHandle(env, view));
}

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_set_magnification
 * Signature: (ID)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1set_1magnification
(JNIEnv *env, jclass cls, jobject view, jdouble mag)
{
    html_view_set_magnification((HtmlView *)getPointerFromHandle(env, view), (gdouble)mag);
}

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_zoom_in
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1zoom_1in
(JNIEnv *env, jclass cls, jobject view)
{
    html_view_zoom_in((HtmlView *)getPointerFromHandle(env, view));
}

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_zoom_out
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1zoom_1out
(JNIEnv *env, jclass cls, jobject view)
{
    html_view_zoom_out((HtmlView *)getPointerFromHandle(env, view));
}

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_zoom_reset
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1zoom_1reset
(JNIEnv *env, jclass cls, jobject view)
{
    html_view_zoom_reset((HtmlView *)getPointerFromHandle(env, view));
}

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_find_layout_box
 * Signature: (IIZ)I
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1find_1layout_1box
(JNIEnv *env, jclass cls, jobject view, jobject node, jboolean findParent)
{
    return getHandleFromPointer(env, html_view_find_layout_box((HtmlView *)getPointerFromHandle(env, view), (DomNode *)getPointerFromHandle(env, node), (gboolean) findParent));
}

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_scroll_to_node
 * Signature: (III)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1scroll_1to_1node
(JNIEnv *env, jclass cls, jobject view, jobject node, jint scrollType)
{
    html_view_scroll_to_node((HtmlView *)getPointerFromHandle(env, view), 
                             (DomNode *)getPointerFromHandle(env, node), 
                             (HtmlViewScrollToType)scrollType);
}

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_selection_get_text
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1selection_1get_1text
(JNIEnv *env, jclass cls, jobject view) 
{
    return (*env)->NewStringUTF(env, (char *)html_selection_get_text( (HtmlView *)getPointerFromHandle(env, view) ) );
}

#ifdef __cplusplus
}
#endif
#endif
