/******************************************************************************
 JMMRecord.h

	Interface for the JMMRecord class.

	Copyright  1997 by Dustin Laurence.  All rights reserved.
	
	Base code generated by Codemill v0.1.0

 *****************************************************************************/

#ifndef _H_JMMRecord
#define _H_JMMRecord

#include <jTypes.h>

#include <stdlib.h> // For size_t

	class JString;

class JMMRecord
{
public:

	JMMRecord();
	JMMRecord(const JUInt32 id, const void* address, const size_t size,
	          const JCharacter* file, const JUInt32 lineNumber,
	          const JBoolean array, const JBoolean managerMemory);
	// Save 4 bytes (on many architectures) by having no virtuals, even the destructor
	~JMMRecord(); // Warning: not virtual!

	// Accept built-in version!
	//	JMMRecord(const JMMRecord& source);
	// Why won't the compiler generate a built-in version for this one?  Bit-fields?
	// const JMMRecord& operator=(const JMMRecord& source);

	JUInt32           GetID() const;

	const void*       GetAddress() const;
	size_t            GetSize() const;

	const JCharacter* GetNewFile() const;
	JUInt32           GetNewLine() const;

	const JCharacter* GetDeleteFile() const;
	JUInt32           GetDeleteLine() const;

	void SetDeleteLocation(const JCharacter* deleteFile, const JSize deleteLine,
	                       const JBoolean arrayDelete);

	JBoolean IsDeleted() const;

	JBoolean    IsMarked() const;
	void        SetMarked(const JBoolean yesNo);

	JBoolean    ArrayNew() const;
	JBoolean    ArrayDelete() const;

	const JCharacter* NewTypeName() const;
	const JCharacter* DeleteTypeName() const;

	static const JCharacter* TypeName(const unsigned isArray);

	JBoolean    IsManagerMemory() const;

//	JString Print() const;
	void PrintLayout();

private:

	// We could easily be storing 50,000 or more entries, so using the minimum
	// possible space is crucial.  Try to choose layout and types carefully.

	// These quantities are those most likely to be > 32 bits on some
	// architectures, so keep them together
	const void*       itsAddress;
	const JCharacter* itsNewFile;
	const JCharacter* itsDeleteFile;
	size_t            itsSize;       // Likely sizeof(size_t) == sizeof(void*)

	// These don't need to be 64 bits on 64-bit architectures, and
	// shouldn't be 16 bits on 16-bit int implementations, so we can use
	// 32-bit quantities and hope that the compiler will not align them on
	// 64-bits on 64-bit architectures.  If anyone has a source file with
	// 4.3 billion lines or code that needs to allocate 4.3*10^9 memory
	// blocks, *please* contact the JX team.  And then seek help! :-)

	JUInt32  itsID;
	JUInt32  itsNewLine;
	JUInt32  itsDeleteLine;

	unsigned itsMark              :1;
	unsigned itsArrayNewFlag      :1;
	unsigned itsArrayDeleteFlag   :1;
	unsigned itsManagerMemoryFlag :1;
};

/******************************************************************************
 GetID

 *****************************************************************************/

inline JUInt32
JMMRecord::GetID() const
{
	return itsID;
}

/******************************************************************************
 GetAddress

 *****************************************************************************/

inline const void*
JMMRecord::GetAddress() const
{
	return itsAddress;
}

/******************************************************************************
 GetSize

 *****************************************************************************/

inline size_t
JMMRecord::GetSize() const
{
	return itsSize;
}

/******************************************************************************
 GetNewFile

 *****************************************************************************/

inline const JCharacter*
JMMRecord::GetNewFile() const
{
	return itsNewFile;
}

/******************************************************************************
 GetNewLine

 *****************************************************************************/

inline JUInt32
JMMRecord::GetNewLine() const
{
	return itsNewLine;
}

/******************************************************************************
 GetDeleteFile

 *****************************************************************************/

inline const JCharacter*
JMMRecord::GetDeleteFile() const
{
	return itsDeleteFile;
}

/******************************************************************************
 GetDeleteLine

 *****************************************************************************/

inline JUInt32
JMMRecord::GetDeleteLine() const
{
	return itsDeleteLine;
}

/******************************************************************************
 IsDeleted

 *****************************************************************************/

inline JBoolean
JMMRecord::IsDeleted() const
{
	return JConvertToBoolean(itsDeleteFile != NULL);
}

/******************************************************************************
 IsMarked

 *****************************************************************************/

inline JBoolean
JMMRecord::IsMarked() const
{
	return JConvertToBoolean(itsMark);
}

/******************************************************************************
 SetMarked

 *****************************************************************************/

inline void
JMMRecord::SetMarked
	(
	const JBoolean yesNo
	)
{
	itsMark = yesNo;
}

/******************************************************************************
 ArrayNew

 *****************************************************************************/

inline JBoolean
JMMRecord::ArrayNew() const
{
	return JConvertToBoolean(itsArrayNewFlag);
}

/******************************************************************************
 ArrayDelete

 *****************************************************************************/

inline JBoolean
JMMRecord::ArrayDelete() const
{
	return JConvertToBoolean(itsArrayDeleteFlag);
}

/******************************************************************************
 IsManagerMemory

 *****************************************************************************/

inline JBoolean
JMMRecord::IsManagerMemory() const
{
	return JConvertToBoolean(itsManagerMemoryFlag);
}

#endif
