#ifndef _H_JHashFunctions
#define _H_JHashFunctions

/******************************************************************************
 JHashFunctions.h

	Interface for the JHashFunctions library.

	Copyright  1997 by Dustin Laurence.  All rights reserved.
	
	Base code generated by Codemill v0.1.0

 *****************************************************************************/

#include <jRand.h>
#include <jTypes.h>

	JHashValue JHash7Bit(const JCharacter* const& key);
	JHashValue JHash8Bit(const JCharacter* const& key);



/******************************************************************************
 JDualHash

 *****************************************************************************/

inline JDualHashValue
JDualHash
	(
	const JHashValue hashValue
	)
{
	// Generate new word-sized value
	JHashValue newHash = JRandWord(hashValue);

	// Convert to a dual hash-value; see notes
	return ( ( (newHash >> 9) & 0xFF ) | 1L) - 0x80;
}

#endif
