/******************************************************************************
 JXCardFile.h

	Interface for the JXCardFile class

	Copyright  1997 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXCardFile
#define _H_JXCardFile

#include <JXWidgetSet.h>

class JXCardFile : public JXWidgetSet
{
public:

	JXCardFile(JXContainer* enclosure,
			   const HSizingOption hSizing, const VSizingOption vSizing,
			   const JCoordinate x, const JCoordinate y,
			   const JCoordinate w, const JCoordinate h);

	virtual ~JXCardFile();

	JSize	GetCardCount() const;

	JXWidgetSet*	InsertCard(const JIndex index);
	JXWidgetSet*	PrependCard();
	JXWidgetSet*	AppendCard();

	void			InsertCard(const JIndex index, JXWidgetSet* card);
	void			PrependCard(JXWidgetSet* card);
	void			AppendCard(JXWidgetSet* card);

	JXWidgetSet*	RemoveCard(const JIndex index);
	void			DeleteCard(const JIndex index);
	void			KillFocusOnCurrentCard();

	JBoolean		ShowCard(const JIndex index);
	JBoolean		ShowCard(JXWidgetSet* card);

private:

	JPtrArray<JXContainer>*	itsCards;			// we don't own the objects
	JIndex					itsCurrCardIndex;	// zero => none visible

private:

	// not allowed

	JXCardFile(const JXCardFile& source);
	const JXCardFile& operator=(const JXCardFile& source);
};


/******************************************************************************
 GetCardCount

 ******************************************************************************/

inline JSize
JXCardFile::GetCardCount()
	const
{
	return itsCards->GetElementCount();
}

/******************************************************************************
 PrependCard

 ******************************************************************************/

inline JXWidgetSet*
JXCardFile::PrependCard()
{
	return InsertCard(1);
}

inline void
JXCardFile::PrependCard
	(
	JXWidgetSet* card
	)
{
	InsertCard(1, card);
}

/******************************************************************************
 AppendCard

 ******************************************************************************/

inline JXWidgetSet*
JXCardFile::AppendCard()
{
	return InsertCard(GetCardCount()+1);
}

inline void
JXCardFile::AppendCard
	(
	JXWidgetSet* card
	)
{
	InsertCard(GetCardCount()+1, card);
}

#endif
