/******************************************************************************
 JXCheckbox.cc

	BASE CLASS = JXWidget

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <JXCheckbox.h>
#include <JXWindow.h>
#include <jAssert.h>

// JBroadcaster message types

const JCharacter* JXCheckbox::kPushed = "Pushed::JXCheckbox";

/******************************************************************************
 Constructor (protected)

 ******************************************************************************/

JXCheckbox::JXCheckbox
	(
	JXContainer*		enclosure,
	const HSizingOption	hSizing,
	const VSizingOption	vSizing,
	const JCoordinate	x,
	const JCoordinate	y,
	const JCoordinate	w,
	const JCoordinate	h
	)
	:
	JXWidget(enclosure, hSizing, vSizing, x,y, w,h)
{
	itsIsCheckedFlag = kFalse;
	itsIsPushedFlag  = kFalse;
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JXCheckbox::~JXCheckbox()
{
}

/******************************************************************************
 SetState

 ******************************************************************************/

void
JXCheckbox::SetState
	(
	const JBoolean on
	)
{
	if (itsIsCheckedFlag != on)
		{
		itsIsCheckedFlag = on;
		Redraw();
		Broadcast(Pushed(itsIsCheckedFlag));
		}
}

/******************************************************************************
 HandleMouseDown (virtual protected)

 ******************************************************************************/

void
JXCheckbox::HandleMouseDown
	(
	const JPoint&			pt,
	const JXMouseButton		button,
	const JSize				clickCount,
	const JXButtonStates&	buttonStates,
	const JXKeyModifiers&	modifiers
	)
{
	if (button == kJXLeftButton)
		{
		itsIsPushedFlag = kTrue;
		Redraw();
		}
}

/******************************************************************************
 HandleMouseDrag (virtual protected)

 ******************************************************************************/

void
JXCheckbox::HandleMouseDrag
	(
	const JPoint&			pt,
	const JXButtonStates&	buttonStates,
	const JXKeyModifiers&	modifiers
	)
{
	if (buttonStates.left())
		{
		const JRect frame     = JXContainer::GlobalToLocal(GetFrameGlobal());
		const JBoolean inside = frame.Contains(pt);
		if (inside && !itsIsPushedFlag)
			{
			itsIsPushedFlag = kTrue;
			Redraw();
			}
		else if (!inside && itsIsPushedFlag)
			{
			itsIsPushedFlag = kFalse;
			Redraw();
			}
		}
}

/******************************************************************************
 HandleMouseUp (virtual protected)

 ******************************************************************************/

void
JXCheckbox::HandleMouseUp
	(
	const JPoint&			pt,
	const JXMouseButton		button,
	const JXButtonStates&	buttonStates,
	const JXKeyModifiers&	modifiers
	)
{
	if (button == kJXLeftButton && itsIsPushedFlag)
		{
		itsIsPushedFlag = kFalse;
		ToggleState();
		}
}

/******************************************************************************
 HandleShortcut

	All shortcuts invert the state.

 ******************************************************************************/

void
JXCheckbox::HandleShortcut
	(
	const int				key,
	const JXKeyModifiers&	modifiers
	)
{
	SetState( JNegate(itsIsCheckedFlag) );
}

/******************************************************************************
 SetShortcuts (virtual)

	Derived classes can override to adjust their appearance.

 ******************************************************************************/

void
JXCheckbox::SetShortcuts
	(
	const JCharacter* list
	)
{
	JXWindow* w = GetWindow();
	w->ClearShortcuts(this);
	w->InstallShortcuts(this, list);
	Refresh();
}

#include <JArray.tmpls>
#define JTemplateType JXCheckbox
#include <JPtrArray.tmpls>
#undef JTemplateType
