/******************************************************************************
 JXDirectSaveSource.h

	Copyright  1999 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXDirectSaveSource
#define _H_JXDirectSaveSource

#include <JXImageWidget.h>

class JXSaveFileDialog;
class JXInputField;

class JXDirectSaveSource : public JXImageWidget
{
public:

	JXDirectSaveSource(JXSaveFileDialog* dialog, JXInputField* nameInput,
					   JXContainer* enclosure,
					   const HSizingOption hSizing, const VSizingOption vSizing,
					   const JCoordinate x, const JCoordinate y,
					   const JCoordinate w, const JCoordinate h);

	virtual ~JXDirectSaveSource();

protected:

	virtual void	HandleMouseDown(const JPoint& pt, const JXMouseButton button,
									const JSize clickCount,
									const JXButtonStates& buttonStates,
									const JXKeyModifiers& modifiers);

	virtual void	DNDInit(const JPoint& pt, const JXButtonStates& buttonStates,
							const JXKeyModifiers& modifiers);
	virtual Atom	GetDNDAction(const JXContainer* target,
								 const JXButtonStates& buttonStates,
								 const JXKeyModifiers& modifiers);

	virtual JBoolean	ConvertSelection(const Atom name, const Atom requestType,
										 Atom* returnType, unsigned char** data,
										 JSize* dataLength, JSize* bitsPerBlock);

private:

	JXSaveFileDialog*	itsDialog;		// owns us
	JXInputField*		itsNameInput;	// not owned

private:

	// not allowed

	JXDirectSaveSource(const JXDirectSaveSource& source);
	const JXDirectSaveSource& operator=(const JXDirectSaveSource& source);
};

#endif
