/******************************************************************************
 JXEmbossedRect.h

	Interface for the JXEmbossedRect class

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXEmbossedRect
#define _H_JXEmbossedRect

#include <JXDecorRect.h>

class JXEmbossedRect : public JXDecorRect
{
public:

	JXEmbossedRect(JXContainer* enclosure,
				   const HSizingOption hSizing, const VSizingOption vSizing,
				   const JCoordinate x, const JCoordinate y,
				   const JCoordinate w, const JCoordinate h);

	virtual ~JXEmbossedRect();

	void	SetUpWidth(const JSize upWidth);
	void	SetDownWidth(const JSize downWidth);

protected:

	virtual void	DrawBorder(JXWindowPainter& p, const JRect& frame);

private:

	JSize itsUpWidth, itsDownWidth;

private:

	// not allowed

	JXEmbossedRect(const JXEmbossedRect& source);
	const JXEmbossedRect& operator=(const JXEmbossedRect& source);
};

/******************************************************************************
 Set widths

 ******************************************************************************/

inline void
JXEmbossedRect::SetUpWidth
	(
	const JSize upWidth
	)
{
	itsUpWidth = upWidth;
}

inline void
JXEmbossedRect::SetDownWidth
	(
	const JSize downWidth
	)
{
	itsDownWidth = downWidth;
}

#endif
