/******************************************************************************
 JXEngravedRect.h

	Interface for the JXEngravedRect class

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXEngravedRect
#define _H_JXEngravedRect

#include <JXDecorRect.h>

class JXEngravedRect : public JXDecorRect
{
public:

	JXEngravedRect(JXContainer* enclosure,
				   const HSizingOption hSizing, const VSizingOption vSizing,
				   const JCoordinate x, const JCoordinate y,
				   const JCoordinate w, const JCoordinate h);

	virtual ~JXEngravedRect();

	void	SetDownWidth(const JSize downWidth);
	void	SetUpWidth(const JSize upWidth);

protected:

	virtual void	DrawBorder(JXWindowPainter& p, const JRect& frame);

private:

	JSize itsDownWidth, itsUpWidth;

private:

	// not allowed

	JXEngravedRect(const JXEngravedRect& source);
	const JXEngravedRect& operator=(const JXEngravedRect& source);
};

/******************************************************************************
 Set widths

 ******************************************************************************/

inline void
JXEngravedRect::SetDownWidth
	(
	const JSize downWidth
	)
{
	itsDownWidth = downWidth;
}

inline void
JXEngravedRect::SetUpWidth
	(
	const JSize upWidth
	)
{
	itsUpWidth = upWidth;
}

#endif
