/******************************************************************************
 JXHistoryMenuBase.h

	Interface for the JXHistoryMenuBase class

	Copyright  1998 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXHistoryMenuBase
#define _H_JXHistoryMenuBase

#include <JXTextMenu.h>

class JXHistoryMenuBase : public JXTextMenu
{
public:

	virtual ~JXHistoryMenuBase();

	JSize	GetHistoryLength() const;
	void	SetHistoryLength(const JSize historyLength);
	void	ClearHistory();

	void	SetDefaultIcon(JXImage* icon, const JBoolean menuOwnsIcon);

	void	ReadSetup(istream& input);
	void	WriteSetup(ostream& output) const;

protected:

	JXHistoryMenuBase(const JSize historyLength,
					  const JCharacter* title, JXContainer* enclosure,
					  const HSizingOption hSizing, const VSizingOption vSizing,
					  const JCoordinate x, const JCoordinate y,
					  const JCoordinate w, const JCoordinate h);

	JXHistoryMenuBase(const JSize historyLength,
					  JXMenu* owner, const JIndex itemIndex, JXContainer* enclosure);

	void	AddItem(const JCharacter* text, const JCharacter* nmShortcut);
	void	AdjustLength();

	virtual void	UpdateMenu();		// must call inherited
	virtual void	UpdateItemImage(const JIndex index);

	virtual void	Receive(JBroadcaster* sender, const Message& message);

private:

	JSize		itsHistoryLength;
	JXImage*	itsDefaultIcon;
	JBoolean	itsOwnsDefIconFlag;

private:

	void	JXHistoryMenuBaseX(const JSize historyLength);

	// not allowed

	JXHistoryMenuBase(const JXHistoryMenuBase& source);
	const JXHistoryMenuBase& operator=(const JXHistoryMenuBase& source);
};


/******************************************************************************
 GetHistoryLength

 ******************************************************************************/

inline JSize
JXHistoryMenuBase::GetHistoryLength()
	const
{
	return itsHistoryLength;
}

/******************************************************************************
 ClearHistory

 ******************************************************************************/

inline void
JXHistoryMenuBase::ClearHistory()
{
	RemoveAllItems();
}

#endif
