/******************************************************************************
 JXProgressDisplay.h

  Interface for the JXProgressDisplay class.

  Copyright  1995 by Glenn W. Bach. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXProgressDisplay
#define _H_JXProgressDisplay

#include <JProgressDisplay.h>
#include <JBroadcaster.h>

class JXTextButton;
class JXStaticText;
class JXProgressIndicator;
class JXPGMessageDirector;

class JXProgressDisplay : public JProgressDisplay, virtual public JBroadcaster
{
public:

	JXProgressDisplay();

	virtual ~JXProgressDisplay();

	void	SetItems(JXTextButton* cancelButton, JXStaticText* counter,
					 JXProgressIndicator* indicator);

	virtual JBoolean	IncrementProgress(const JCharacter* message = NULL);
	virtual JBoolean	IncrementProgress(const JSize delta);
	virtual JBoolean	ProcessContinuing();
	virtual void		ProcessFinished();
	virtual void		DisplayBusyCursor();

protected:

	virtual void	ProcessBeginning(const ProcessType processType,
									 const JSize stepCount,
									 const JCharacter* message, 
									 const JBoolean allowCancel,
									 const JBoolean allowBackground);

	virtual JBoolean	CheckForCancel();

	virtual void	Receive(JBroadcaster* sender, const Message& message);

private:

	JBoolean	itsCancelFlag;

	JXTextButton*			itsCancelButton;
	JXStaticText*			itsCounter;
	JXProgressIndicator*	itsIndicator;

	JXPGMessageDirector*	itsMessageDirector;

private:

	JBoolean	IncrementProgress1(const JCharacter* message);
	void		AppendToMessageWindow(const JCharacter* message);

	// not allowed

	JXProgressDisplay(const JXProgressDisplay& source);
	const JXProgressDisplay& operator=(const JXProgressDisplay& source);
};

#endif
