/******************************************************************************
 JXSafetySaveTask.cc

	Idle task to safety save all JXDocuments.

	BASE CLASS = JXIdleTask

	Copyright  1997 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <JXSafetySaveTask.h>
#include <JXDocumentManager.h>

const Time kSafetySavePeriod = 30000;	// 30 seconds (milliseconds)

/******************************************************************************
 Constructor

 ******************************************************************************/

JXSafetySaveTask::JXSafetySaveTask
	(
	JXDocumentManager* docMgr
	)
	:
	JXIdleTask(kSafetySavePeriod)
{
	itsDocMgr = docMgr;
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JXSafetySaveTask::~JXSafetySaveTask()
{
}

/******************************************************************************
 Perform (virtual)

 ******************************************************************************/

void
JXSafetySaveTask::Perform
	(
	const Time	delta,
	Time*		maxSleepTime
	)
{
	if (TimeToPerform(delta, maxSleepTime))
		{		
		itsDocMgr->SafetySave(JXDocumentManager::kTimer);
		}
}
