/******************************************************************************
 JXSaveFileInput.cc

	When this field gets focus, is selects everything up to but not including
	the last period.

	BASE CLASS = JXInputField

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <JXSaveFileInput.h>
#include <JString.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

JXSaveFileInput::JXSaveFileInput
	(
	JXContainer*		enclosure,
	const HSizingOption	hSizing,
	const VSizingOption	vSizing,
	const JCoordinate	x,
	const JCoordinate	y,
	const JCoordinate	w,
	const JCoordinate	h
	)
	:
	JXInputField(enclosure, hSizing, vSizing, x,y, w,h)
{
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JXSaveFileInput::~JXSaveFileInput()
{
}

/******************************************************************************
 HandleFocusEvent (virtual protected)

 ******************************************************************************/

void
JXSaveFileInput::HandleFocusEvent()
{
	JXInputField::HandleFocusEvent();

	JIndex dotIndex;
	const JBoolean found = (GetText()).LocateLastSubstring(".", &dotIndex);
	if (found && dotIndex > 1)
		{
		SetSelection(1, dotIndex-1);
		}
	else if (found)
		{
		SetCaretLocation(1);
		}
}

/******************************************************************************
 HandleKeyPress (virtual)

 ******************************************************************************/

void
JXSaveFileInput::HandleKeyPress
	(
	const int				key,
	const JXKeyModifiers&	modifiers
	)
{
	if (key == '/')
		{
		JXInputField::HandleKeyPress('-', modifiers);
		}
	else
		{
		JXInputField::HandleKeyPress(key, modifiers);
		}
}

/******************************************************************************
 FilterSelectionData (virtual protected)

	Converts slashes to dashes, since slash is the directory separator.

	*** Note that style will be empty if the data was plain text.

 ******************************************************************************/

JError
JXSaveFileInput::FilterSelectionData
	(
	JString*			text,
	JRunArray<Font>*	style
	)
	const
{
	const JError err = JXInputField::FilterSelectionData(text, style);
	if (!err.OK())
		{
		return err;
		}

	// convert slash to dash

	const JSize length = text->GetLength();
	for (JIndex i=1; i<=length; i++)
		{
		if (text->GetCharacter(i) == '/')
			{
			text->SetCharacter(i, '-');
			}
		}

	return JNoError();
}
