/******************************************************************************
 JXStyleTable.h

	Interface for the JXStyleTable class

	Copyright  1996-97 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXStyleTable
#define _H_JXStyleTable

#include <JXEditTable.h>
#include <JAuxTableData.h>
#include <JFontStyle.h>

class JString;
class JXStyleTableThunksTask;

class JXStyleTable : public JXEditTable
{
	friend class JXStyleTableThunksTask;

public:

	JXStyleTable(JXScrollbarSet* scrollbarSet, JXContainer* enclosure,
				 const HSizingOption hSizing, const VSizingOption vSizing,
				 const JCoordinate x, const JCoordinate y,
				 const JCoordinate w, const JCoordinate h);

	virtual ~JXStyleTable();

	const JString&	GetFont(JSize* size) const;
	void			SetFont(const JCharacter* name, const JSize size);

	JFontStyle	GetCellStyle(const JPoint& cell) const;
	void		SetCellStyle(const JPoint& cell, const JFontStyle& style);

protected:

	virtual void	FontChanged(const JString& name, const JSize size);
	virtual void	CellStyleChanged(const JPoint& cell, const JFontStyle& style);

	virtual void	Receive(JBroadcaster* sender, const Message& message);

private:

	JString*					itsFontName;
	JSize						itsFontSize;
	JAuxTableData<JFontStyle>*	itsStyleData;
	JBoolean					itsProcessMessagesFlag;

private:

	void	UpdateAllColors(const JBoolean allocate);
	void	UpdateRowColors(const JIndex rowIndex, const JBoolean allocate);
	void	UpdateColColors(const JIndex colIndex, const JBoolean allocate);

	// not allowed

	JXStyleTable(const JXStyleTable& source);
	const JXStyleTable& operator=(const JXStyleTable& source);
};


/******************************************************************************
 GetFont

 ******************************************************************************/

inline const JString&
JXStyleTable::GetFont
	(
	JSize* size
	)
	const
{
	*size = itsFontSize;
	return *itsFontName;
}

/******************************************************************************
 GetCellStyle

 ******************************************************************************/

inline JFontStyle
JXStyleTable::GetCellStyle
	(
	const JPoint& cell
	)
	const
{
	return itsStyleData->GetElement(cell);
}

#endif
