/******************************************************************************
 JXTable.h

	Interface for the JXTable class

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXTable
#define _H_JXTable

#include <JXScrollableWidget.h>
#include <JTable.h>

class JXTable : public JXScrollableWidget, public JTable
{
public:

	JXTable(const JCoordinate defRowHeight, const JCoordinate defColWidth,
			JXScrollbarSet* scrollbarSet, JXContainer* enclosure,
			const HSizingOption hSizing, const VSizingOption vSizing,
			const JCoordinate x, const JCoordinate y,
			const JCoordinate w, const JCoordinate h);

	virtual ~JXTable();

	virtual JBoolean	TableScrollToCell(const JPoint& cell,
										  const JBoolean centerInDisplay = kFalse);

protected:

	virtual void	Draw(JXWindowPainter& p, const JRect& rect);

	virtual JBoolean	HitSamePart(const JPoint& pt1, const JPoint& pt2) const;

	virtual void		TableRefresh();
	virtual void		TableRefreshRect(const JRect& rect);
	virtual void		TableSetGUIBounds(const JCoordinate w, const JCoordinate h);
	virtual void		TableSetScrollSteps(const JCoordinate hStep,
											const JCoordinate vStep);

	void		BeginSelectionDrag(const JPoint& cell, const JXMouseButton button,
								   const JXKeyModifiers& modifiers);
	JBoolean	HandleSelectionKeyPress(const int key,
										const JXKeyModifiers& modifiers);

	virtual void	Receive(JBroadcaster* sender, const Message& message);

private:

	// not allowed

	JXTable(const JXTable& source);
	const JXTable& operator=(const JXTable& source);
};

#endif
