/******************************************************************************
 jXGlobals.h

	Copyright  1997 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_jXGlobals
#define _H_jXGlobals

// we include these for convenience

#include <jGlobals.h>
#include <jXConstants.h>
#include <JXApplication.h>
#include <JXMenu.h>			// need definition of Style

class JXDocumentManager;
class JXHelpManager;
class JXMDIServer;
class JXChooseSaveFile;
class JXAssert;

JXApplication*		JXGetApplication();
JXChooseSaveFile*	JXGetChooseSaveFile();
JXAssert*			JXGetAssertHandler();

JXDocumentManager*	JXGetDocumentManager();		// asserts if doesn't exist
JXHelpManager*		JXGetHelpManager();			// asserts if doesn't exist
JBoolean			JXGetMDIServer(JXMDIServer** server);

const JCharacter*	JXGetHelveticaFontName();
const JCharacter*	JXGetTimesFontName();
const JCharacter*	JXGetCourierFontName();
const JCharacter*	JXGetSymbolFontName();

	// called by main() or derived classes of JXApplication

void	JXCreateDefaultDocumentManager(const JXDocumentManager::ShortcutStyle style,
									   const JBoolean useShortcutZero);

void	JXInitHelp(const JCharacter* tocSectionName,
				   const JSize sectionCount, const JCharacter* sectionName[],
				   const JCharacter* sectionTitle[], const JCharacter* sectionText[],
				   const JXMenu::Style menuStyle);

	// called by object constructors

void	JXSetDocumentManager(JXDocumentManager* docManager);
void	JXSetMDIServer(JXMDIServer* server);

	// called by JXApplication

void JXCreateGlobals(JXApplication* app);
void JXCloseHelpManager();
void JXDeleteGlobals1();
void JXDeleteGlobals2();

	// called by JXApplication, JXDisplay

JBoolean	JXGetApplication(JXApplication** app);
JBoolean	JXGetDocumentManager(JXDocumentManager** docManager);

#endif
