/******************************************************************************
 TestDNDTextDirector.cc

	This creates a window with two JXTextEditorSet's, each containing some
	styled text.  This provides a convenient way to test Drag-And-Drop.

	BASE CLASS = JXWindowDirector

	Written by John Lindal.

 ******************************************************************************/

#include "TestDNDTextDirector.h"
#include <JXWindow.h>
#include <JXHorizPartition.h>
#include <JXTextEditorSet.h>
#include <JXTextEditor.h>
#include <JXColormap.h>
#include <jXGlobals.h>
#include <jAssert.h>

const JCoordinate kInitWidth    = 100;
const JCoordinate kMinWidth     = 20;
const JCoordinate kWindowWidth  = 2*kInitWidth + JPartition::kDragRegionSize;
const JCoordinate kWindowHeight = 100;

/******************************************************************************
 Constructor

 ******************************************************************************/

TestDNDTextDirector::TestDNDTextDirector
	(
	JXDirector* supervisor
	)
	:
	JXWindowDirector(supervisor)
{
	BuildWindow();
}

/******************************************************************************
 Destructor

 ******************************************************************************/

TestDNDTextDirector::~TestDNDTextDirector()
{
}

/******************************************************************************
 BuildWindow (private)

 ******************************************************************************/

void
TestDNDTextDirector::BuildWindow()
{
JIndex i;

	JXWindow* window = new JXWindow(this, kWindowWidth,kWindowHeight, "");
	assert( window != NULL );
	SetWindow(window);

	window->SetTitle("Test Drag-And-Drop (text)");

	JArray<JCoordinate> sizes;
	JArray<JCoordinate> minSizes;
	for (i=1; i<=2; i++)
		{
		sizes.AppendElement(kInitWidth);
		minSizes.AppendElement(kMinWidth);
		}

	JXHorizPartition* partition =
		new JXHorizPartition(sizes, 0, minSizes, window,
							 JXWidget::kHElastic, JXWidget::kVElastic,
							 0,0, kWindowWidth, kWindowHeight);
	assert( partition != NULL );

	window->SetMinSize(partition->GetMinTotalSize(), kWindowHeight);

	JXTextEditor* te;
	for (i=1; i<=2; i++)
		{
		JXTextEditorSet* teSet =
			new JXTextEditorSet(JXMenu::kWindowsStyle, &te, partition->GetCompartment(i),
								JXWidget::kHElastic, JXWidget::kVElastic, 0,0, 100,100);
		assert( teSet != NULL );
		teSet->FitToEnclosure();

		// create something to drag around

		te->SetText("plain\n\nbold\n\nitalicunderline\n\ntrplunderline\n\nstrike\n\n"
					"boldred\n\nsymbol\n");

		te->SetFontStyle(8, 13, JFontStyle(kTrue, kFalse, 0, kFalse), kTrue);
		te->SetFontStyle(14, 30, JFontStyle(kFalse, kTrue, 1, kFalse), kTrue);
		te->SetFontStyle(31, 45, JFontStyle(kFalse, kFalse, 3, kFalse), kTrue);
		te->SetFontStyle(46, 53, JFontStyle(kFalse, kFalse, 0, kTrue), kTrue);
		te->SetFontStyle(54, 62, JFontStyle(kTrue, kFalse, 0, kFalse,
											(GetColormap())->GetRedColor()), kTrue);
		te->SetFont(63, 69, JXGetSymbolFontName(), 18,
					JFontStyle(kFalse, kTrue, 0, kFalse), kTrue);
		}
}
