#ifndef INCL_FILEDIALOG_H
#define INCL_FILEDIALOG_H

/*-----------------------------------------------------------------------
 * Xclasses header file
 * 
 * Copyright (C) 1998 Jrgen Schmitz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *-----------------------------------------------------------------------
 */

#include <Xclasses/types.h>
#include <Xclasses/Xwindows.h>
#include <Xclasses/Xcolors.h>
#include <Xclasses/group.h>


class file_dialog : public Xcolors
{
	friend class pfile_dialog;
	
	class pfile_dialog *p;

public:
    file_dialog(void);
    virtual ~file_dialog();

	void Text_Ok(char *);
	void Text_Cancel(char *);

	void InsertGroup(group *);
	void InsertGroup(group &g) { InsertGroup(&g); };

	void SaveMode(void);
	void LoadMode(void);
	void ShowPeriod(void);
	void NoPeriod(void);

	void MultiSelect(void);
	void SingleSelect(void);

	void SetDir(char *);
	void GetDir(char *,int size);
	void SetFile(char *);
	void GetFile(char *,int size);
	void SetPattern(char *);
	int IsSelectedMarked(void);
	int NextMarkedFile(int,char *,int size);	

	int Start(Xwindows *w);
	int Start(Xwindows &w) { return Start(&w); };
};

#endif
