/****************************************************************************/
/*   xmUsrDlg.C                                                             */
/****************************************************************************/
/*                                                                          */
/*   Copyright (c) 1992, 1993 Bernhard Strassl                              */
/*       Vienna User Interface Group                                        */
/*       Institute for Applied Computer Science and Information Systems     */
/*       University of Vienna, Austria                                      */
/*                                                                          */
/*   See file COPYRIGHT in this directory for details. If this file is      */
/*   missing please mail to xmpp@ani.univie.ac.at                           */
/****************************************************************************/

#include <stdarg.h>
#include <strstream.h>
#include <stream.h>

#include "xmObject.h"



char* XmImageDir = "./";
char* bmp_file_errors[] = { "open failed" , "invalid data", "no memory" };

Pixmap _createXmPixmap(char* wname, int w, int h)
{
	return(0);
}

extern void genericCallback(Widget, XtPointer, XtPointer);

XmDialogPane::~XmDialogPane()
{
	for(int i = 0; i < controlCount; i++)
	{	controls[i]->resetParent();
		delete controls[i];
	}
}

void XmDialogPane::getFocus(Widget)
{
}

int XmDialogPane::controlIndex(XmControl* aControl)
{
	for(int i = 0; i < controlCount; i++)
	{	if(controls[i] == aControl)
			return(i);
	}
	return(-1);
}

XmControl* XmDialogPane::findControl(ctrlType t, char* n, bool warn)
{
	ctrlType ct;

	for(int i = 0; i < controlCount; i++)
	{	ct = controls[i]->controlType();
		if(!strcmp(controls[i]->wname, n))
		{	if(ct == t)
				return(controls[i]);
			cerr << "class xmDialogPane: Error - invalid control type for " << n << " !\n";
			return(NULL);
		}
		XmControl* aControl;
		if(((ct == GroupBox || ct == PaneArea) && (aControl = ((XmGroupBox* )controls[i])->findControl(t, n, FALSE))) ||
			(ct == Pane && (aControl = ((XmPane* )controls[i])->getControl(t, n))))
			return(aControl);
	}
	if(warn)	// explain the following core dump...
		cerr << "class xmDialogPane: Error - control with name " << n << " not found !\n";
	return(NULL);
}

XmGroupBox* XmDialogPane::nextGroup(int& ndx)
{
	while(ndx < controlCount)
	{	if(controls[ndx]->controlType() == GroupBox)
			return((XmGroupBox* )controls[ndx++]);
		ndx++;
	}
	return(NULL);
}

bool XmDialogPane::add(XmControl* aControl, XmObject* rec, cbProc code, void* cl_data)
{
	XmGroupBox* g;
	int ndx = 0;

	while(g = nextGroup(ndx))
	{	if(g->parentFor(aControl))
			break;
	}
	if(g)
		return(g->addAbs(aControl, rec, code, cl_data));
	else
	{
#ifdef TCL
		aControl->handle()->setParent(handle());
#endif
		if(aControl->createControl(this))
			controls[controlCount++] = (XmControl* )aControl->getBase();
		else
			return(FALSE);
		if(aControl->isA(RadioButton))
		{	XmRadioButton* r = (XmRadioButton* )aControl;
			if(curRadio)
				curRadio->chainTo(r);
			curRadio = r;
		}
		if(rec && validProc(code))
			aControl->setCallback(NULL, rec, code, TRUE, cl_data);
	}
	return(TRUE);
}

bool XmDialogPane::removeControl(int ndx)
{
	if(ndx < 0 || ndx >= controlCount || !controls[ndx]->destroy())
		return(FALSE);
	controls[ndx]->resetParent();
	controlCount--;
	int i = ndx;
	while(i < controlCount)
	{	controls[i] = controls[i + 1];
		i++;
	}
	return(TRUE);
}

bool XmDialogPane::remove(char* n)
{
	int ndx = -1;

	for(int i = 0; i < controlCount; i++)
	{	if(!strcmp(controls[i]->wname, n))
		{	ndx = i;
			break;
		}
	}
	return(removeControl(i));
}

XmControl* XmDialogPane::find(char* n)
{
	for(int i = 0; i < controlCount; i++)
	{	if(!strcmp(controls[i]->wname, n))
			return(controls[i]);
	}
	return(NULL);
}


// Base class for user defined dialogs //////////////////////////


XmUserDialog::XmUserDialog(char* n, XmObject* par, xmStyle s) : XmDialog(n, par, s)
{
	initDialog(n, par, s);
}

XmUserDialog::XmUserDialog(char* n, XmObject* par, XmManager* mgr, xmStyle s) : XmDialog(n, par, s)
{
	manager = mgr;
	manager->addObject(this, DialogWindow);
	initDialog(n, par, s);
}

XmUserDialog::~XmUserDialog()
{
	if(manager)
		manager->removeObject(this);
}

void XmUserDialog::initDialog(char* n, XmObject* par, xmStyle s)
{
	ix = iy = iw = ih = 0;

	init(n, par);		// it seems that only the default constr of XmObject is called...
	basePtr = (XmObject* )((void* )this);		// override the base pointer !

#ifdef TCL
	wid->setToplevel();	// for the same reason as above...
#endif
	if(par)
	{
#ifdef ASCII
		wid = new CwDialog(n, (CwDialog*)par->handle());
#else
		widcmd << "toplevel " << widpath << "\n";
#endif
	}
	else
		wid = App->newMainWindow(this, n, 0, 0, s);
	setLabelAndMode(n);
	destroyOnDelete();
}

void XmUserDialog::getFocusCb(void* w)
{
	getFocus((Widget )w);
}

void XmUserDialog::destroyCb(void* w)
{
	if(magic == MAGIC_OBJECT_CONST && wid == (Widget )w)
	{	wid = NULL;
		delete this;
	}
}

bool XmUserDialog::run(char*, char*)
{
// run modal, args are confirm and cancel control
	return(FALSE);
}

bool XmUserDialog::realize()
{
	if(wid)
	{	int x = 0, y = 0, w = 0, h = 0;
		if(initWindowSize(x, y, w, h))
		{	ix = x; iy = y; iw = w; ih = h;
		}
#ifdef ASCII
		if(ix || iy)
			wid->moveObj(x2cwX(ix), x2cwX(iy));
		if(iw && ih)
			wid->resizeObj(x2cwX(iw), x2cwY(ih));
		wid->show(TRUE);
#else
		if(ix || iy || (iw && ih))
		{	widcmd << "wm geometry " << widpath << " ";
			if(iw && ih)
				widcmd << iw << "x" << ih;
			if(ix || iy)
				widcmd << "+" << ix << "+"<< iy;
			widcmd << "\n";
		}
		wid->realize();
#endif
		return(TRUE);
	}
	return(FALSE);
}

bool XmUserDialog::hide()
{
	if(!wid)
		return(FALSE);
	if(dlgStyle & XmSpopup)
	{	
		return(TRUE);
	}
	return(XmObject::hide());
}

bool XmUserDialog::show()
{
	if(!wid)
		return(FALSE);
	if(dlgStyle & XmSpopup)
	{	
		return(TRUE);
	}
	return(XmObject::show());
}

bool XmUserDialog::setLabel(char* txt)
{
	Arg a;

	if(!wid)
		return(FALSE);
#ifdef ASCII
	wid->setText(txt);
#else
	widcmd << "wm title " << widpath << "\"" << txt << "\"\n";
	wid->execIfVisible();
#endif
	return(TRUE);
}

bool XmUserDialog::setFocus(char*)			{ return(FALSE); }

bool XmUserDialog::setDefaultButton(char* bName)
{
	return(FALSE); 
}

#define do_single_arg(func) \
	XmControl* aControl; \
	if(aControl = find(first)) \
		aControl-> func (); \
	return(aControl ? TRUE : FALSE);

#define do_varargs(func) \
	char* aName = first; \
	XmControl* aControl; \
	va_list ap; \
	va_start(ap, first); \
	do \
	{	if(aControl = find(aName)) \
			aControl-> func (); \
	} \
	while((aName = va_arg(ap, char *)) != (char *)0); \
	va_end(ap); \
	return(TRUE);

#define do_ptrs(func) \
	char* aName = *list; \
	XmControl* aControl; \
	while(aName = *list++) \
	{	if(aControl = find(aName)) \
			aControl-> func (); \
	} \
	return(TRUE);

bool XmDialogPane::disable(char** list)
{
	do_ptrs( disable )
}

bool XmDialogPane::disable(char* first, ...)
{
#ifndef NO_VARARGS
	do_varargs( disable )
#else
	do_single_arg( disable )
#endif
}

bool XmDialogPane::enable(char** list)
{
	do_ptrs( enable )
}

bool XmDialogPane::enable(char* first, ...)
{
#ifndef NO_VARARGS
	do_varargs( enable )
#else
	do_single_arg( enable )
#endif
}

bool XmDialogPane::hideAll(char** list)
{
	do_ptrs( hide )
}

bool XmDialogPane::hideAll(char* first, ...)
{
#ifndef NO_VARARGS
	do_varargs( hide )
#else
	do_single_arg( hide )
#endif
}

bool XmDialogPane::showAll(char** list)
{
	do_ptrs( show )
}

bool XmDialogPane::showAll(char* first, ...)
{
#ifndef NO_VARARGS
	do_varargs( show )
#else
	do_single_arg( show )
#endif
}

// Controls /////////////////////////////////////////////

#ifdef TCL
#define ctrWidValid() wid->getParent()
#endif

XmControl::XmControl(char* n, int x, int y, int w, int h, xmStyle s) : XmObject(n, (XmObject* )NULL)
{
	cx = x; cy = y; cw = w; ch = h;
	style = s;
#ifdef TCL
	wid->setConstrained(FALSE);
#endif
}

XmControl::~XmControl()
{
	if(parent && parent->asDialogPane())
		parent->asDialogPane()->remove(this);
}

bool XmControl::setCbFor(Widget w, char* cbName, XmObject* rec, cbProc code, bool sr, void* cl_data)
{
	if(!rec || !(cbName || defaultCallback()))
	{	cerr << "xmControl: " << wname << " - invalid callback parameters, ignoring request...\n";
		return(FALSE);
	}
	if(!cbName)
		cbName = defaultCallback();
	if(hookedCb() && !strcmp(cbName, hookedCb()) && rec != this)
	{	userData.receiver = rec->getBase();
		userData.callback = code;
		userData.client_data = (cl_data == CB_OBJ_PTR) ? this : cl_data;
	}
	else 
		XmObject::setCbFor(w, cbName, rec, code, sr, (cl_data == CB_OBJ_PTR) ? this : cl_data);
	return(TRUE);
}

void XmControl::makeRelativeTo(XmGroupBox* aGroup)
{
	cx -= aGroup->cx;
	cy -= aGroup->cy;
}

void XmControl::initTabstop(bool force)
{
}

char* XmControl::currentLabel()
{
	char* aStr = wname;
#if defined(ASCII) || defined(TCL)
	if(hasArg("Text"))
		aStr = (char*)wargs[argIndex("Text")].value;
#endif
	return(aStr);
}

void XmControl::setLabelAndMnemonic()
{
#ifdef ASCII
	;	// does nothing, see createControl functions...
#else
	;
#endif
}


XmUserDialog* XmControl::getDialog()
{
	return(parent->asDialog());
}

bool XmControl::move(int nx, int ny)
{
	cx = nx;
	cy = ny;
	if(wid)
#ifdef TCL
		if(wid->getParent())
#endif
		return(XmObject::move(cx, cy));
	return(TRUE);
}

bool XmControl::resize(int nw, int nh)
{
	cw = nw;
	ch = nh;
	if(wid)
#ifdef TCL
		if(wid->getParent())
#endif
		return(XmObject::resize(cw, ch));
	return(TRUE);
}

bool XmControl::reframe(int nx, int ny, int nw, int nh)
{
	cx = nx;
	cy = ny;
	cw = nw;
	ch = nh;
	if(wid)
#ifdef TCL
		if(wid->getParent())
#endif
		return(XmObject::reframe(cx, cy, cw, ch));
	return(TRUE);
}

bool XmControl::getFrame(int& fx, int& fy, int& fw, int& fh)
{
#ifdef ASCII
	if(wid)
		return(XmObject::getFrame(fx, fy, fw, fh));
	else
#endif
	{	fx = cx;
		fy = cy;
		fw = cw;
		fh = ch;
#ifdef TCL
//cerr << "xy: " << fx << "/" << fy << "??????\n";
#endif
	}
	return(TRUE);
}

bool XmControl::updateDimensions()
{
	int ix, iy, iw, ih;

	if(wid)
	{	if(XmObject::getFrame(ix, iy, iw, ih))
		{	cx = ix; cy = iy; cw = iw; ch = ih;
			return(TRUE);
		}
	}
	return(FALSE);
}

XmControl* XmControl::setText(char* aStr)
{
#ifdef ASCII
	if(wid)
		wid->setText(aStr);
	else
		changeArg("Text", aStr); // dangerous..., FIXME!
#else
	if(!ctrWidValid())
	{	addArg("text", (XtArgVal)_mkstr(aStr));
		return(this);
	}
	widcmd << widpath << " configure -text \"" << aStr << "\"\n";
#endif
	return(this);
}

XmControl* XmControl::setFont(char* aStr)
{
	return(this);
}

char* lastGetTextBuffer = NULL;

char* XmControl::getText()
{
	char* curTxt = NULL;
#ifdef ASCII
	if(!wid)
		curTxt = currentLabel();
	else
		curTxt = wid->getText();
#else
	return(wid->getConfigValue("-text"));
#endif
	return(curTxt);
}

XmControl* XmControl::setImage(Pixmap aPixmap)
{
	return(this);
}

XmControl* XmControl::setFocus()
{
#ifdef ASCII
	if(wid)
		wid->getRoot()->setFocusObject(wid);
#endif
	return(this);
}

#define hasState(c) \
 (c == PushButton || c == CheckBox || c == RadioButton || c == Edit || c == ListBox)

XmControl* XmControl::disable()
{
#ifdef ASCII
	if(wid)
		wid->setSensitive(TRUE);
#else
	ctrlType ct = controlType();
	if(hasState(ct))
	{	widcmd << widpath << " configure -state disabled\n";
		wid->execIfVisible();
	}
#endif
	return(this);
}

XmControl* XmControl::enable()
{
#ifdef ASCII
	if(wid)
		wid->setSensitive(FALSE);
#else
	ctrlType ct = controlType();
	if(hasState(ct))
	{	widcmd << widpath << " configure -state normal\n";
		wid->execIfVisible();
	}
#endif
	return(this);
}

bool XmGroupBox::createControl(XmControlPane* par)
{
//	debugPtr = basePtr;
#ifdef ASCII
	wid = new CwDialog(wname, (CwDialog*)par->handle(), x2cwX(cx), x2cwY(cy), x2cwX(cw), x2cwY(ch), TRUE, FALSE);
#else
	widcmd 	<< "frame " << widpath << " -geometry " << cw << "x" << ch
		<< " -relief raised -borderwidth 1\n";
#endif
	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

void XmGroupBox::getFocusCb(void* w)
{
	getFocus((Widget )w);
}

bool XmGroupBox::parentFor(XmControl* c)
{
	if(c->cx > cx && c->cx < cx + cw && c->cy > cy && c->cy < cy + ch)
		return(TRUE);
	return(FALSE);
}

bool XmGroupBox::addAbs(XmControl* c, XmObject* rec, cbProc cb, void* cd)	
{
	c->makeRelativeTo(this);
	return(XmDialogPane::add(c, rec, cb, cd));
}

bool XmGroupBox::remove(char* n)
{
	return(XmDialogPane::remove(n));
}


bool XmPane::createControl(XmControlPane* par)
{
#ifdef ASCII
	wid = new CwDialog(wname, (CwDialog*)par->handle(), x2cwX(cx), x2cwY(cy), x2cwX(cw), x2cwY(ch), TRUE, FALSE);
#else
	widcmd << "frame " << widpath << " -geometry " << cw << "x" << ch << "\n";
#endif
	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

bool XmPane::setContents(XmControl* c, XmObject* rec, cbProc cb)	
{
	if(contents)
	{	if(!contents->destroy())
			return(FALSE);
	}
	contents = NULL;
	if(c)
	{	if(!c->createControl(this))
			return(FALSE);
		contents = c;		// (XmControl* )aControl->asObjPtr();
		if(rec && c->defaultCallback())
			c->setCallback(c->defaultCallback(), rec, cb, TRUE, (void* )c);
		c->userData.receiver = (rec) ? rec->getBase() : rec;
		c->userData.callback = cb;
		if(handle() && isObjVisible(handle()))
			c->realize();
	}
	return(TRUE);
}

bool XmPane::changeLabel(char* txt)
{
	return(FALSE);
}


bool XmPaneArea::createControl(XmControlPane* par)
{
#ifdef ASCII
	wid = new CwDialog(wname, (CwDialog*)par->handle(), x2cwX(cx), x2cwY(cy), x2cwX(cw), x2cwY(ch), TRUE, FALSE);
#else
	widcmd 	<< "frame " << widpath
		<< " -geometry " << cw << "x" << ch
		<< " -relief sunken -borderwidth 3\n";
#endif
	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

void XmPaneArea::changed(void*)
{
}

bool XmPaneArea::add(XmControl* aControl, XmObject* rec, cbProc p, void* cd)
{
	if(XmDialogPane::add(aControl, rec, p, cd))
	{	subPaneCount++;
#ifdef ASCII
		; // do some layout here...
#else
		Widget w = aControl->handle()->getMaster();
		w->setConstrained(TRUE);
		w->setPackingOptions("-side top -expand yes -fill both");
#endif
		return(TRUE);
	}
	return(FALSE);
}

bool XmPaneArea::remove(char* name)
{
	if(!XmDialogPane::remove(name))
		return(FALSE);
	subPaneCount--;
	return(TRUE);
}

bool XmPaneArea::addSubpane(XmControl* aControl, char* title, XmObject* rec, cbProc p)
{
	int nh = aControl->ch ? aControl->ch : (title ? 30 : 10);
	XmPane* aPane;

	if(aControl->controlType() == Edit)
		aControl->changeStyle(aControl->style | XmSmultiLine);	// ensure multi-line...

	if(title)
	{	char namebuf[100];
		strcpy(namebuf, aControl->getName());
		strcat(namebuf, "Pane");
		aPane = new XmPane(namebuf, 0, aControl->cy, cw, nh);
		aPane->setText(title);
		if(add(aPane))
		{	return(aPane->setContents(aControl, rec, p));
		}
		delete aPane;
		return(FALSE);
	}
	aControl->resize(cw, nh);
	if(add(aControl, rec, p))
		return(TRUE);
	return(FALSE);
}

bool XmPaneArea::changeSubpaneLabel(char* name, char* txt)
{
	char namebuf[100];
	XmPane* aPane;

	strcpy(namebuf, name);
	strcat(namebuf, "Pane");
	if(((aPane = (XmPane* )find(name)) || (aPane = (XmPane* )find(namebuf))) && aPane->controlType() == Pane)
		return(aPane->changeLabel(txt));
	cerr << "xmPaneArea: change label error - no pane " << namebuf << " found (" << hex(long(aPane)) << ")\n";
	return(FALSE);
}


bool XmToolBar::createControl(XmControlPane* par)
{
#ifdef ASCII
	wid = new CwLayout(wname, (CwDialog*)par->handle(), x2cwX(cx), x2cwY(cy), x2cwX(cw), x2cwY(ch), TRUE);
	((CwLayout*)wid)->setOrientation((style & XmShorizontal) ? CW_HORIZONTAL : CW_VERTICAL);
	((CwLayout*)wid)->allowResize(FALSE);
#else
	widcmd << "frame " << widpath << "\n";
#endif
	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

bool XmToolBar::add(XmControl* c, XmObject* rec, cbProc cb, void* cd)	
{
#ifdef TCL
	c->handle()->getMaster()->setConstrained(TRUE);
#endif
	if(c->isAn(Edit))
		c->changeStyle(c->getStyle() | XmStabStop);
	return(XmGroupBox::add(c, rec, cb, cd));
}

bool XmStatusBar::createControl(XmControlPane* par)
{
#ifdef ASCII
	return(FALSE);		// not implemented yet... (use a bottom toolbar instead!)
#else
	return(wid ? TRUE : FALSE);
#endif
}

bool XmStatusBar::add(XmControl* aControl, XmObject* anObj, cbProc aProc, void* cl_data)
{
	XmControl* lastControl = controls[controlCount - 1];
#ifdef TCL
	aControl->handle()->getMaster()->setConstrained(TRUE);
#endif
	if(aControl->isAn(Edit))
		aControl->changeStyle(aControl->getStyle() | XmStabStop);
	if(XmGroupBox::add(aControl, anObj, aProc, cl_data))
	{	// lastControl->resize(...);  // should ensure correct layout...
		return(TRUE);
	}
	return(FALSE);
}

bool XmStatusBar::remove(char* aName)
{
	XmControl* prevControl, * aControl = find(aName);
	int ndx = controlIndex(aControl);

	if(!aControl)
		return(FALSE);
	prevControl = controls[ndx - 1];
	if(XmGroupBox::remove(aName))
	{	// prevControl->resize(...);  // should ensure correct layout...
		return(TRUE);
	}
	return(FALSE);
}

bool XmStatusBar::setMessage(char* msg)
{
	return(statusLine ? (statusLine->setText(msg) ? TRUE : FALSE) : FALSE);
}


bool XmStaticText::createControl(XmControlPane* par)
{
#ifdef ASCII
	wid = new CwButton((CwDialog*)par->handle(), wname, currentLabel(),
			x2cwX(cx), x2cwY(cy), x2cwX(cw), x2cwY(ch), FALSE, CW_LABEL);
#else
	widcmd 	<< "label " << widpath
		<< " -width " << x2tclX(this, cw)
		<< " -height " << x2tclY(this, ch) << "\n";
	widcmd 	<< wid->processArgs(wargs, wargcount);
#endif
	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

bool XmStaticImage::createControl(XmControlPane* par)
{
#ifdef ASCII
	wid = new CwButton((CwDialog*)par->handle(), wname, "***",
			x2cwX(cx), x2cwY(cy), x2cwX(cw), x2cwY(ch), TRUE, CW_LABEL);
#else
	widcmd 	<< "label " << widpath
		<< " -width " << x2tclX(this, cw)
		<< " -height " << x2tclY(this, ch)
		<< " -bitmap question" << "\n";
	widcmd 	<< wid->processArgs(wargs, wargcount);
#endif
	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

bool XmPushButton::createControl(XmControlPane* par)
{
#ifdef ASCII
	wid = new CwButton((CwDialog*)par->handle(), wname, currentLabel(),
			x2cwX(cx), x2cwY(cy), x2cwX(cw), x2cwY(ch));
#else
	widcmd 	<< "button " << widpath
		<< " -width " << x2tclX(this, cw)
		<< " -height " << x2tclY(this, ch)
		<< " -command " << wid->callbackString() << "\n";
	widcmd 	<< wid->processArgs(wargs, wargcount);
#endif
	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

bool XmCheckBox::createControl(XmControlPane* par)
{
#ifdef ASCII
	bool initState = getState();

	wid = new CwToggleButton((CwDialog*)par->handle(), wname, currentLabel(),
			x2cwX(cx), x2cwY(cy), x2cwX(cw), x2cwY(ch), FALSE, CW_CHECK_BOX);
	if(initState)
		setState(TRUE);
#else
	widcmd 	<< "checkbutton " << widpath
		<< " -width " << x2tclX(this, cw) - 2
		<< " -height " << x2tclY(this, ch) << " -relief flat"
		<< " -variable " << wid->getVarName()
		<< " -command " << wid->callbackString() << "\n";
	widcmd 	<< wid->processArgs(wargs, wargcount);
#endif
	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

bool XmCheckBox::setState(bool newState)
{
	bool oldState = getState();

	if(oldState != newState)
	{
#ifdef ASCII
		if(wid)
			((CwToggleButton*)wid)->setState(newState);
#else
		if(wid->isOk())
		{	widcmd << "set " << wid->getVarName() << " " << newState << "\n";
			if(wid->isVisible())
				wid->execCmd();
			else
				changeArg("State", long(newState));
		}
#endif
		else
			changeArg("State", long(newState));
	}
	return(oldState);
}

bool XmCheckBox::getState()
{
	if(wid)
	{	int state = 0;
#ifdef ASCII
		if(wid)
			state = ((CwToggleButton*)wid)->getState();
#else
		if(wid->isVisible())
			state = atoi(wid->getVarValue());
#endif
		else if(hasArg("State"))
			state = (int)wargs[argIndex("State")].value;
		return(state ? TRUE : FALSE);
	}
	return(FALSE);
}

bool XmRadioButton::createControl(XmControlPane* par)
{
	bool initState = XmCheckBox::getState();
#ifdef ASCII

	wid = new CwToggleButton((CwDialog*)par->handle(), wname, currentLabel(),
			x2cwX(cx), x2cwY(cy), x2cwX(cw), x2cwY(ch), FALSE, CW_RADIO_BUTTON);
	if(initState)
		XmCheckBox::setState(TRUE);
#else
	widcmd 	<< "radiobutton " << widpath
		<< " -width " << x2tclX(this, cw) - 2
		<< " -height " << x2tclY(this, ch) << " -relief flat"
		<< " -value 1 -variable " << wid->getVarName()
		<< " -command " << wid->callbackString() << "\n";
	widcmd 	<< wid->processArgs(wargs, wargcount);
	widcmd << "set " << wid->getVarName() << " " << initState << "\n";
#endif
	wargcount = 0;
	setCallback(XtNcallback, this, CBK(XmRadioButton, selected), TRUE, NULL);
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

void XmRadioButton::selected(void* cd)
{
	bool curState = getState();

	if(curState)
	{	if(next)
			next->reset(TRUE);
		if(prev)
			prev->reset(FALSE);
		if(userData.receiver && validProc(userData.callback))
			genericCallback(wid, (XtPointer )&userData, (XtPointer )cd);
	}
	else
		setState(TRUE);
}

void XmRadioButton::reset(bool direction)
{
	if(getState())
		setState(FALSE);
	if(direction)
	{	if(next)
			next->reset(direction);
	}
	else
	{	if(prev)
			prev->reset(direction);
	}
}

bool XmRadioButton::setState(bool newState)
{
	if(newState && !getState())
	{	if(next)
			next->reset(TRUE);
		if(prev)
			prev->reset(FALSE);
	}
	return(XmCheckBox::setState(newState));
}

XmRadioButton* XmRadioButton::getSelected()
{
	if(getState())
		return(this);
	XmRadioButton* aButton;
	if(	(next && (aButton = next->getSelected())) ||
		(prev && (aButton = prev->getSelected())))
		return(aButton);
	return(NULL);
}

#include <math.h>

bool XmValuator::createControl(XmControlPane* par)
{
	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

int XmValuator::f2i(float f)
{
	return(int(f * pow(10, decimals)));
}

float XmValuator::i2f(int i)
{
	float f = i;
	return(f / pow(10, decimals));
}

bool XmValuator::setOrientation(bool horiz)
{
	return(FALSE);
}

bool XmValuator::setDirection(bool begToEnd)
{
	return(FALSE);
}

short XmValuator::setDecimalPoints(short d)
{
	return(0);
}

void XmValuator::displayValue(bool yes)
{
}

XmControl* XmValuator::setText(char* txt)
{
	return(this);
}

XmControl* XmValuator::setRange(int from, int to)
{
	return(this);
}

XmControl* XmValuator::setValue(int val)
{
	return(this);
}

int XmValuator::getValue()
{
	return(0);
}


#define EH 25

XmEdit::~XmEdit()
{
	delete pasteBuffer;
	delete lastVersion;
}

bool XmEdit::createControl(XmControlPane* par)
{
	multiLine = (style & XmSmultiLine ? TRUE : FALSE);
	hScroll = (style & XmSautohscroll ? TRUE : FALSE);
	vScroll = (style & XmSautovscroll ? TRUE : FALSE);

#ifdef ASCII
	setText("");
	wid = new CwText((CwDialog*)par->handle(), wname,
			x2cwX(cx), x2cwY(cy), x2cwX(cw), x2cwY(ch));
	((CwText*)wid)->setMultiLine(multiLine);
	((CwText*)wid)->setAutoScroll(hScroll || vScroll ? TRUE : FALSE);
#else
	Widget aFrame, vSb, hSb;
	int lbw = x2tclX(this, cw) - (hScroll ? 2 : 0);
	int lbh = x2tclY(this, ch) - (vScroll ? 1 : 0);

	if(multiLine && (vScroll || hScroll))
	{	char namebuf[300], * widname = wid->getName();
		sprintf(namebuf, "%s-fr", widname);
		aFrame = new XmTclController(this, namebuf, par->handle());
		sprintf(namebuf, "%s-hsb", widname);
		hSb = new XmTclController(this, namebuf, aFrame);
		sprintf(namebuf, "%s-vsb", widname);
		vSb = new XmTclController(this, namebuf, aFrame);
		wid->setParent(aFrame);

		aFrame->cmd() << "frame " << aFrame->getPath() 
			<< " -width " << cw << " -height " << ch
			<< " -borderwidth 1 -relief sunken\n";
		vSb->cmd() << "scrollbar " << vSb->getPath() << " -orient vert";
		vSb->cmd() << " -command \"" << widpath << " yview\"\n";
		hSb->cmd() << "scrollbar " << hSb->getPath() << " -orient horiz";
		hSb->cmd() << "\n";
		// hSb->cmd() << " -command \"" << widpath << " xview\"\n";
		widcmd 	<< "text " << widpath
			<< " -width " << (lbw > 0 ? lbw : 2)
			<< " -height " << (lbh > 0 ? lbh : 2);
		widcmd	<< " -yscrollcommand \"" << vSb->getPath() << " set\"";
		widcmd	<< "\n";
		// widcmd << " -xscrollcommand \"" << hSb->getPath() << " set\"\n";
		wid->setMaster(aFrame);
		aFrame->setConstrained(FALSE);
		wid->setConstrained(TRUE);
		vSb->setConstrained(TRUE);
		hSb->setConstrained(TRUE);
		wid->setPackingOptions("-side left -expand yes -fill both");
		vSb->setPackingOptions("-side right -fill y");
		hSb->setPackingOptions("-side bottom -fill x");
	}
	else
	{	widcmd 	<< (multiLine ? "text " : "entry ") << widpath
			<< " -width " << x2tclX(this, cw);
		if(multiLine)
			widcmd << " -height " << x2tclY(this, ch);
		widcmd << " -relief sunken -borderwidth 1\n";
	}
	widcmd << wid->processArgs(wargs, wargcount);
#endif
	wargcount = 0;
	setCallback(XtNcallback, this, CBK(XmEdit, changed), TRUE);
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

bool XmEdit::resize(int nw, int nh)
{
	return(XmControl::resize(nw, nh));
}

bool XmEdit::reframe(int nx, int ny, int nw, int nh)
{
	return(XmControl::reframe(nx, ny, nw, nh));
}

void XmEdit::changed(void* begEnd)
{
	if(begEnd == (void* )111L)
	{	char* cur = getText();
		lastVersion = strcpy(new char[strlen(cur) + 1], cur);
	}
	else
	{	if((!lastVersion || strcmp(lastVersion, getText())) && userData.receiver && validProc(userData.callback))
			genericCallback(wid, (XtPointer )&userData, (XtPointer )NULL);
		delete lastVersion;
		lastVersion = NULL;
	}
}

XmControl* XmEdit::setText(char* txt)
{
#ifdef ASCII
	XmControl::setText(txt);
#else
	if(!ctrWidValid())
	{	addArg("text", (XtArgVal)_mkstr(txt));
		return(this);
	}
	widcmd 	<< widpath << " delete 0" << (multiLine ? ".0" : "") << " end\n"
		<< widpath << " insert 0" << (multiLine ? ".0" : "")
		<< " \"" << txt << "\"\n";
	wid->execIfVisible();
#endif
	return(this);
}

char* lastEditGetBuffer = NULL;

char* XmEdit::getText()
{
#ifdef ASCII
	return(XmControl::getText());
#else
	ostrstream cmd;
	cmd << "[" << widpath << " get]"; cmd.put('\0');
	char* answer = wid->getValue(cmd.str());
	delete lastEditGetBuffer;
	return(lastEditGetBuffer = _mkstr(answer));
#endif
}

long XmEdit::getInsertPosition(int* x, int* y)
{
	long p;
	Position px, py;

	if(!wid)
		return(0);
	return(0);
}

bool XmEdit::setInsertPosition(long offs)
{
	if(!wid)
		return(FALSE);
	return(FALSE);
}

bool XmEdit::setInsertPosition(int x, int y)
{
	if(!wid)
		return(FALSE);
	return(FALSE);
}

char* lastSelectionBuffer = NULL;

char* XmEdit::getSelection()
{
	if(!wid)
		return(NULL);
	return(NULL);
}

bool XmEdit::getSelection(long& from, long& to)
{
	if(!wid)
		return(FALSE);
	return(FALSE);
}

bool XmEdit::setSelection(long from, long to)
{
	if(!wid)
		return(FALSE);
	return(FALSE);
}

bool XmEdit::clearSelection()
{
	if(!wid)
		return(FALSE);
	return(FALSE);
}

bool XmEdit::cut()
{
	return(FALSE);
}

bool XmEdit::copy()
{
	return(FALSE);
}

bool XmEdit::paste()
{
	return(FALSE);
}


bool XmListBox::createControl(XmControlPane* par)
{
#ifdef ASCII
	wid = new CwList((CwDialog*)par->handle(), wname,
			x2cwX(cx), x2cwY(cy), x2cwX(cw), x2cwY(ch));
	((CwList*)wid)->setMultiSelection(multiSel);
#else
	bool vscroll = TRUE; // (style & XmSautovscroll) ? TRUE : FALSE;
	bool hscroll = TRUE; // (style & XmSautohscroll) ? TRUE : FALSE;
	Widget aFrame, vSb, hSb;
	int lbw = x2tclX(this, cw) - (hscroll ? 2 : 0);
	int lbh = x2tclY(this, ch) - (vscroll ? 1 : 0);

	if(vscroll || hscroll)
	{	char namebuf[300], * widname = wid->getName();
		sprintf(namebuf, "%s-fr", widname);
		aFrame = new XmTclController(this, namebuf, par->handle());
		sprintf(namebuf, "%s-hsb", widname);
		hSb = new XmTclController(this, namebuf, aFrame);
		sprintf(namebuf, "%s-vsb", widname);
		vSb = new XmTclController(this, namebuf, aFrame);
		wid->setParent(aFrame);

		aFrame->cmd() << "frame " << aFrame->getPath() 
			<< " -width " << cw << " -height " << ch
			<< " -borderwidth 1 -relief sunken\n";
		vSb->cmd() << "scrollbar " << vSb->getPath() << " -orient vert";
		vSb->cmd() << " -command \"" << widpath << " yview\"\n";
		hSb->cmd() << "scrollbar " << hSb->getPath() << " -orient horiz";
		hSb->cmd() << " -command \"" << widpath << " xview\"\n";
		widcmd 	<< "listbox " << widpath
			<< " -geometry " << (lbw > 0 ? lbw : 2)
			<< "x" << (lbh > 0 ? lbh : 2);
		widcmd	<< " -yscrollcommand \"" << vSb->getPath() << " set\"";
		widcmd	<< " -xscrollcommand \"" << hSb->getPath() << " set\"\n";
		wid->setMaster(aFrame);
		aFrame->setConstrained(FALSE);
		wid->setConstrained(TRUE);
		vSb->setConstrained(TRUE);
		hSb->setConstrained(TRUE);
		wid->setPackingOptions("-side left -expand yes -fill both");
		vSb->setPackingOptions("-side right -fill y");
		hSb->setPackingOptions("-side bottom -fill x");
	}
	else
		widcmd 	<< "listbox " << widpath
			<< " -geometry " << (lbw ? lbw : 2)
			<< "x" << (lbh ? lbh : 2) << " -relief sunken -borderwidth 1\n";
/*
	widcmd	<< "bind " << widpath << " <Button-1> +[ "
		<< wid->callbackString() << " ]\n";
	widcmd	<< "bind " << widpath << " <Double-1> +[ "
		<< wid->callbackString(NULL, NULL, 1) << " ]\n";
*/
	widcmd	<< "bind " << widpath << " <Double-1> "
		<< wid->callbackString() << "\n";

	widcmd 	<< wid->processArgs(wargs, wargcount);
#endif
	wargcount = 0;
	parent = par->asObject();
	if(wid && initialContents)
	{	addAll(initialContents);
		initialContents = NULL;
	}
	return(wid ? TRUE : FALSE);
}

void XmListBox::cleanup()
{
}

bool XmListBox::resize(int nw, int nh)
{
	return(XmControl::resize(nw, nh));
}

bool XmListBox::reframe(int nx, int ny, int nw, int nh)		// a 'russian' solution...
{
	return(XmControl::reframe(nx, ny, nw, nh));
}

bool XmListBox::change(char*, char*)
{
	return(FALSE);		// should be implemented...!
}

bool XmListBox::change(int, char*)
{
	return(FALSE);		// should be implemented...!
}

XmListBox* XmListBox::addAll(char** list)
{
	if(!wid)
		return(this);
#ifdef ASCII
	((CwList*)wid)->addItems(list);
#else
	insertAll(-1, list);
#endif
	return(this);
}

XmListBox* XmListBox::addAll(char* first,...)
{
	if(!wid)
		return(this);
#ifndef NO_VARARGS
	va_list ap;
	char* anItem = first;
#ifdef TCL
	char* allbuf[100];
	int allcount = 0;
#endif
	va_start(ap, first);
	while(anItem)
#ifdef ASCII
	{	((CwList*)wid)->addItem(anItem);
#else
	{	if(allcount == 100)
			break;
		allbuf[allcount++] = anItem;
#endif
		anItem = va_arg(ap, char*);
	}
	va_end(ap);
#ifdef TCL
	allbuf[allcount] = NULL;
	insertAll(-1, allbuf);
#endif
#else // NO_VARARGS
#ifdef ASCII
	((CwList*)wid)->addItem(first);
#else
	widcmd << widpath << " insert end \"" << first << "\"\n";
	wid->execIfVisible();
#endif
#endif // NO_VARARGS
	return(this);
}

char* tmpListBuf[500];

XmListBox* XmListBox::insertAll(int start, char** list)
{
	if(!wid)
		return(this);
#ifdef ASCII
	((CwList*)wid)->addItems(list, start);
#else
	ostrstream nitems;
	int curlen = 0, curcount = 0, curstart = start;

	for(int i = 0; list[i]; i++)
	{	nitems << " \"" << list[i] << "\"";
		curcount++;
		if((curlen += (strlen(list[i]) + 3)) > 200)
		{	nitems.put('\0');
			widcmd << widpath << " insert ";
			if(start > 0) widcmd << curstart - 1; else widcmd << "end";
			widcmd << " " << nitems.str() << "\n";
			curstart += curcount;
			nitems.seekp(0, ios::beg);
			curlen = curcount = 0;
		}
	}
	if(curcount)
	{	nitems.put('\0');
		widcmd << widpath << " insert ";
		if(start > 0) widcmd << curstart - 1; else widcmd << "end";
		widcmd << " " << nitems.str() << "\n";
	}
	wid->execIfVisible();
#endif
	return(this);
}

XmListBox* XmListBox::insertAll(int start, char* first,...)
{
	if(!wid)
		return(this);
#ifndef NO_VARARGS
	va_list ap;
	char* anItem = first;
#ifdef TCL
	char* allbuf[100];
	int allcount = 0;
#endif
	va_start(ap, first);
	while(anItem)
#ifdef XAW
	{	((CwList*)wid)->addItem(anItem, start);
#else
	{	if(allcount == 100)
			break;
		allbuf[allcount++] = anItem;
#endif
		anItem = va_arg(ap, char*);
	}
	va_end(ap);
#ifdef TCL
	allbuf[allcount] = NULL;
	insertAll(start, allbuf);
#endif
#endif // NO_VARARGS
	return(this);
}

bool XmListBox::removeAll(char** list)
{
	XmString aStr;

	if(!wid)
		return(FALSE);
#ifdef ASCII
	return(((CwList*)wid)->removeItems(list));
#else
static int* indices = NULL;
	int i, fcount = 0, itemCount = getItemCount();
	indices = new int[itemCount + 1];
	for(i = 0; i < itemCount; i++)
	{	ostrstream cmd;
		cmd << "[" << widpath << " get " << i <<"]"; cmd.put('\0');
		char* answer = wid->getValue(cmd.str());
		int lstndx = 0;
		while(list[lstndx])
		{	if(!strcmp(list[lstndx], answer))
				indices[fcount++] = i + 1;
			lstndx++;
		}
	}
	indices[fcount] = 0;
	return(fcount ? removeAll(indices) : FALSE);
#endif
}

bool XmListBox::removeAll(char* first,...)
{
	if(!wid)
		return(FALSE);
#ifndef NO_VARARGS
#ifdef TCL
	char* allbuf[100];
	int allcount = 0;
#endif
	va_list ap;
	char* anItem = first;
	va_start(ap, first);
	while(anItem)
#ifdef ASCII
	{	((CwList*)wid)->removeItem(anItem);
#else
	{	if(allcount == 100)
			break;
		allbuf[allcount++] = anItem;
#endif
		anItem = va_arg(ap, char*);
	}
	va_end(ap);
#ifdef TCL
	allbuf[allcount] = NULL;
	return(allcount ? removeAll(allbuf) : FALSE);
#else
	return(TRUE);
#endif
#endif // NO_VARARGS
}

bool XmListBox::removeAll(int* list)
{
	if(!wid)
		return(FALSE);
#ifdef ASCII
	((CwList*)wid)->removeItems(list);
#else
	int ndx = 0;
	while(list[ndx])
	{	widcmd << widpath << " delete " << list[ndx++] - 1 << "\n";
		wid->execIfVisible();
	}
#endif
	return(TRUE);
}

bool XmListBox::removeAll(int first,...)
{
	if(!wid)
		return(FALSE);
#ifndef NO_VARARGS
	va_list ap;
	int anIndex = first;
#ifdef TCL
	int allbuf[100];
	int allcount = 0;
#endif
	va_start(ap, first);
	while(anIndex)
#ifdef ASCII
	{	((CwList*)wid)->removeItem(anIndex);
#else
	{	if(allcount == 100)
			break;
		allbuf[allcount++] = anIndex;
#endif
		anIndex = va_arg(ap, int);
	}
	va_end(ap);
#ifdef TCL
	allbuf[allcount] = 0;
	return(allcount ? removeAll(allbuf) : FALSE);
#else
	return(TRUE);
#endif
#endif // NO_VARARGS
}

bool XmListBox::clear()
{
	if(!wid)
		return(FALSE);
#ifdef XAW
	return(((CwList*)wid)->clearContents());
#else
	widcmd << widpath << " delete 0 end\n";
	wid->execIfVisible();
#endif
	return(TRUE);
}	

bool XmListBox::selectText(char* anItem, bool notify)
{
	if(!wid)
		return(FALSE);
#ifdef ASCII
	return(((CwList*)wid)->select(anItem, TRUE, notify));
#endif
	return(FALSE);
}

bool XmListBox::selectIndex(int anIndex, bool notify)
{
	if(!wid)
		return(FALSE);
#ifdef ASCII
	return(((CwList*)wid)->select(anIndex, TRUE, notify));
#endif
	return(FALSE);
}

bool XmListBox::deselectText(char* anItem)
{
	if(!wid)
		return(FALSE);
#ifdef ASCII
	return(((CwList*)wid)->select(anItem, FALSE, FALSE));
#endif
	return(FALSE);
}

bool XmListBox::deselectIndex(int anIndex)
{
	if(!wid)
		return(FALSE);
#ifdef ASCII
	return(((CwList*)wid)->select(anIndex, FALSE, FALSE));
#endif
	return(FALSE);
}

bool XmListBox::deselectAll()
{
	if(!wid)
		return(FALSE);
#ifdef ASCII
	return(((CwList*)wid)->clearAllSelections());
#else
//................... widpath select clear
#endif
	return(FALSE);
}

bool XmListBox::setDoubleClickProc(XmObject* rec, cbProc proc)
{
#ifndef ASCII
	cerr << "xmListBox: sorry, double click not implemented.\n";
#endif
	return(FALSE);
}

char** XmListBox::getItems()
{
	char** items = NULL;

	if(!wid)
		return(NULL);
#ifdef ASCII
	return((char**)((CwList*)wid)->getContents());
#else
	int i, itemCount = getItemCount();
	items = new char*[itemCount + 1];
	for(i = 0; i < itemCount; i++)
	{	ostrstream cmd;
		cmd << "[" << widpath << " get " << i <<"]"; cmd.put('\0');
		char* answer = wid->getValue(cmd.str());
		items[i] = _mkstr(answer);
	}
#endif
	return(items);
}

int XmListBox::getItemCount()
{
	int count = 0;
#ifdef ASCII
	return(((CwList*)wid)->itemCount());
#else
	ostrstream cmd;
	cmd << "[" << widpath << " size]"; cmd.put('\0');
	count = atoi(wid->getValue(cmd.str()));
#endif
	return(count);
}

int XmListBox::selectedCount()
{
	if(!wid)
		return(0);
#ifdef ASCII
	return(((CwList*)wid)->selectedItemCount());
#else
	int i, * indices = selectedIndices();
	for(i = 0; indices[i]; i++);
	delete indices;
	return(i);
#endif
}

char** XmListBox::selectedItems()
{
	int numSelected;
	char** items = NULL;

	if(!wid)
		return(NULL);

#ifdef ASCII
	numSelected = ((CwList*)wid)->selectedItemCount();
	items = new char*[numSelected + 1];
	char** cw_items = (char**)((CwList*)wid)->getSelectedItems();
	for(int i = 0; i < numSelected; i++)
		items[i] = cw_items[i];
#else
	int i, * indices = selectedIndices();
	for(i = 0; indices[i]; i++);
	numSelected = i;
	items = new char*[numSelected + 1];
	for(i = 0; indices[i]; i++)
	{	ostrstream cmd;
		cmd << "[" << widpath << " get " << indices[i] - 1 <<"]"; cmd.put('\0');
		char* answer = wid->getValue(cmd.str());
		items[i] = _mkstr(answer);
	}
	delete indices;
#endif
	items[numSelected] = NULL;
	return(items);
}

int* XmListBox::selectedIndices()
{
	int numSelected;
	int* items = NULL;

	if(!wid)
		return(NULL);
#ifdef ASCII
	numSelected = ((CwList*)wid)->selectedItemCount();
	items = new int[numSelected + 1];
	int* cw_items = (int*)((CwList*)wid)->getSelections();
	for(int i = 0; i < numSelected; i++)
		items[i] = cw_items[i];
	items[numSelected] = 0;
#else
	int numItems = multiSel ? getItemCount() : 1;
	ostrstream cmd;
	cmd << "[" << widpath << " curselection]"; cmd.put('\0');
	char* answer = wid->getValue(cmd.str());
	istrstream vals(answer);
	items = new int[numItems + 1];
	int i = 0;
	while(vals.good() && i < numItems)
	{	vals >> items[i];
		items[i]++; i++;
	}
	items[i] = 0;
#endif
	return(items);
}


#ifdef ASCII
#define CAW 25
#define CAH 25
#define CAS 2
#else
#define CAW 25
#define CAH 25
#define CAS 2
#endif

#ifdef COMBO_PROC_CAST
#undef CB
typedef void (XmComboBox::*comboProc)(void*);
inline cbProc makeCbProc(comboProc p)
{ cbProc px; memcpy(&px, &p, sizeof(cbProc)); return(px); }
#define CB(x) makeCbProc(&x)
#endif


 
XmComboBox::XmComboBox(char* name, int x, int y, int w, int h, xmStyle s) :
	XmGroupBox(name, x, y, w, (s & XmSsimple) ? h : CAH, s),
	XmPushButton(name, x + w - CAW, y, CAW, CAH),
	XmEdit(name, x, y, w - CAW - CAS, CAH),
	XmListBox(name, x + CAW, y + CAH, w - CAW, (h > 2 * CAH) ? h - CAH : 4 * CAH)
{
	popup = NULL;
	cbStyle = ((s & XmSdropdownlist) ? DROPDOWNLIST : ((s & XmSsimple) ? SIMPLE : DROPDOWN));
	lbMapped = FALSE;
	ignoreSelect = FALSE;
}

XmComboBox::~XmComboBox()
{
	MEMBER(XmEdit, resetParent)();
	MEMBER(XmPushButton, resetParent)();
	MEMBER(XmListBox, resetParent)();
}

bool XmComboBox::createControl(XmControlPane* par)
{
	int ccx, ccy, ccw, cch;
	MEMBER(XmGroupBox, getFrame)(ccx, ccy, ccw, cch);
#ifdef ASCII
	MEMBER(XmEdit, wid) = new CwComboBox((CwDialog*)par->handle(), MEMBER(XmEdit, wname),
			x2cwX(ccx), x2cwY(ccy), x2cwX(ccw), x2cwY(cch));
	MEMBER(XmListBox, wid) = ((CwComboBox*)MEMBER(XmEdit, wid))->getList();
	MEMBER(XmPushButton, wid) = MEMBER(XmEdit, wid);
	MEMBER(XmGroupBox, wid) = MEMBER(XmEdit, wid);
#else
	char * wn, nbuf[300];
	wn = MEMBER(XmGroupBox, wname);
	Widget gbw = MEMBER(XmGroupBox, wid);
	Widget btw = MEMBER(XmPushButton, wid);
	Widget edw = MEMBER(XmEdit, wid);
	Widget lbw = MEMBER(XmListBox, wid);

	XmGroupBox::createControl(par);

	sprintf(nbuf, "%s-bt", wn);
	btw->setName(nbuf);
	btw->setParent(gbw);
	btw->setConstrained(TRUE);
	btw->setPackingOptions("-side right -fill y");
	XmPushButton::createControl(par);
	MEMBER(XmPushButton, setText)("V");
	MEMBER(XmPushButton, setCallback)((XmGroupBox* )this, CBK(XmComboBox, selectArrow), TRUE, NULL);

	sprintf(nbuf, "%s-ed", wn);
	edw->setName(nbuf);
	edw->setParent(gbw);
	edw->setConstrained(TRUE);
	edw->setPackingOptions("-side left -expand yes -fill both");
	XmEdit::createControl(par);

	sprintf(nbuf, "%s-lb", wn);
	lbw->setName(nbuf);
	XmListBox::createControl(par);
	lbw->getMaster()->dontRealize();
	MEMBER(XmListBox, setCallback)((XmGroupBox* )this, CBK(XmComboBox, selectInList), TRUE, NULL);

	lbMapped = FALSE;
#endif
	return(MEMBER(XmEdit, wid) ? TRUE : FALSE);
}

void XmComboBox::makeRelativeTo(XmGroupBox* aGroup)
{
	MEMBER(XmGroupBox, makeRelativeTo)(aGroup);
}

void XmComboBox::showList(bool n)
{
	Widget lbw = MEMBER(XmListBox, wid);

	if(n)
	{	int nx, ny, nw, nh;
		MEMBER(XmListBox, getFrame)(nx, ny, nw, nh);
		lbw->cmd() << "place " << lbw->getMaster()->getPath()
			   << " -x " << nx << " -y " << ny << "\n"
			   << "raise " << lbw->getMaster()->getPath() << "\n";
	}
	else
		lbw->cmd() << "place forget " << lbw->getMaster()->getPath() << "\n";
	lbw->execCmd();
	lbMapped = n;
}

void XmComboBox::selectArrow(void* info)
{
	showList(lbMapped ? FALSE : TRUE);
}

void XmComboBox::changeText(void* cd)
{
}

void XmComboBox::selectInList(void*)
{
	char* selItem;

	if(selItem = MEMBER(XmListBox, selectedItem)())
		MEMBER(XmEdit, setText)(selItem);
	showList(FALSE);
}

void XmComboBox::cleanupCb(void*)
{
}

bool XmComboBox::realize()
{
#ifdef ASCII
	return(MEMBER(XmEdit, realize)());
#else
	MEMBER(XmGroupBox, realize)();
	MEMBER(XmEdit, realize)();
	MEMBER(XmPushButton, realize)();
	return(TRUE);
#endif
}

bool XmComboBox::move(int nx, int ny)
{
	return(MEMBER(XmEdit, move)(nx, ny));
}

bool XmComboBox::resize(int x, int y)
{
	return(MEMBER(XmEdit, resize)(x, y));
}

bool XmComboBox::reframe(int x, int y, int w, int h)
{
	return(MEMBER(XmEdit, reframe)(x, y, w, h));
}

XmControl* XmComboBox::setFocus()	{ return((XmPushButton* )this); }

XmControl* XmComboBox::disable()
{
	return(MEMBER(XmEdit, disable)());
}

XmControl* XmComboBox::enable()
{
	return(MEMBER(XmEdit, enable)());
}
