/*

 xmconfig.h  - configurable Xm++ compiling options

*/

/* get environment specific defines */

#include <sysdefs.h>

/* default signal handler arguments */

#ifndef SIG_HANDLER_ARGS
#define SIG_HANDLER_ARGS ...
#endif

/* default member syntax */

#ifndef MEMBER
#define MEMBER(c, m) ( c :: m )
#endif

/* environment specific 'work arounds' */

#define VA_OBJ_SUBST(FNS, FNM) \
	bool FNS(Entry); \
	bool FNM(Entry, ...); \
	bool FNM(Entry, Entry); \
	bool FNM(Entry, Entry, Entry); \
	bool FNM(Entry, Entry, Entry, Entry); \
	bool FNM(Entry, Entry, Entry, Entry, Entry); \
	bool FNM(Entry, Entry, Entry, Entry, Entry, Entry); \
	bool FNM(Entry, Entry, Entry, Entry, Entry, Entry, Entry); \
	bool FNM(Entry, Entry, Entry, Entry, Entry, Entry, Entry, Entry); \
	bool FNM(int, Entry*);

#define VA_OBJ_SUBST_IMPL(CLS, FNS, FNM) \
bool CLS::FNS(Entry e0) { Entry e[1]; e[0] = e0; return(FNM(1, e)); } \
bool CLS::FNM(Entry e0, Entry e1) { Entry e[2]; e[0] = e0; e[1] = e1; return(FNM(2, e)); } \
bool CLS::FNM(Entry e0, Entry e1, Entry e2) { Entry e[3]; e[0] = e0; e[1] = e1; e[2] = e2; return(FNM(3, e)); } \
bool CLS::FNM(Entry e0, Entry e1, Entry e2, Entry e3) { Entry e[4]; e[0] = e0; e[1] = e1; e[2] = e2; e[3] = e3; return(FNM(4, e)); } \
bool CLS::FNM(Entry e0, Entry e1, Entry e2, Entry e3, Entry e4) { Entry e[5]; e[0] = e0; e[1] = e1; e[2] = e2; e[3] = e3; e[4] = e4; return(FNM(5, e)); } \
bool CLS::FNM(Entry e0, Entry e1, Entry e2, Entry e3, Entry e4, Entry e5) { Entry e[6]; e[0] = e0; e[1] = e1; e[2] = e2; e[3] = e3; e[4] = e4; e[5] = e5; return(FNM(6, e)); } \
bool CLS::FNM(Entry e0, Entry e1, Entry e2, Entry e3, Entry e4, Entry e5, Entry e6) { Entry e[7]; e[0] = e0; e[1] = e1; e[2] = e2; e[3] = e3; e[4] = e4; e[5] = e5; e[6] = e6; return(FNM(7, e)); } \
bool CLS::FNM(Entry e0, Entry e1, Entry e2, Entry e3, Entry e4, Entry e5, Entry e6, Entry e7) { Entry e[8]; e[0] = e0; e[1] = e1; e[2] = e2; e[3] = e3; e[4] = e4; e[5] = e5; e[6] = e6; e[7] = e7; return(FNM(8, e)); } \
bool CLS::FNM(int count, Entry* entries) \
{	for(int i = 0; i < count; i++) \
	{	if(!(entries[i].text)) \
			break; \
		FNM(entries[i]); \
	} \
	return(TRUE); \
}
