/* ************************************************************************ 
 *         The Amulet User Interface Development Environment              *
 * ************************************************************************
 * This code was written as part of the Amulet project at                 *
 * Carnegie Mellon University, and has been placed in the public          *
 * domain.  If you are using this code or any part of Amulet,             *
 * please contact amulet@cs.cmu.edu to be put on the mailing list.        *
 * ************************************************************************/

#ifndef FORMULA_ADV_H
#define FORMULA_ADV_H

#include <am_inc.h>

#include OBJECT_ADVANCED__H

typedef unsigned short Am_Formula_Mode;

#define Am_FORMULA_KEEP_SOLITARY    0x01
#define Am_FORMULA_ONE_PER_SLOT     0x02
#define Am_FORMULA_DO_NOT_PROPAGATE 0x04

typedef void Am_Data_Release (void* data);

class Am_Formula_Advanced : public Am_Constraint {
 public:
  static bool Test (Am_Constraint* formula);
  static Am_Formula_Advanced* Narrow (Am_Constraint* formula);

  virtual Am_Formula_Mode Get_Mode () = 0;
  virtual void Set_Mode (Am_Formula_Mode mode) = 0;

  virtual Am_Slot Get_Context () = 0;

  virtual void Set_Data (void* data, Am_Data_Release* release_proc) = 0;
};

class Am_Dependency_Data;

class Am_Depends_Iterator {
 public:
  Am_Depends_Iterator ();
  Am_Depends_Iterator (const Am_Formula_Advanced* formula);
  
  Am_Depends_Iterator& operator= (const Am_Formula_Advanced* formula);
  
  unsigned short Length () const;  // Number of slots in the list.
  void Start ();                   // Begin list at the start.
  void Next ();                    // Move to next element in list.
  bool Last () const;              // Is this the last element?
  Am_Slot Get () const;            // Get the current element.

 private:
  const Am_Formula_Advanced* context;
  Am_Dependency_Data* current;
};

#endif
