/* ****************************** -*-c++-*- *******************************/
/* ************************************************************************ 
 *         The Amulet User Interface Development Environment              *
 * ************************************************************************
 * This code was written as part of the Amulet project at                 *
 * Carnegie Mellon University, and has been placed in the public          *
 * domain.  If you are using this code or any part of Amulet,             *
 * please contact amulet@cs.cmu.edu to be put on the mailing list.        *
 * ************************************************************************/


/* This file contains the definitions for widgets in the various 
   looks-and-feels
*/

#ifndef WIDGETS_H
#define WIDGETS_H

#include <am_inc.h>

#include OBJECT__H  //basic object definitions
#include OPAL__H
#include INTER__H  // command objects, etc.
#include VALUE_LIST__H

// options for the Am_WIDGET_LOOK slot of widgets to determine how it is drawn
enum Am_Widget_Look { Am_MOTIF_LOOK, Am_WINDOWS_LOOK, Am_MACINTOSH_LOOK };

extern Am_Input_Char Am_Default_Widget_Start_Char;

extern Am_Object Am_Border_Rectangle;  // a rectangle with fancy edges
extern Am_Object Am_Button;  // a single button
extern Am_Object Am_Button_Panel;  // button panel
extern Am_Object Am_Checkbox_Panel;  // check box panel
extern Am_Object Am_Radio_Button_Panel;  // check box panel
extern Am_Object Am_Menu;
extern Am_Object Am_Menu_Bar;
extern Am_Object Am_Text_Input_Widget;
extern Am_Object Am_Option_Button;

extern Am_Object Am_Menu_Line_Command; //command object to put a line in menu

extern Am_Object Am_Vertical_Scroll_Bar;
extern Am_Object Am_Horizontal_Scroll_Bar;
extern Am_Object Am_Scrolling_Group; // a group with 2 scroll bars

extern Am_Object Am_Tab_To_Next_Widget_Command;
extern Am_Object Am_Tab_To_Next_Widget_Interactor;

extern Am_Object Am_Selection_Widget;
extern Am_Object Am_Selection_Widget_Select_All_Command; //to select all

// dialog_widgets.cc
extern Am_Object Am_Text_Input_Dialog;
extern Am_Object Am_Choice_Dialog;
extern Am_Object Am_Alert_Dialog;

////////////////////////////////////////////////////////////////////////
// Starting, Aborting and Stopping Widgets
////////////////////////////////////////////////////////////////////////
// (these call Start,Stop, and Abort Interactor on the appropriate
//    internal interactors.

//Explicitly start a widget running.  If already running, does nothing.
//If an initial value is provided, then the widget is started with
//this as its value.  It is up to the programmer to make sure the
//Value is legal for the type of widget.  If no initial_value is
//supplied, the widget is started with its current value, if any.

extern void Am_Start_Widget(Am_Object widget,
			    Am_Value initial_value = Am_No_Value);

//Explicitly abort a widget, interactor or command object.  Usually,
//this will be called with a command object, and the system will find
//the associated widget or interactor and abort it.
// If not running, does nothing.  Tries to make sure the command
// object is not entered into the command history.

extern void Am_Abort_Widget(Am_Object widget_or_inter_or_command);

//Explicitly stop a widget.  If not running, raises an error.  If
//final_value is supplied, then this is the value used as the value of
//the widget.  If final_value is not supplied, the widget uses its current
//value.  Commands associated with the widget will be invoked just as
//if the widget had terminated normally.
extern void Am_Stop_Widget(Am_Object widget,
			   Am_Value final_value = Am_No_Value);


////////////////////////////////////////////////////////////////////////
/////// Graphical editing operations////////////////
////////////////////////////////////////////////////////////////////////

// For the property command, to get and set the object's properties
Am_Define_Method_Type(Am_Get_Widget_Property_Value_Method, void,
		      (Am_Object command_obj, Am_Value &new_value))
Am_Define_Method_Type(Am_Get_Object_Property_Value_Method, void,
		      (Am_Object command_obj, Am_Object object, 
		       Am_Value &old_value))
Am_Define_Method_Type(Am_Set_Object_Property_Value_Method, void,
		      (Am_Object command_obj, Am_Object object,
		       Am_Value new_value))

extern Am_Object Am_Global_Clipboard;

extern Am_Object Am_Graphics_Set_Property_Command; //for color, font, etc.

extern Am_Object Am_Graphics_Clear_Command; //delete
extern Am_Object Am_Graphics_Clear_All_Command;
extern Am_Object Am_Graphics_Copy_Command;
extern Am_Object Am_Graphics_Cut_Command;
extern Am_Object Am_Graphics_Paste_Command;
extern Am_Object Am_Undo_Command;
extern Am_Object Am_Redo_Command;
extern Am_Object Am_Graphics_To_Bottom_Command;
extern Am_Object Am_Graphics_To_Top_Command;
extern Am_Object Am_Graphics_Duplicate_Command;
extern Am_Object Am_Graphics_Group_Command;
extern Am_Object Am_Graphics_Ungroup_Command;
extern Am_Object Am_Quit_No_Ask_Command; //quits immediately without asking

/* **** Not implemented yet ******
extern Am_Object Am_Repeat_Last_Command;
extern Am_Object Am_Graphics_Refresh_Command;
extern Am_Object Am_Pop_Up_Dialog_Box_Command;
extern Am_Object Am_Font_Dialog_Box_Command;
extern Am_Object Am_Color_Dialog_Box_Command;
extern Am_Object Am_Open_Command;
extern Am_Object Am_Save_Command;
extern Am_Object Am_Save_As_Command;
extern Am_Object Am_Print_Command;
********** */

////////////////////////////////////////////////////////////////////////
/// Dialog box routines
////////////////////////////////////////////////////////////////////////

// For all of these routines, the Am_Value_List is a list of char* or 
// Am_String objects which will be displayed in the dialog box above any
// text input or buttons in the box.  They create a new dialog box
// and then destroy it at the end of the routine.
extern void Am_Show_Alert_Dialog (Am_Value_List alert_texts, int x = 100, 
				  int y = 100, bool modal = true);

extern Am_Value Am_Get_Input_From_Dialog (Am_Value_List prompt_texts, 
					  Am_String initial_value = "", 
					  int x = 100, int y = 100, 
					  bool modal= true);

extern Am_Value Am_Get_Choice_From_Dialog (Am_Value_List prompt_texts, 
					   int x = 100, int y = 100,
					   bool modal = true);

// Given a user-made dialog box, this sets its stop method, brings it
// up, and returns its value using Am_Pop_Up_Window_And_Wait.
// This is useful for efficiency if a certain dialog box is used many
// times and you don't need to destroy it after use.

extern Am_Value Am_Show_Dialog_And_Wait (Am_Object the_dialog,
					 bool modal = true);

#endif
