//  set : headerfile for the free standard C++ library
//  
//  Copyright (C) 1999 by the free standard C++ Library Team
//                        see AUTHORS for more details
//
//  Homepage : http://www.inf.fu-berlin.de/~mkrueger/fscl/
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either	
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//  You should have received a copy of the GNU Library General Public
//  License along with this library; if not, write to the Free
//  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//  version : 0.1 last modified : 17.09.99


#ifndef __CPP_SET
#define __CPP_SET

namespace std {

	// 23.3.3 Template class set
	template <class Key, class Compare = less<Key>, class Allocator = allocator<Key> >
	class set
	{
		public:
			// types:
			typedef Key                                       key_type;
			typedef Key                                       value_type;
			typedef Compare                                   key_compare;
			typedef Compare                                   value_compare;
			typedef Allocator                                 allocator_type;
			typedef typename Allocator::reference             reference;
			typedef typename Allocator::const_reference       const_reference;
			typedef typename Allocator::size_type             size_type;
			typedef typename Allocator::difference_type       difference_type;
			typedef typename Allocator::pointer               pointer;
			typedef typename Allocator::const_pointer         const_pointer;
			typedef std::reverse_iterator<iterator>           reverse_iterator;
			typedef std::reverse_iterator<const_iterator>     const_reverse_iterator;
			
			typedef implementation defined                    iterator;       // See _lib.container.requirements_
			typedef implementation defined                    const_iterator; // See _lib.container.requirements_
			
			
			// 23.3.3.1 construct/copy/destroy:
			explicit set(const Compare& comp = Compare(), const Allocator& alloc = Allocator())
			{
			}
			
			template <class InputIterator>
			set(InputIterator first, InputIterator last, const Compare& comp = Compare(), const Allocator& alloc = Allocator())
			{
			}
			
			set(const set<Key,Compare,Allocator>& x)
			{
			}
			
			~set()
			{
			}
			
			set<Key,Compare,Allocator>& operator=(const set<Key,Compare,Allocator>& x)
			{
			}
			
			allocator_type get_allocator() const
			{
			}
			
			// iterators:			
			iterator               begin()
			{
			}			
			const_iterator         begin() const
			{
			}			
			iterator               end()
			{
			}			
			const_iterator         end() const
			{
			}			
			reverse_iterator       rbegin()
			{
			}			
			const_reverse_iterator rbegin() const
			{
			}			
			reverse_iterator       rend()
			{
			}			
			const_reverse_iterator rend() const				
			{
			}
			
			// capacity:
			bool          empty() const
			{
			}
			size_type     size() const
			{
			}
			size_type     max_size() const
			{
			}
			
			// modifiers:
			pair<iterator,bool> insert(const value_type& x)
			{
			}
			
			iterator insert(iterator position, const value_type& x)
			{
			}
			
			template <class InputIterator>
			void insert(InputIterator first, InputIterator last)
			{
			}
			
			void      erase(iterator position)
			{
			}
			
			size_type erase(const key_type& x)
			{
			}
			
			void      erase(iterator first, iterator last)
			{
			}
			
			void swap(set<Key,Compare,Allocator>& x)
			{
			}
			
			void clear()
			{
			}
			
			// observers:
			key_compare   key_comp() const
			{
			}
			
			value_compare value_comp() const
			{
			}
			
			// set operations:
			iterator  find(const key_type& x) const
			{
			}
			
			size_type count(const key_type& x) const
			{
			}
			
			iterator  lower_bound(const key_type& x) const
			{
			}
			
			iterator  upper_bound(const key_type& x) const
			{
			}
			
			pair<iterator,iterator> equal_range(const key_type& x) const
			{
			}
	};
	
	template <class Key, class Compare, class Allocator>
	bool operator==(const set<Key,Compare,Allocator>& x, const set<Key,Compare,Allocator>& y)
	{
	}

	template <class Key, class Compare, class Allocator>
	bool operator< (const set<Key,Compare,Allocator>& x, const set<Key,Compare,Allocator>& y)
	{
	}

	template <class Key, class Compare, class Allocator>
	bool operator!=(const set<Key,Compare,Allocator>& x, const set<Key,Compare,Allocator>& y)
	{
	}

	template <class Key, class Compare, class Allocator>
	bool operator> (const set<Key,Compare,Allocator>& x, const set<Key,Compare,Allocator>& y)
	{
	}
	
	template <class Key, class Compare, class Allocator>
	bool operator>=(const set<Key,Compare,Allocator>& x, const set<Key,Compare,Allocator>& y)
	{
	}

	template <class Key, class Compare, class Allocator>
	bool operator<=(const set<Key,Compare,Allocator>& x, const set<Key,Compare,Allocator>& y)
	{
	}
	
	// specialized algorithms:
	template <class Key, class Compare, class Allocator>
	void swap(set<Key,Compare,Allocator>& x, set<Key,Compare,Allocator>& y)
	{
	}
	
	// 23.3.4 Template class multiset
	template <class Key, class Compare = less<Key>, class Allocator = allocator<Key> >
	class multiset
	{
		public:
			typedef Key                                       key_type;
			typedef Key                                       value_type;
			typedef Compare                                   key_compare;
			typedef Compare                                   value_compare;
			typedef Allocator                                 allocator_type;
			typedef typename Allocator::reference             reference;
			typedef typename Allocator::const_reference       const_reference;
			typedef implementation defined                    iterator;       // See _lib.container.requirements_
			typedef implementation defined                    const_iterator; // See _lib.container.requirements_
			typedef typename Allocator::size_type             size_type;
			typedef typename Allocator::difference_type       difference_type;
			typedef typename Allocator::pointer               pointer;
			typedef typename Allocator::const_pointer         const_pointer;
			typedef std::reverse_iterator<iterator>           reverse_iterator;
			typedef std::reverse_iterator<const_iterator>     const_reverse_iterator;
			
			// construct/copy/destroy:
			explicit multiset(const Compare& comp = Compare(), const Allocator& alloc = Allocator())
			{
			}

			template <class InputIterator>
			multiset(InputIterator first, InputIterator last, const Compare& comp = Compare(), const Allocator& alloc = Allocator())
			{
			}
			multiset(const multiset<Key,Compare,Allocator>& x)
			{
			}
			~multiset()
			{
			}
			multiset<Key,Compare,Allocator> &operator=(const multiset<Key,Compare,Allocator>& x)
			{
			}
			allocator_type get_allocator() const
			{
			}
			// iterators:
			iterator               begin()
			{
			}
			const_iterator         begin() const
			{
			}
			iterator               end()
			{
			}
			const_iterator         end() const
			{
			}
			reverse_iterator       rbegin()
			{
			}
			const_reverse_iterator rbegin() const
			{
			}
			reverse_iterator       rend()
			{
			}
			const_reverse_iterator rend() const
			{
			}

			
			// capacity:
			bool          empty() const
			{
			}
			size_type     size() const
			{
			}
			size_type     max_size() const
			{
			}

			
			// modifiers:
			iterator insert(const value_type& x)
			{
			}
			iterator insert(iterator position, const value_type& x)
			{
			}
			
			template <class InputIterator>
			void insert(InputIterator first, InputIterator last)
			{
			}
			
			void      erase(iterator position)
			{
			}		
			size_type erase(const key_type& x)
			{
			}
			void erase(iterator first, iterator last)
			{
			}

			
			void swap(multiset<Key,Compare,Allocator> &x)
			{
			}			
			void clear()
			{
			}
			
			// observers:
			key_compare   key_comp() const
			{
			}
			value_compare value_comp() const
			{
			}
			
			// set operations:
			iterator  find(const key_type& x) const
			{
			}
			size_type count(const key_type& x) const
			{
			}
			
			iterator  lower_bound(const key_type& x) const
			{
			}
			iterator  upper_bound(const key_type& x) const
			{
			}
			pair<iterator,iterator> equal_range(const key_type& x) const
			{
			}
	};
	
	template <class Key, class Compare, class Allocator>
	bool operator==(const multiset<Key,Compare,Allocator>& x, const multiset<Key,Compare,Allocator>& y)
	{
	}

	template <class Key, class Compare, class Allocator>
	bool operator< (const multiset<Key,Compare,Allocator>& x, const multiset<Key,Compare,Allocator>& y)
	{
	}

	template <class Key, class Compare, class Allocator>
	bool operator!=(const multiset<Key,Compare,Allocator>& x, const multiset<Key,Compare,Allocator>& y)
	{
	}

	template <class Key, class Compare, class Allocator>
	bool operator> (const multiset<Key,Compare,Allocator>& x, const multiset<Key,Compare,Allocator>& y)
	{
	}

	template <class Key, class Compare, class Allocator>
	bool operator>=(const multiset<Key,Compare,Allocator>& x, const multiset<Key,Compare,Allocator>& y)
	{
	}

	template <class Key, class Compare, class Allocator>
	bool operator<=(const multiset<Key,Compare,Allocator>& x, const multiset<Key,Compare,Allocator>& y)
	{
	}

	// specialized algorithms:
	template <class Key, class Compare, class Allocator>
	void swap(multiset<Key,Compare,Allocator>& x, multiset<Key,Compare,Allocator>& y)
	{
	}
}

#endif
