//  valarray : headerfile for the free standard C++ library
//  
//  Copyright (C) 1999 by the free standard C++ Library Team
//                        see AUTHORS for more details
//
//  Homepage : http://www.inf.fu-berlin.de/~mkrueger/fscl/
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either	
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//  You should have received a copy of the GNU Library General Public
//  License along with this library; if not, write to the Free
//  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//  version : 0.1 last modified : 17.09.99


#ifndef __CPP_VALARRAY
#define __CPP_VALARRAY

#include<cstddef>
#include<new>

#include<vector>

namespace std {

	// 26.3.2 Template class valarray
	template<class T> 
	class valarray
	{
		public:
			typedef T value_type;

			// 26.3.2.1 construct / destroy :
			valarray();
			explicit valarray(size_t n);
			valarray(const T& x, size_t n);
			valarray(const T* p, size_t n);
			valarray(const valarray& v);
			/*
			valarray(const slice_array<T>& sa);
			valarray(const gslice_array<T>& gsa);
			valarray(const mask_array<T>& ma);
			valarray(const indirect_array<T>& ia);
			*/
			~valarray();

			// 26.3.2.2 assignment:
			valarray<T>& operator=(const valarray<T>& x);
			valarray<T>& operator=(const T& a);
			/*
			valarray<T>& operator=(const slice_array<T>& x);
			valarray<T>& operator=(const gslice_array<T>& x);
			valarray<T>& operator=(const mask_array<T>& x);
			valarray<T>& operator=(const indirect_array<T>& x); 
			*/
			
			// 26.3.2.3 element access:
			T                 operator[](size_t) const;
			T&                operator[](size_t);
			
			// 26.3.2.4 subset operations:
			/*
			valarray<T>       operator[](slice) const;
			slice_array<T>    operator[](slice);
			valarray<T>       operator[](const gslice&) const;
			gslice_array<T>   operator[](const gslice&);
			*/
			valarray<T>       operator[](const valarray<bool>& x) const;
//			mask_array<T>     operator[](const valarray<bool>& x);
			valarray<T>       operator[](const valarray<size_t>& x) const;
//			indirect_array<T> operator[](const valarray<size_t>& x);

			// 26.3.2.5 unary operators:
			valarray<T> operator+() const;
			valarray<T> operator-() const;
			valarray<T> operator~() const;
			valarray<T> operator!() const;
			
			// 26.3.2.6 computed assignment:
			valarray<T>& operator*= (const T& a);
			valarray<T>& operator/= (const T& a);
			valarray<T>& operator%= (const T& a);
			valarray<T>& operator+= (const T& a);
			valarray<T>& operator-= (const T& a);
			valarray<T>& operator^= (const T& a);
			valarray<T>& operator&= (const T& a);
			valarray<T>& operator|= (const T& a);
			valarray<T>& operator<<=(const T& a);
			valarray<T>& operator>>=(const T& a);
			valarray<T>& operator*= (const valarray<T>& x);
			valarray<T>& operator/= (const valarray<T>& x);
			valarray<T>& operator%= (const valarray<T>& x);
			valarray<T>& operator+= (const valarray<T>& x);
			valarray<T>& operator-= (const valarray<T>& x);
			valarray<T>& operator^= (const valarray<T>& x);
			valarray<T>& operator|= (const valarray<T>& x);
			valarray<T>& operator&= (const valarray<T>& x);
			valarray<T>& operator<<=(const valarray<T>& x);
			valarray<T>& operator>>=(const valarray<T>& x);
			
			// 26.3.2.7 member functions:
			size_t size() const;
			
			T    sum() const;
			T    min() const;
			T    max() const;

			valarray<T> shift (int) const;
			valarray<T> cshift(int) const;
			valarray<T> apply(T func(T)) const;
			valarray<T> apply(T func(const T&)) const;
			void resize(size_t sz, T c = T());			
	};
	
	// 26.3.4 class slice
	class slice
	{
		public:
			slice();
			slice(size_t, size_t, size_t);
			
			size_t start() const;
			size_t size() const;
			size_t stride() const;
	};
	
	// 26.3.5 Template class slice_array
	template<class T>
	class slice_array
	{
		public:
			typedef T value_type;
			
			void operator=  (const valarray<T>& x) const;
			void operator*= (const valarray<T>& x) const;
			void operator/= (const valarray<T>& x) const;
			void operator%= (const valarray<T>& x) const;
			void operator+= (const valarray<T>& x) const;
			void operator-= (const valarray<T>& x) const;
			void operator^= (const valarray<T>& x) const;
			void operator&= (const valarray<T>& x) const;
			void operator|= (const valarray<T>& x) const;
			void operator<<=(const valarray<T>& x) const;
			void operator>>=(const valarray<T>& x) const;

			void operator=(const T&);
			~slice_array();

			slice_array();
			slice_array(const slice_array&);
			slice_array& operator=(const slice_array&);
	};
	
	// 26.3.6 class gslice
	class gslice
	{
		public:
			gslice();
			gslice(size_t s, const valarray<size_t>& l, const valarray<size_t>& d);
			size_t           start() const;
			valarray<size_t> size() const;
			valarray<size_t> stride() const;
	};
	
	// 26.3.7 Template class gslice_array
	template<class T>
	class gslice_array
	{
		public:
			typedef T value_type;
			
			void operator=  (const valarray<T>&) const;
			void operator*= (const valarray<T>&) const;
			void operator/= (const valarray<T>&) const;
			void operator%= (const valarray<T>&) const;
			void operator+= (const valarray<T>&) const;
			void operator-= (const valarray<T>&) const;
			void operator^= (const valarray<T>&) const;
			void operator&= (const valarray<T>&) const;
			void operator|= (const valarray<T>&) const;
			void operator<<=(const valarray<T>&) const;
			void operator>>=(const valarray<T>&) const;
			
			void operator=(const T&);
			~gslice_array();

			gslice_array();
			gslice_array(const gslice_array&);
			gslice_array& operator=(const gslice_array&);
	};
	
	// 26.3.8 Template class mask_array
	template<class T>
	class mask_array
	{
		public:
			typedef T value_type;
			void operator=  (const valarray<T>&) const;
			void operator*= (const valarray<T>&) const;
			void operator/= (const valarray<T>&) const;
			void operator%= (const valarray<T>&) const;
			void operator+= (const valarray<T>&) const;
			void operator-= (const valarray<T>&) const;
			void operator^= (const valarray<T>&) const;
			void operator&= (const valarray<T>&) const;
			void operator|= (const valarray<T>&) const;
			void operator<<=(const valarray<T>&) const;
			void operator>>=(const valarray<T>&) const;
			void operator=(const T&);
			~mask_array();
			mask_array();
			mask_array(const mask_array&);
			mask_array& operator=(const mask_array&);
			//  remainder implementation defined 
	};

	// 26.3.9 Template class indirect_array
	template<class T>
	class indirect_array
	{  
		public:
			typedef T value_type;
			
			void operator=  (const valarray<T>&) const;
			void operator*= (const valarray<T>&) const;
			void operator/= (const valarray<T>&) const;
			void operator%= (const valarray<T>&) const;
			void operator+= (const valarray<T>&) const;
			void operator-= (const valarray<T>&) const;
			void operator^= (const valarray<T>&) const;
			void operator&= (const valarray<T>&) const;
			void operator|= (const valarray<T>&) const;
			void operator<<=(const valarray<T>&) const;
			void operator>>=(const valarray<T>&) const;
			
			void operator=(const T&);
			~indirect_array();

			indirect_array();
			indirect_array(const indirect_array&);
			indirect_array& operator=(const indirect_array&);
	};
	
	template<class T>
	valarray<T> operator* (const valarray<T>& x, const valarray<T>& y)
	{
		return valarray<T>(x) *= y;
	}
	template<class T> 
	valarray<T> operator* (const valarray<T>& x, const T& a)
	{
		return valarray<T>(a) *= x;
	}
	template<class T> 
	valarray<T> operator* (const T& a, const valarray<T>& x)
	{
		return valarray<T>(a) *= x;
	}

	template<class T> 
	valarray<T> operator/ (const valarray<T>& x, const valarray<T>& y)
	{
		return valarray<T>(x) /= y;		
	}
	template<class T> 
	valarray<T> operator/ (const valarray<T>& x, const T& a)
	{
		return valarray<T>(x) /= a;
	}
	template<class T> 
	valarray<T> operator/ (const T& a, const valarray<T>& x)
	{
		return valarray<T>(a) /= x;
	}

	template<class T> 
	valarray<T> operator% (const valarray<T>& x, const valarray<T>& y)
	{
		return valarray<T>(x) %= y;
	}
	template<class T> 
	valarray<T> operator% (const valarray<T>& x, const T& a)
	{
		return valarray<T>(x) %= a;
	}
	template<class T> 
	valarray<T> operator% (const T& a, const valarray<T>& x)
	{
		return valarray<T>(a) %= x;		
	}

	template<class T> 
	valarray<T> operator+ (const valarray<T>& x, const valarray<T>& y)
	{
		return valarray<T>(x) += y;
	}
	template<class T> 
	valarray<T> operator+ (const valarray<T>& x, const T& a)
	{
		return valarray<T>(x) += a;
	}
	template<class T> 
	valarray<T> operator+ (const T& a, const valarray<T>& x)
	{
		return valarray<T>(a) += x;
	}

	template<class T> 
	valarray<T> operator- (const valarray<T>& x, const valarray<T>& y)
	{
		return valarray<T>(x) -= y;	
	}
	template<class T> 
	valarray<T> operator- (const valarray<T>& x, const T& a)
	{
		return valarray<T>(x) -= a;
	}
	template<class T> 
	valarray<T> operator- (const T& a, const valarray<T>& x)
	{
		return valarray<T>(a) -= x;
	}

	template<class T> 
	valarray<T> operator^ (const valarray<T>& x, const valarray<T>& y)
	{
		return valarray<T>(x) ^= y;
	}

	template<class T> 
	valarray<T> operator^ (const valarray<T>& x, const T& a)
	{
		return valarray<T>(x) ^= a;	
	}

	template<class T> 
	valarray<T> operator^ (const T& a, const valarray<T>& x)
	{
		return valarray<T>(a) ^= x;
	}

	template<class T> 
	valarray<T> operator& (const valarray<T>& x, const valarray<T>& y)
	{
		return valarray<T>(x) &= y;
	}
	template<class T> 
	valarray<T> operator& (const valarray<T>& x, const T& a)
	{
		return valarray<T>(x) &= a;
	}	
	template<class T> 
	valarray<T> operator& (const T& a, const valarray<T>& x)
	{
		return valarray<T>(a) &= x;
	}

	template<class T> 
	valarray<T> operator| (const valarray<T>& x, const valarray<T>& y)
	{
		return valarray<T>(x) |= y;
	}
	template<class T> 
	valarray<T> operator| (const valarray<T>& x, const T& a)
	{
		return valarray<T>(x) |= a;
	}
	template<class T> 
	valarray<T> operator| (const T& a, const valarray<T>& x)
	{
		return valarray<T>(a) |= x;
	}
	
	template<class T> 
	valarray<T> operator<<(const valarray<T>& x, const valarray<T>& y)
	{
		return valarray<T>(x) <<= y;
	}
	template<class T>
	valarray<T> operator<<(const valarray<T>& x, const T& a)
	{
		return valarray<T>(x) <<= a;
	}
	template<class T> 
	valarray<T> operator<<(const T& a, const valarray<T>& x)
	{
		return valarray<T>(a) <<= x;
	}

	template<class T> 
	valarray<T> operator>>(const valarray<T>& x, const valarray<T>& y)
	{
		return valarray<T>(x) >>= y;
	}
	template<class T> 
	valarray<T> operator>>(const valarray<T>& x, const T& a)
	{
		return valarray<T>(x) >>= a;
	}
	template<class T> 
	valarray<T> operator>>(const T& a, const valarray<T>& x)
	{
		return valarray<T>(a) >>= x;
	}
/*
	template<class T> 
	valarray<bool> operator&&(const valarray<T>& x, const valarray<T>& y)
	{
		return valarray<T>(x) &&= y;
	}
	
	template<class T> 
	valarray<bool> operator&&(const valarray<T>& x, const T& a)
	{
		return valarray<T>(x) &&= a;
	}
	
	template<class T> 
	valarray<bool> operator&&(const T& a, const valarray<T>& x)
	{
		return valarray<T>(a) &&= x;
	}
	template<class T> 
	valarray<bool> operator||(const valarray<T>& x, const valarray<T>& y)
	{
		return valarray<T>(x) ||= y;
	}
	
	template<class T> 
	valarray<bool> operator||(const valarray<T>& x , const T& a)
	{
		return valarray<T>(x) ||= a;
	}
	template<class T> 
	valarray<bool> operator||(const T& a, const valarray<T>& x)
	{
		return valarray<T>(a) ||= x;
	}
	*/

	template<class T>
	valarray<bool> operator==(const valarray<T>& x, const valarray<T>& y)
	{ // TODO
	}
	template<class T> 
	valarray<bool> operator==(const valarray<T>& x, const T& a)
	{
		return x == valarray<T>(a);
	}
	template<class T> 
	valarray<bool> operator==(const T& a, const valarray<T>& x)
	{
		return valarray<T>(a) == x;
	}

	template<class T>
	valarray<bool> operator!=(const valarray<T>& x, const valarray<T>& y)
	{
		return !(x == y);
	}	
	template<class T>
	valarray<bool> operator!=(const valarray<T>& x, const T& a)
	{
		return x != valarray<T>(a);
	}
	template<class T>
	valarray<bool> operator!=(const T& a, const valarray<T>& x)
	{
		return valarray<T>(a) != x;
	}

	template<class T>
	valarray<bool> operator< (const valarray<T>& x, const valarray<T>& y)
	{ // TODO
	}
	template<class T> 
	valarray<bool> operator< (const valarray<T>& x, const T& a)
	{
		return x < valarray<T>(a);
	}
	template<class T>
	valarray<bool> operator< (const T& a, const valarray<T>& x)
	{
		return valarray<T>(a) < x;
	}

	template<class T>
	valarray<bool> operator> (const valarray<T>& x, const valarray<T>& y)
	{ // TODO
	}
	template<class T> 
	valarray<bool> operator> (const valarray<T>& x, const T& a)
	{
		return x > valarray<T>(a);
	}
	template<class T> 
	valarray<bool> operator> (const T& a, const valarray<T>& x)
	{
		return valarray<T>(a) > x;
	}

	template<class T>
	valarray<bool> operator<=(const valarray<T>& x, const valarray<T>& y)
	{
		return !(x > y);
	}
	template<class T> 
	valarray<bool> operator<=(const valarray<T>& x, const T& a)
	{
		return x <= valarray<T>(a);
	}
	template<class T> 
	valarray<bool> operator<=(const T& a, const valarray<T>& x)
	{
		return  valarray<T>(a) <= x;
	}

	template<class T>
	valarray<bool> operator>=(const valarray<T>& x, const valarray<T>& y)
	{
		return !(x < y);
	}
	template<class T> 
	valarray<bool> operator>=(const valarray<T>& x, const T& a) 
	{
		return x >= valarray<T>(a);
	}
	template<class T> 
	valarray<bool> operator>=(const T& a, const valarray<T>& x)
	{
		return x >= valarray<T>(a);
	}

	template<class T> 
	T min(const valarray<T>& x)
	{
	}

	template<class T> 
	T max(const valarray<T>& y)
	{
	}

	template<class T> 
	valarray<T> abs  (const valarray<T>& x)
	{
	}

	template<class T> 
	valarray<T> acos (const valarray<T>& x)
	{
	}

	template<class T> 
	valarray<T> asin (const valarray<T>& x)
	{
	}
	

	template<class T> 
	valarray<T> atan (const valarray<T>& x)
	{
	}

	template<class T> 
	valarray<T> atan2(const valarray<T>& x, const valarray<T>& y)
	{
	}

	template<class T> 
	valarray<T> atan2(const valarray<T>& x, const T& a)
	{
		return atan2(x, valarray<T>(a));
	}
	template<class T> 
	valarray<T> atan2(const T& a, const valarray<T>& x)
	{
		return atan2(valarray<T>(a), x);
	}

	template<class T> 
	valarray<T> cos  (const valarray<T>& x)
	{
	}

	template<class T> 
	valarray<T> cosh (const valarray<T>& x)
	{
	}

	template<class T> 
	valarray<T> exp  (const valarray<T>& x)
	{
	}

	template<class T> 
	valarray<T> log  (const valarray<T>& x)
	{
	}

	template<class T> 
	valarray<T> log10(const valarray<T>& x)
	{
	}

	template<class T> 
	valarray<T> pow  (const valarray<T>& x, const valarray<T>& y)
	{
	}

	template<class T> 
	valarray<T> pow  (const valarray<T>& x, const T& a)
	{
		return pow(x,valarray<T>(a));
	}

	template<class T> 
	valarray<T> pow  (const T& a, const valarray<T>& x)
	{
		return pow(valarray<T>(a), x);
	}

	template<class T> 
	valarray<T> sin  (const valarray<T>& x)
	{
	}
	template<class T> 
	valarray<T> sinh (const valarray<T>& x)
	{
	}

	template<class T> 
	valarray<T> sqrt (const valarray<T>& x)
	{
	}

	template<class T> 
	valarray<T> tan  (const valarray<T>& x)
	{
	}

	template<class T> 
	valarray<T> tanh (const valarray<T>& x)
	{
	}

}

#endif
