/**********************************************************************
** $Id: qpsprn.h,v 2.1 1997/06/06 10:43:36 eiriken Exp $
**
**		      ***   INTERNAL HEADER FILE   ***
**
**		This file is NOT a part of the Qt interface!
**
** Definition of internal QPSPrinter class.
** QPSPrinter implements PostScript (tm) output via QPrinter.
**
** Created : 940927
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the free edition of Qt 1.33.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** IMPORTANT NOTE: You may NOT copy this file or any part of it into
** your own programs or libraries.
**
** (This file differs from the one in the commercial edition of Qt
** only by this comment.)
**
*****************************************************************************/

#ifndef QPSPRN_H
#define QPSPRN_H

#include "qprinter.h"
#include "qtstream.h"


class QPSPrinter : public QPaintDevice
{
private:
    QPSPrinter( QPrinter * );
   ~QPSPrinter();

    bool	cmd ( int, QPainter *, QPDevCmdParam * );

    QPrinter   *printer;
    QIODevice  *device;
    QTextStream stream;
    int		pageCount;
    bool	dirtyMatrix;
    bool	dirtyNewPage;
    QString	fontsUsed;
    friend class QPrinter;

private:	// Disabled copy constructor and operator=
    QPSPrinter( const QPSPrinter & ):QPaintDevice(0) {}
    QPSPrinter &operator=( const QPSPrinter & ) { return *this; }

    void matrixSetup( QPainter * );
    void orientationSetup();
    void newPageSetup( QPainter * );
};


// Additional commands for QPSPrinter

#define PDC_PRT_NEWPAGE 100
#define PDC_PRT_ABORT	101


#endif // QPSPRN_H
