#include <toad/toad.hh>
#include <toad/macros.hh>

#include "MainWindow.hh"

int ToadMain()
{
	return TMainWindow(NULL, "(untitled)").Run();
}

CONSTRUCTOR(TMainWindow)
{
	SetSize(512,256);
}

void TMainWindow::paint()
{
	TPen pen(this);

	for(int i=0; i<16; i++) {
		switch(i) {
			case 0:
				pen.SetColor(TColor::BLACK);
				break;
			case 1:
				pen.SetColor(TColor::RED);
				break;
			case 2:
				pen.SetColor(TColor::GREEN);
				break;
			case 3:
				pen.SetColor(TColor::YELLOW);
				break;
			case 4:
				pen.SetColor(TColor::BLUE);
				break;
			case 5:
				pen.SetColor(TColor::MAGENTA);
				break;
			case 6:
				pen.SetColor(TColor::CYAN);
				break;
			case 7:
				pen.SetColor(TColor::GRAY);
				break;
			case 8:
				pen.SetColor(TColor::LIGHTGRAY);
				break;
			case 9:
				pen.SetColor(TColor::LIGHTRED);
				break;
			case 10:
				pen.SetColor(TColor::LIGHTGREEN);
				break;
			case 11:
				pen.SetColor(TColor::LIGHTYELLOW);
				break;
			case 12:
				pen.SetColor(TColor::LIGHTBLUE);
				break;
			case 13:
				pen.SetColor(TColor::LIGHTMAGENTA);
				break;
			case 14:
				pen.SetColor(TColor::LIGHTCYAN);
				break;
			case 15:
				pen.SetColor(TColor::WHITE);
				break;
		}
		pen.FillRectangle(i*32,0,32,32);
	}
	
	pen.SetColorMode(TColor::DITHER);
	for(int i=0; i<256; i+=4) {
		pen.SetColor(i,0,0);
		pen.FillRectangle(i,32,4,32);
	}
}