/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for X-Windows
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <toad/toad.hh>
#include <toad/form.hh>
#include <toad/menubar.hh>
#include <toad/pushbutton.hh>

#include "htmlview.hh"
#include "state.hh"

class TMainWindow:
	public TForm
{
	public:
		TMainWindow(TWindow*,const string&);
};

string startfile;

extern void CreateMemoryFiles();

int ToadMain()
{
	CreateMemoryFiles();

	TState::font_normal = new TFont(TFont::SERIF, TFont::PLAIN, 12);
	TState::font_h1     = new TFont(TFont::SANS, TFont::BOLD, 16);
	TState::font_h2     = new TFont(TFont::SANS, TFont::BOLD, 14);
	TState::font_h3     = new TFont(TFont::SANS, TFont::BOLD, 12);
	TState::font_tt			= new TFont(TFont::TYPEWRITER, TFont::PLAIN, 12);

	startfile = "index.html";
	if (TOADBase::argc==2)
		startfile = TOADBase::argv[1];
	
	TMainWindow html(NULL, "Nefilim 0.1");
	html.Run();
	
	delete TState::font_normal;
	delete TState::font_h1;
	delete TState::font_h2;
	delete TState::font_h3;
	delete TState::font_tt;
	
	return 0;
}

TMainWindow::TMainWindow(TWindow *p,const string &t):
	TForm(p,t)
{
	SetSize(500,500);
	SetBackground(192,192,192);
	TMenuBar *mb = new TMenuBar(this, "menubar");
	THTMLView *hv = new THTMLView(this, "htmlview");
	TPushButton *btn[2];
	btn[0] = new TPushButton(this, "<");
	btn[0]->SetSize(36,36);
	btn[0]->LoadBitmap("memory://backward.png");
	CONNECT(btn[0]->sigActivate, hv, Back);
	btn[1] = new TPushButton(this, ">");
	btn[1]->SetSize(36,36);
	btn[1]->LoadBitmap("memory://forward.png");
	CONNECT(btn[1]->sigActivate, hv, Forward);
	Distance(btn[0],3);
	Distance(btn[1],3);
	hv->Open(startfile);
	
	Attach(mb, TOP | LEFT | RIGHT);
	Attach(btn[0], TOP, mb);
	Attach(btn[0], LEFT);
	Attach(btn[1], TOP, mb);
	Attach(btn[1], LEFT, btn[0]);
	Attach(hv, TOP, btn[0]);
	Attach(hv, LEFT | RIGHT | BOTTOM);

	TMenuItem *mi;
	mb->BgnPulldown("File");
		mi = mb->AddItem("Open..");
		mi = mb->AddItem("Quit");
		CONNECT(mi->sigActivate, this, closeRequest);
	mb->EndPulldown();
	
	mb->BgnPulldown("Go");
		mi = mb->AddItem("Back");
		CONNECT(mi->sigActivate, hv, Back);
		mi = mb->AddItem("Forward");
		CONNECT(mi->sigActivate, hv, Forward);
		mi = mb->AddItem("Home");
	mb->EndPulldown();
}
