/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for X-Windows
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/toad.hh>
#include <toad/dialog.hh>
#include <toad/pushbutton.hh>

class TMyWindow:
	public TWindow
{
	public:
		TMyWindow(TWindow *p, const string &t);
};


int ToadMain()
{
  return TMyWindow(NULL, "Cursor Demo").Run();
}

TMyWindow::TMyWindow(TWindow *p, const string &t):
	TWindow(p,t)
{
	TWindow *wnd;
	SetBackground(TColor::LIGHTGRAY);
	
	wnd = new TWindow(this,"");
		wnd->SetCursor(TCursor::DEFAULT);
		wnd->SetShape(5,5,15,15);

	wnd = new TWindow(this,"");
		wnd->SetCursor(TCursor::CROSSHAIR);
		wnd->SetShape(25,5,15,15);

	wnd = new TWindow(this,"");
		wnd->SetCursor(TCursor::HAND);
		wnd->SetShape(45,5,15,15);

	wnd = new TWindow(this,"");
		wnd->SetCursor(TCursor::TEXT);
		wnd->SetShape(65,5,15,15);

	wnd = new TWindow(this,"");
		wnd->SetCursor(TCursor::WAIT);
		wnd->SetShape(85,5,15,15);

	wnd = new TWindow(this,"");
		wnd->SetCursor(TCursor::MOVE);
		wnd->SetShape(105,5,15,15);


	wnd = new TWindow(this,"");
		wnd->SetCursor(TCursor::N_RESIZE);
		wnd->SetShape(5,25,15,15);

	wnd = new TWindow(this,"");
		wnd->SetCursor(TCursor::NE_RESIZE);
		wnd->SetShape(25,25,15,15);

	wnd = new TWindow(this,"");
		wnd->SetCursor(TCursor::NW_RESIZE);
		wnd->SetShape(45,25,15,15);

	wnd = new TWindow(this,"");
		wnd->SetCursor(TCursor::S_RESIZE);
		wnd->SetShape(65,25,15,15);

	wnd = new TWindow(this,"");
		wnd->SetCursor(TCursor::SE_RESIZE);
		wnd->SetShape(85,25,15,15);

	wnd = new TWindow(this,"");
		wnd->SetCursor(TCursor::SW_RESIZE);
		wnd->SetShape(105,25,15,15);


	wnd = new TWindow(this,"");
		wnd->SetCursor(TCursor::W_RESIZE);
		wnd->SetShape(5,45,15,15);

	wnd = new TWindow(this,"");
		wnd->SetCursor(TCursor::E_RESIZE);
		wnd->SetShape(25,45,15,15);

	wnd = new TWindow(this,"");
		wnd->SetCursor(TCursor::QUESTION);
		wnd->SetShape(45,45,15,15);

	wnd = new TWindow(this,"");
		wnd->SetCursor(TCursor::EXCHANGE);
		wnd->SetShape(65,45,15,15);

	wnd = new TWindow(this,"");
		wnd->SetCursor(TCursor::RESIZE);
		wnd->SetShape(85,45,15,15);

	wnd = new TWindow(this,"");
		wnd->SetCursor(TCursor::PIRATE);
		wnd->SetShape(105,45,15,15);


	wnd = new TWindow(this,"MOUSE");
		wnd->SetCursor(TCursor::MOUSE);
		wnd->SetShape(5,65,15,15);

	wnd = new TWindow(this,"PENCIL");
		wnd->SetCursor(TCursor::PENCIL);
		wnd->SetShape(25,65,15,15);

	wnd = new TWindow(this,"SPRAY");
		wnd->SetCursor(TCursor::SPRAY);
		wnd->SetShape(45,65,15,15);

	wnd = new TWindow(this,"HORIZONTAL");
		wnd->SetCursor(TCursor::HORIZONTAL);
		wnd->SetShape(65,65,15,15);

	wnd = new TWindow(this,"VERTICAL");
		wnd->SetCursor(TCursor::VERTICAL);
		wnd->SetShape(85,65,15,15);

	wnd = new TWindow(this,"TARGET");
		wnd->SetCursor(TCursor::TARGET);
		wnd->SetShape(105,65,15,15);


	wnd = new TWindow(this,"");
		wnd->SetCursor(TCursor::DOT);
		wnd->SetShape(5,85,15,15);

	wnd = new TWindow(this,"");
		wnd->SetCursor(TCursor::CIRCLE);
		wnd->SetShape(25,85,15,15);


}

