/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <cstring>

#define _TOAD_PRIVATE

#include <toad/toadbase.hh>
#include <toad/pen.hh>
#include <iostream.h>

//!TColor
//. Contains TOADs color management. See 
//. <A HREF="TPen.html">TPen.SetColor(red,green,blue)</A> how to
//. use colors.

TColor sysrgb[TColor::MAX]=
{
	TColor(  0,  0,  0),	// BTNTEXT
	TColor(128,128,128),	// BTNSHADOW
	TColor(192,192,192),	// BTNFACE
	TColor(255,255,255),	// BTNLIGHT
	TColor(192,192,192),	// MENU
	TColor(  0,  0,  0),	// MENUTEXT
	TColor(255,255,255),	// TEXTEDIT
	TColor(128,  0,  0),	// MDIAREA
	TColor(  0,  0,128),	// CAPTION
	TColor(255,255,255),	// CAPTIONTEXT
	TColor(192,192,192),	// INACTIVECAPTION
	TColor(  0,  0,  0),	// INACTIVECAPTIONTEXT
	TColor(192,192,192),	// DIALOG
	TColor(  0,  0,  0),	// DIALOGTEXT
	TColor(127,127,191),	// SLIDER_FACE
	TColor( 63, 63,127),	// SLIDER_SHADOW
	TColor(191,191,255),	// SLIDER_LIGHT
	TColor(127,127,191),	// SELECTED
	TColor(  0,  0,  0),	// SELECTED_TEXT
};

TColor::TColor()
{
	_Init();
	r = g = b = 0;
}

TColor::TColor(byte rn, byte gn, byte bn)
{
	_Init();
	r = rn; g = gn; b = bn;
}

TColor::TColor(TColor::EColor16 c16)
{
	_Init();
	const TColor &c = _Palette(c16);
	r = c.r; g = c.g; b = c.b;
}

TColor::TColor(ESystemColor sc)
{
	_Init();
	const TColor &c = sysrgb[sc];
	r = c.r; g = c.g; b = c.b;
}

void TColor::_Init()
{
}

TColor::~TColor()
{
}

void TColor::Set(TColor::EColor16 c16)
{
	const TColor &c = _Palette(c16);
	r = c.r; g = c.g; b = c.b;
	_data = NULL;
}

void TColor::Set(ESystemColor sc)
{
	const TColor &c = sysrgb[sc];
	r = c.r; g = c.g; b = c.b;
	_data = NULL;
}
