/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TFont
#define TFont TFont

#include <toad/toadbase.hh>

class TPen;

class TFont: public TOADBase
{
	friend TPen;
	
	public:
		enum EFamily
		{
			SANS=0, SANSSERIF=0,
			SERIF=1, 
			TYPEWRITER=3
		};
	    enum EStyle
	    {
			PLAIN = 0, 
			REGULAR = 0,
			BOLD = 1,
			ITALIC = 2,
			BOLD_ITALIC = 3,
			OBLIQUE = 4,
			BOLD_OBLIQUE = 5
	    };
		TFont();
		TFont(EFamily,EStyle,int);
		TFont(const string &family, EStyle, int);
		void SetFont(EFamily,EStyle,int);
		void SetFont(const string& family, EStyle, int);
		virtual ~TFont();

		int TextWidth(const string&) const;
		int TextWidth(const char*) const;
		int TextWidth(const char*,int len) const;
		int TextWidth(const unsigned char *s) const {return TextWidth((const char*)s);}
		int TextWidth(const unsigned char *s,int len) const {return TextWidth((const char*)s,len);}
		int Ascent() const;
		int Descent() const;
		int Height() const;
		unsigned GetHeightOfTextFromWidth(const string &text, unsigned width) const;
		unsigned GetHeightOfTextFromWidth(const char* text, unsigned width) const;

		#ifdef _TOAD_PRIVATE
			XFontStruct *fs;
		private:
		#else
		private:
			void *fs;
		#endif
		string mask;
		void build_fontname(EFamily family, EStyle style,int size);

		struct TWord
		{
		  const char* pos;
	    unsigned bytes;
      unsigned len;
      unsigned linefeeds;
		};
		void count_words_and_lines(const char*, unsigned*, unsigned*) const;
		TWord* make_wordlist(const char*,unsigned) const;
};

#endif
