/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

/*
 *
 *   FYI: THE TMENUBAR CLASS WILL BE REWRITTEN IN THE FUTURE
 *
 */

#ifndef TMenuBar
#define TMenuBar TMenuBar

#ifndef TRowColumn
#include <toad/rowcolumn.hh>
#endif

#ifndef TControl
#include <toad/control.hh>
#endif

#define TMenuRadio TMenuItem

class TMenuBar;
class TPulldown;

class TSimpleButton: public TControl
{
		typedef TWindow super;
		
	public:
		TSimpleButton(TWindow*, const string&);

		TSignal sigActivate;

	protected:
		void adjust();
		void paint();
		TMenuBar* menubar();

		bool bDown;		// true when button is down
//		int id;				// id (used, when no child exists)
		int text_y;		// vertical position of the button text
};

class TMenuButton: public TSimpleButton
{
	public:
		TMenuButton(TWindow* parent, const string &title)
			:TSimpleButton(parent, title){};
		void Deactivate();

	private:
		void mouseLDown(int,int,unsigned);
		void mouseLUp(int,int,unsigned);
		void mouseEnter(int,int,unsigned);
};

class TMenuItem: public TSimpleButton
{
		typedef TSimpleButton super;

	public:
		TMenuItem(TWindow* parent, const string &title)
			:super(parent, title){};
		
		void Activate();
		void Deactivate();

	private:
		TPulldown *pulldown();
		
		void adjust();
		void paint();
		void mouseLDown(int,int,unsigned);
		void mouseLUp(int,int,unsigned);
		void mouseEnter(int,int,unsigned);
		void mouseLeave(int,int,unsigned);
};

class TMenuCheck: public TMenuItem
{
		typedef TMenuItem super;

	public:
		TMenuCheck(TWindow* parent, const string &title);

	protected:
		void paint();
		void mouseLUp(int,int,unsigned);

	private:
		bool bChecked;	
};

class TMenuBar: public TRowColumn
{
		typedef TRowColumn super;

	public:
		// real public stuff
		TMenuBar(TWindow*, const string& title="menubar");

		void BgnPulldown(const string& title);
		void EndPulldown();
		TMenuItem* AddItem(const string &title);
		TMenuCheck* AddCheck(const string &title,bool set=false);
		TMenuRadio* AddRadio(const string &title, int grp, int value, bool set=false);

		TSignal sigActivate;

		// none public stuff
		void SetActive(TMenuButton*);
		bool IsActive();

		void GetFocus();
		void DropFocus();
		
		void menuSelect();
	private:
		// void keyDown(TKey key, char *string, unsigned modifier);

		void mouseLDown(int x,int y,unsigned modifier);
		void mouseLUp(int x,int y,unsigned modifier);
		void closeRequest();
		
		struct TPulldownNode;
		TPulldownNode *pulldown_stack;

	public:
		bool bHaveFocus:1;
		bool bCloseAll:1;
		bool bLBDown:1;
		TMenuButton *active_button;
};

inline bool TMenuBar::IsActive(){return active_button!=NULL;}

#endif
