 /*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/debug.hh>

#ifdef DEBUG_MEMORY

/*
 *  This stuff is a merger of glibc 2.1 `malloc/malloc.c' and gcc 2.95
 * `gcc/cp/new1.cc', `gcc/cp/new2.cc' to produce meaningful output for
 * the `mtrace' tool with c++.
 *
 *  Since `new' and `delete' are declare `weak', just to have these
 * methods in the toad library will override 'em.
 *
 *  To use it define the MALLOC_CHECK_ environment variable with
 *    0: any detected heap corruption is silently ignored
 *    1: a diagnostic is printed on `stderr'
 *    2: `abort' is called immediately
 */

#define MALLOC_HOOKS

#include <new>
#include <stdio.h>
#include <malloc.h>
#include <set>

extern new_handler __new_handler;

typedef set<void*> t_memory_set;
static t_memory_set memory_set;

void toad_memory_check()
{
	/* set your breakpoint here */
}

static void* toad_malloc(size_t sz)
{
	if (__malloc_hook==NULL)
		return malloc(sz);
	
	void *p;
	if (sz==0)
		sz=1;
	p = (void *) (*__malloc_hook)(sz, __builtin_return_address(1));
	while(p==0) {
		new_handler handler = __new_handler;
		if (!handler)
			 throw bad_alloc();
		handler();
		p = (void *) (*__malloc_hook)(sz, __builtin_return_address(1));
	}
	memory_set.insert(p);
	return p;
}

static void toad_free(void *ptr)
{
	if (ptr==0) {
		printf("toad_memory_check: free/delete NULL\n");
		toad_memory_check();
		return;
	}
	if (__free_hook==NULL)
		return free(ptr);
	t_memory_set::iterator p = memory_set.find(ptr);
	if (p==memory_set.end()) {
		printf("toad_memory_check: free/delete illegal address\n");
		toad_memory_check();
		return;
	}
	memory_set.erase(p);
	(*__free_hook)(ptr, __builtin_return_address(1));
}

void* operator new(size_t sz) throw (std::bad_alloc)
{
	return toad_malloc(sz);
}

void* operator new[] (size_t sz) throw (std::bad_alloc)
{
	return toad_malloc(sz);
}

void operator delete (void *ptr) throw ()
{
	return toad_free(ptr);
}

void operator delete[] (void *ptr) throw ()
{
	return toad_free(ptr);
}

#endif
