/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-98 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef GSmartPointer
#define GSmartPointer GSmartPointer

/*
	ATTENTION CORBA HACKERS:

	As far as I remember CORBA code like

			Object *p = new Object();
			Object_var v1 = p;
			Object_var v2 = p;

	will cause a segmentation fault since the reference counter isn't
	incremented by `ObjVar<T>& ObjVar::operator=( T* ptr )'.
	But TOADs `GSmartPointer<T>& GSmartPointer::operator =(T *p)' will
	increment it so code like

			TObject *p = new TObject();
			PObject v1 = p;
			PObject v2 = p;

  will destroy the object when BOTH PPointer objects get destroyed or
  loose their reference on the object. [MAH]
*/

#include <iostream>

#ifdef NULL
#  undef NULL
#endif

#define NULL (0)

class TSmartObject
{
	public:
		TSmartObject() {
			_toad_ref_cntr = 0;
		}
		
		virtual ~TSmartObject() {
			if (_toad_ref_cntr!=0) {
				cerr << "warning: object with pending references destroyed" << endl;
				// Another idea would be to find all associated smart pointers
				// and set 'em to NULL or to throw an exception
			}
		}
//	private:
		unsigned _toad_ref_cntr;
};

extern bool _smart_bable;

template <class T>
class GSmartPointer
{

	public:
		GSmartPointer() {
			_ptr = NULL;
		}

		GSmartPointer(T* p) {
			_ptr = NULL;
			_Set(p);
		}

		GSmartPointer(const GSmartPointer<T>& p) {
			_ptr = NULL;
			_Set(p._ptr);
		}

		template <class T2>
		GSmartPointer(const GSmartPointer<T2>& p) {
			_ptr = NULL;
			_Set(p._ptr);
		}

		~GSmartPointer() {
			_Set(NULL);
		}
		
		GSmartPointer<T>& operator =(T *p) {
			_Set(p);
			return *this;
		}

		GSmartPointer<T>& operator =(const GSmartPointer<T>& p) {
			_Set(p._ptr);
			return *this;
		}

		T* operator->() const {
			return _ptr;
		}
		
		operator T*() const {
			return _ptr;
		}

#if 0
		operator void*() const {
			return _ptr;
		}
		
		operator bool() const {
			return _ptr;
		}
#endif

//	private:		
		T* _ptr;
		void _Set(T *p) {
			if (_ptr==p)
				return;
			if (_ptr) {
				_ptr->_toad_ref_cntr--;
				if (_ptr->_toad_ref_cntr==0)
					delete _ptr;
			}
			_ptr = p;
			if (_ptr)
				_ptr->_toad_ref_cntr++;
		}
};

#endif
