/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996,97 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TRegion
#define TRegion TRegion

#ifndef _TOAD_PRIVATE
typedef struct _XRegion *Region;
#endif

class TRegion
{
	public:
		TRegion();
		~TRegion();
		void AddRect(const TRectangle&);
		void AddRect(int x,int y,int w,int h);
		void operator&=(const TRegion&);	// union
		void operator|=(const TRegion&);	// intersect
		void operator-=(const TRegion&);	// subtract
		void operator^=(const TRegion&);	// xor
		void operator&=(const TRectangle&);		// union
		void operator|=(const TRectangle&);		// intersect
		void operator-=(const TRectangle&);		// subtract
		void operator^=(const TRectangle&);		// xor
		void Translate(int dx,int dy);
		void Clear();
		void GetBoundary(TRectangle*);			// GetExtents
		void GetClipBox(TRectangle *r){GetBoundary(r);}
		long GetNumRects();
		bool GetRect(long,TRectangle*);
	public:
		Region x11region;
};

#endif
