/****************************************************************************/
/*   xmCi2.C                                                                */
/****************************************************************************/
/*                                                                          */
/*   Copyright (c) 1992, 1993, 1994 Bernhard Strassl                        */
/*       Vienna User Interface Group                                        */
/*       Institute for Applied Computer Science and Information Systems     */
/*       University of Vienna, Austria                                      */
/*                                                                          */
/*   See file COPYRIGHT in this directory for details. If this file is      */
/*   missing please mail to xmplus@ani.univie.ac.at                         */
/****************************************************************************/

#include "xmCi2.h"
#include <stream.h>

bool ciCallbackList::remove(ciCallbackInfo* inf)
{
	ciCallbackInfo* cbk = NULL;

	for(int i = 0; i < count; i++)
	{	if(list[i]->eq(inf))
		{	cbk = list[i];
			count--;
			break;
		}
	}
	if(cbk)
	{	delete cbk;
		for(int j = i; j < count; j++)
			list[j] = list[j + 1];
	}
	delete inf;
	return(FALSE);
}
	

CiObject::CiObject(DrawPrim* p, char* n, ciAttrib a) : DrawPrim(p->data)
{
        maxPrimPts = p->maxpoints();
	relCoord = p->origin();
	p->data = NULL;
	delete p;
	initObject(n, a);
}

CiObject::CiObject(XmControl*, char*, ciAttrib) : DrawPrim((gprData* )NULL)
{
	cerr << "ciObject: sorry, controls not supported in this release.\n";
}

CiObject::~CiObject()
{
// cerr << "ciObj " << instName << " destr...";
//	long rc;
	if(parent)
		/*rc = (long )*/ parent->removeChild(this);
	else if(world)
		/*rc = (long )*/ world->removeChild(this);
// cerr << " returned: " << rc << " children: " << numChildren << "\n";

	for(int i = 0; i < numChildren; i++)
		delete children[i];
	delete instName;
}

void CiObject::initObject(char* aName, ciAttrib a)
{
	basePtr = (XmRootClass* )((void* )this);	// needed only by IBM's xlC...
	world = NULL;
	parent = NULL;
	numChildren = 0;
	objData = NULL;
	instName = strcpy(new char[strlen(aName) + 1], aName);
	attributes = a;
	reAssigned = NULL;
	moved = resized = FALSE;
	methodCount = 0;
	for(int i = 0; i < CI_NUM_INTERACTION_PRIMITIVES; i++)
		preOpCallbacks[i] = postOpCallbacks[i] = NULL;
}

char* ciPrimNames[] = { "Mark", "Move", "Assign", "Resize", "Select",
						"Activate", "ChangeContents", "ChangeData" };

bool CiObject::callCallback(ciPrim p, bool pop, int nx, int ny, CiObject* anObj, int op, int nx1, int ny1, int caller)
{
	bool reply = TRUE;
#ifdef NO_PROC_UEXPR
	ciCallbackList* cbks;

	if(pop)
		cbks = preOpCallbacks[p];
	else
		cbks = postOpCallbacks[p];
#else
	ciCallbackList* cbks = (pop ? preOpCallbacks : postOpCallbacks)[p];
#endif
// cerr << "callCallback [" << pop << "] " << instName << " - " << ciPrimNames[p] << cbks <<
//         " (" << preOpCallbacks[p] << ", " << postOpCallbacks[p] << ")...\n";
	ciCallbackInfo* cbk;
	void* clData, * answer = NULL;
	int i = 0;
	while(cbks && (cbk = cbks->next(i)))
	{
//cerr << "\n" << ciPrimNames[p] << "(" << caller << ", " << pop << "-" << getName() << " checking " << cbk << ")";
		if(!(cbk->when & caller))
			continue;
		if(p == Mark && op == OP_OFF && cbk->clientData != CB_CI_DATA)
			continue;
		if(!cbk->receiver || !validProc(cbk->callback))
		{	cerr << "ciObject: error - invalid callback info.\n";
			return(FALSE);
		}
		if(cbk->clientData == CB_OBJ_NAME)
			answer = instName;
		else if(cbk->clientData == CB_CLASS_NAME)
			answer = className();
		else if(cbk->clientData == CB_OBJ_PTR)
			answer = this;
		else if(cbk->clientData > CB_CLASS_NAME)
			answer = cbk->clientData;
		clData = answer;
		if(pop || cbk->clientData == CB_CI_DATA)
			clData = new ciClientData(p, reply, answer ? answer : this, nx, ny, anObj ? anObj : this, op, nx1, ny1);
// cerr << "\n:";
		((cbk->receiver)->*(cbk->callback))(clData);
		if(pop || cbk->clientData == CB_CI_DATA)
			delete (ciClientData* )clData;
	}
// cerr << "\n";
	return(reply);
}

void CiObject::changeAssignInfo(bool sr, int kind, char* name)
{
	char** names = assigninf.names[kind];
	int curNum = assigninf.nums[kind];

	for(int i = 0; i < curNum; i++)
	{	if(!strcmp(names[i], name))
		{	curNum = i;
			break;
		}
	}

	if(sr)	//add
	{	if(curNum == assigninf.nums[kind])
		{	if(assigninf.nums[kind] < CI_MAX_ASSIGNINFO_NAMES)
				names[assigninf.nums[kind]++] = strcpy(new char[strlen(name) + 1], name);
		}
	}
	else	// remove
	{	for(int j = curNum; j < assigninf.nums[kind] - 1; j++)
				names[j] = names[j + 1];
	}
}

bool parseWildcards(char* cmp, char* aName)
{
	while(*cmp && *aName)
	{	if(*cmp == *aName || *cmp == '?')
		{	cmp++;
			aName++;
			continue;
		}
		else if(*cmp == '*')
		{	if(!cmp[1])
				return(TRUE);
			if(parseWildcards(cmp + 1, aName))
				return(TRUE);
			else
				aName++;
			continue;
		}
		return(FALSE);
	}
	return(!*cmp && !*aName ? TRUE : FALSE);
}

bool CiObject::matchAssignInfo(int kind, char* aName)
{
	char** names = assigninf.names[kind];
// cerr << "matching: " << kind << " - " << className() << " / " << instName << " for: " << aName;
	for(int i = 0; i < assigninf.nums[kind]; i++)
	{	// cerr << " (" << assigninf.names[kind][i] << "==" << aName << ") ";
		if(parseWildcards(assigninf.names[kind][i], aName))
		{	// cerr << " -> TRUE\n";
			return(TRUE);
		}
	}
	// cerr << " -> FALSE\n";
	return(FALSE);
}

CiObject* CiObject::addChild(CiObject* anObj, bool showIt, bool notify)
{
	int x = showIt ? anObj->relCoord.x : anObj->relOrigin().x;
	int y = showIt ? anObj->relCoord.y : anObj->relOrigin().y;

	if(numChildren < CI_MAX_CHILDREN)
	{	children[numChildren++] = anObj;
		anObj->parent = this;
		if(showIt)
		{	makeAbsolute(x, y);
			anObj->setOrigin(x, y);
			if(getWorld() && !anObj->world)		// after parent set getWorld() searches upwards...
				anObj->addTreeTo(getWorld());
		}
		if(notify)
			callCallback(ChangeContents, FALSE, anObj->relOrigin().x, anObj->relOrigin().y, anObj, OP_ADD, 0, 0, USER | APP);
		return(anObj);
	}
	cerr << "ciObject - error: Maximum number of children exceeded.\n";
	return(NULL);
}

CiObject* CiObject::removeChild(CiObject* anObj, bool hideIt, bool notify)
{
// cerr << instName << " removing " << anObj->getName() << " ";
	for(int i = 0; i < numChildren; i++)
	{	if(children[i] == anObj)
		{	numChildren--;
			for(int j = i; j < numChildren; j++)
				children[j] = children[j + 1];
			anObj->parent = NULL;
			if(hideIt)
				anObj->removeTreeFrom(getWorld());
// cerr << "ok\n";
			if(notify)
				callCallback(ChangeContents, FALSE, anObj->relOrigin().x, anObj->relOrigin().y, anObj, OP_REMOVE, 0, 0, USER | APP);
			return(anObj);
		}
	}
// cerr << "failed!\n";
	return(NULL);
}

CiObject** CiObject::getChildren(int code, ciState st, char* icName, CiObject** all, int* count)
{
	int localNdx = 0, & ndx = count ? *count : localNdx;

	if(!all)
		all = new CiObject*[CI_MAX_TREE_SIZE];
	for(int i = 0; i < numChildren; i++)
	{	CiObject* aChild = child(i);
		if((st == -1 || aChild->getState(st)) && (!icName || parseWildcards(icName, aChild->className()) || parseWildcards(icName, aChild->getName())))
			all[ndx++] = aChild;
		if(code == CH_ALL || (code == CH_SHALLOW && !aChild->getState(st)))
			aChild->getChildren(code, st, icName, all, &ndx);
	}
	all[ndx] = NULL;
	return(all);
}

CiObject* CiObject::linkTo(CiObject* anObj)				{ return(anObj->addChild(this)); }
CiObject* CiObject::linkTo(XmCiWorld* aWorld)			{ return(aWorld->addChild(this)); }
CiObject* CiObject::unlink()
{
// cerr << "ciObj " << instName << " unlink...";
//	long rc;
	if(parent)
		/* rc = (long ) */ parent->removeChild(this, TRUE);
	else if(world)
		/* rc = (long ) */ world->removeChild(this);
// cerr << " returned: " << rc << " children: " << numChildren << "\n";
	return(this);
}

// { return(parent ? parent->removeChild(this) : (world ? world->removeChild(this) : NULL)); }

bool CiObject::setAttributes(ciAttrib a, bool sr)
{
	if(sr)
		attributes |= a;
	else
		attributes ^= a;

	if(disp)
		changeFlags(a, sr);
	return(TRUE);
}

bool CiObject::setCallback(ciPrim i, XmRootClass* o, cbProc p, bool sr, bool pop, void* d, int when)
{
	if(i < CI_NUM_INTERACTION_PRIMITIVES)
	{	ciCallbackList** cbks = (pop ? preOpCallbacks : postOpCallbacks) + i;
		if(!*cbks)
			*cbks = new ciCallbackList;
		ciCallbackInfo* inf = new ciCallbackInfo(o, p, d, when);
// cerr << getName() << " " << (sr ? "added " : "removed ") << ciPrimNames[i] << " ci: " << inf << " for : "
// << inf->receiver << "/" << inf->when << "...\n";
		return(sr ? (*cbks)->add(inf) : (*cbks)->remove(inf));
	}
	cerr << "ciObject - error: Invalid interaction primitive for callback.\n";
	return(FALSE);
}

bool CiObject::disable()	{ return(FALSE); }
bool CiObject::enable()		{ return(FALSE); }

//callCallback(prim, pop, nx, int ny, anObj, op, nx1, ny1, caller)

bool CiObject::objMark(bool on, int cx, int cy, bool notify, bool byUser, bool pop, bool repaint)
{
	if(byUser)
	{	makeRelative(cx, cy);
		if(callCallback(Mark, pop, cx, cy, NULL, on ? OP_ON : OP_OFF))
		{	if(pop)
				markChildren(on);
			return(TRUE);
		}
		return(FALSE);
	}
	if(on)
	{	if(disp)
			disp->select(this, TRUE, FALSE);
		else
			state |= MARKED;
	}
	else
	{	if(disp)
			disp->deSelect(this, FALSE);
		else
			state ^= MARKED;
	}
	markChildren(on);
	if(disp && repaint)
		disp->refresh();
	if(byUser || notify)
		callCallback(Mark, FALSE, 0, 0, NULL, on, 0, 0, APP);
	return(TRUE);
}

bool CiObject::objAssign(CiObject* rec, int x, int y, bool notify, bool byUser, bool pop, bool repaint)
{
	if(byUser)	// by end user interaction...
	{	if(pop)
		{	if(rec == parent && callCallback(Move, pop, x, y, rec))
				return(moved = TRUE);
			else if((callCallback(Assign, pop, x, y, rec) && 
					(parent ? parent->callCallback(ChangeContents, pop, x, y, this, OP_REMOVE) : TRUE) &&
					(rec ? rec->callCallback(ChangeContents, pop, x, y, this, OP_ADD) : TRUE)))
			{	reAssigned = parent ? parent : (CiObject* )TRUE;
				return(TRUE);
			}
			return(FALSE);
		}
	}
	else 		// by programmer...
	{	gprPoint delta = origin();
		if(rec)
			rec->makeAbsolute(x, y);
		setOrigin(x, y);
		update();
		delta.x = x - delta.x;
		delta.y = y - delta.y;
		relocateChildren(delta.x, delta.y);
	}
	if(rec != parent)
	{	if(parent)
			parent->removeChild(this, FALSE, notify);	// calls postop changeContents...
		if(rec)
			rec->addChild(this, FALSE, notify);			// calls postop changeContents...
	}
	if(byUser || notify)
	{	callCallback(rec != parent || reAssigned ? Assign : Move, FALSE, x, y, rec, 0, 0, 0, byUser ? USER : APP);
		CiObject** ch = getChildren(CH_ALL);
		for(int i = 0; ch[i]; i++)
			ch[i]->callCallback(Move, FALSE, 0, 0, NULL, 0, 0, 0, (byUser ? USER : APP) | PARENT);
	}
	if(disp && repaint)
		disp->refresh();
	return(TRUE);
}

bool CiObject::objResize(int w, int h, bool originChanged, int x, int y, bool notify, bool byUser, bool pop, bool repaint)
{
	int op = pop ? (originChanged ? OP_MOVE_DURING_RESIZE : 0) : (moved ? OP_MOVE_DURING_RESIZE : 0);

	if(byUser)
	{	if(pop)
		{	if(resized = callCallback(Resize, pop, w, h, NULL, op, x, y, byUser ? USER : APP))
				moved = originChanged;
			return(resized);
		}
	}
	else
	{	setExtent(w, h);
		update();
	}
	if(byUser || notify)
		callCallback(Resize, FALSE, extent().x, extent().y, NULL, op, origin().x, origin().y);
	if(disp && repaint)
		disp->refresh();
	return(TRUE);
}

void CiObject::objSelect(int x, int y, bool on)
{
	callCallback(Select, FALSE, x, y, NULL, on ? OP_ON : OP_OFF);
}

void CiObject::objActivate()
{
	callCallback(Activate, FALSE);
}

bool CiObject::objChangeData(void*, bool, bool, bool)
{
	return(FALSE);
}

void CiObject::addTreeTo(XmCiWorld* w)
{
	world = w;
	w->setDefaultFlags(attributes);
	w->add(this);
	for(int i = 0; i < numChildren; i++)
		children[i]->addTreeTo(w);
}

void CiObject::removeTreeFrom(XmCiWorld* w)
{
	world = NULL;
	w->remove(this);
	for(int i = 0; i < numChildren; i++)
		children[i]->removeTreeFrom(w);
}

void CiObject::markChildren(bool onOrOff)
{
// cerr << "marking " << numChildren << "\n";
	for(int i = 0; i < numChildren; i++)
	{	children[i]->objMark(onOrOff, 0, 0, FALSE, FALSE, FALSE, FALSE);
		disp->makeSelDepend(children[i], this);
	}
}

void CiObject::relocateChildren(int dx, int dy)
{
	for(int i = 0; i < numChildren; i++)
	{	CiObject* aChild = children[i];
		gprPoint p = aChild->origin();
		aChild->setOrigin(p.x + dx, p.y + dy);
		aChild->update();
		aChild->relocateChildren(dx, dy);
	}
}

void CiObject::restackChild(CiObject* obj, bool dir)
{
	for(int i = 0; i < numChildren; i++)
	{	CiObject* aChild;
		if((aChild = children[i]) == obj)
		{	if(dir)
			{	for(int j = i; j > 0; j--)
					children[j] = children[j - 1];
				children[0] = aChild;
			}
			else
			{	for(int j = i; j < numChildren - 1; j++)
					children[j] = children[j + 1];
				children[numChildren - 1] = aChild;
			}
			break;
		}
	}
}

void CiObject::restackChild(CiObject* obj, int ndx)
{
	if(ndx >= 0 && ndx < numChildren)
	{	for(int i = 0; i < numChildren; i++)
		{	if(children[i] == obj)
			{	if(ndx < i)
				{	for(int j = i; j > ndx; j--)
						children[j] = children[j - 1];
				}
				else if(ndx > i)
				{	for(int j = i; j < ndx; j++)
						children[j] = children[j + 1];
				}
				children[ndx] = obj;
				break;
			}
		}
	}
}

CiObject* CiObject::getMarkedRoot()
{
	if(!parent)
	{	if(!getState(MARKED))
			cerr << "ciObject: Internal Error - (" << this << "/" << instName << ") getMarkedRoot\n";
		return(this);
	}
	if(!getState(MARKED))
	{	cerr << "ciObject: Warning - cannot answer marked root (this not marked).\n";
		return(NULL);
	}
	if(parent->getState(MARKED))
		return(parent->getMarkedRoot());
	return(this);
}

bool CiObject::registerMethod(char* msg, cbProc cbk, char* pt)
{
	int newndx = findMethod(msg, pt);

	if(newndx >= 0)
	{	delete protocol[newndx];
		if(!validProc(cbk))
		{	methodCount--;
			for(int i = newndx; i < methodCount; i++)
				protocol[i] = protocol[i + 1];
			return(TRUE);
		}
	}
	else
	{	if(methodCount >= CI_MAX_METHODS)
		{	cerr << "ciObject: maximum number of methods exceeded, ignoring \"" << msg << "\"\n";
			return(FALSE);
		}
		newndx = methodCount++;
	}
	protocol[newndx] = new ciMethod(msg, pt, cbk);
// cerr << "registered " << msg << " as " << newndx << "\n";
	return(TRUE);
}

int CiObject::findMethod(char* n, char* t)
{
	for(int i = 0; i < methodCount; i++)
	{	if(protocol[i]->match(n, t))
			return(i);
	}
	return(-1);
}

bool CiObject::msg(char* msg, char* pt, void* param)
{
	int callndx = findMethod(msg, pt);

	if(callndx >= 0)
	{	
// cerr << "calling " << msg << " as " << callndx << "\n";
		(this->*(protocol[callndx]->callback))(param);
		return(TRUE);
	}
	return(FALSE);
}

gprPoint CiObject::calcRel(gprPoint p)
{
	if(parent)
	{	int x = p.x;
		int y = p.y;
// cerr << "calcrel - " << x << "@" << y << "/";
		parent->makeRelative(x, y);
		p.x = x;
		p.y = y;
// cerr << p.x << "@" << p.y << "\n";
	}
	return(p);
}

void CiObject::notifyChanges(ciPrim p)
{
	callCallback(p, FALSE, 0, 0, NULL, 0, 0, 0, APP);
}


XmCiWorld* CiObject::getWorld()
{
	if(world)
		return(world);
	return(parent ? parent->getWorld() : NULL);
}

bool CiObject::getState(ciState s)
{
	if(disp)
		return(disp->getStatus(this, s));
	return(state & s ? TRUE : FALSE);
}

void CiObject::makeRelative(int& x, int& y)
{
	gprPoint loc = origin();

	x -= loc.x;
	y -= loc.y;
}

void CiObject::makeAbsolute(int& x, int& y)
{
	gprPoint loc = origin();

	x += loc.x;
	y += loc.y;
}

void CiObject::toForeground(bool restack)
{
	if(disp)
	{	disp->toForeground(this);
		if(restack)
		{	if(parent)
				parent->restackChild(this, TRUE);
			else if(world)
				world->restackChild(this, TRUE);
		}
		for(int i = numChildren; i > 0; i--)
			children[i - 1]->toForeground(FALSE);
	}
}

void CiObject::toBackground(bool restack)
{
	if(disp)
	{	for(int i = 0; i < numChildren; i++)
			children[i]->toBackground(FALSE);
		disp->toBackground(this);
		if(restack)
		{	if(parent)
				parent->restackChild(this, FALSE);
			else if(world)
				world->restackChild(this, FALSE);
		}
	}
}

#ifndef NO_VARARGS

#include <stdarg.h>

#define do_varargs(sr, objkind, classkind) \
	char* aName = first; \
	va_list ap; \
	va_start(ap, first); \
	do \
		changeAssignInfo(sr, strstr(aName, "Class") ? classkind : objkind, aName); \
	while((aName = va_arg(ap, char *)) != (char *)0); \
	va_end(ap);

#else

#define do_varargs(sr, objkind, classkind) \
	changeAssignInfo(sr, strstr(first, "Class") ? classkind : objkind, first);

#endif /* NO_VARARGS */

void CiObject::allowAssignmentOf(char* first, ...)
{
	do_varargs(TRUE, CHILD_OBJECTS, CHILD_CLASSES)
}

void CiObject::denyAssignmentOf(char* first, ...)
{
	do_varargs(FALSE, CHILD_OBJECTS, CHILD_CLASSES)
}

void CiObject::allowAssigningTo(char* first, ...)
{
	do_varargs(TRUE, PARENT_OBJECTS, PARENT_CLASSES)
}

void CiObject::denyAssigningTo(char* first, ...)
{
	do_varargs(FALSE, PARENT_OBJECTS, PARENT_CLASSES)
}


// world /////////////////////////////////////////////////////////


XmCiWorld::XmCiWorld(char* n, int x, int y, int w, int h) : XmDrawing(n, x, y, w, h)
{
	numChildren = 0;
	unmarkNotify = TRUE;
}

XmCiWorld::~XmCiWorld()
{
}

CiObject* XmCiWorld::addChild(CiObject* anObj)
{
	if(numChildren < CI_MAX_WORLD_CHILDREN)
	{	children[numChildren++] = anObj;
		anObj->addTreeTo(this);
		return(anObj);
	}
	cerr << "ciWorld - error: Maximum number of children exceeded.\n";
	return(NULL);

}

CiObject* XmCiWorld::removeChild(CiObject* anObj)
{
	for(int i = 0; i < numChildren; i++)
	{	if(children[i] == anObj)
		{	numChildren--;
			for(int j = i; j < numChildren; j++)
				children[j] = children[j + 1];
			anObj->removeTreeFrom(this);
			return(anObj);
		}
	}
	return(NULL);
}

CiObject* XmCiWorld::child(int i)			{ return((i >= 0 && i < numChildren) ? children[i] : NULL); }
CiObject* XmCiWorld::childAt(gprPoint p)	{ return((CiObject* )primAt(p)); }
int XmCiWorld::childrenCount()				{ return(numChildren); }

CiObject** XmCiWorld::getChildren(int cd, ciState st, char* icName, CiObject** all, int* count)
{
	int localNdx = 0, & ndx = count ? *count : localNdx;

	if(!all)
		all = new CiObject*[CI_MAX_TREE_SIZE];
	for(int i = 0; i < numChildren; i++)
	{	CiObject* aChild = child(i);
		if((st == -1 || aChild->getState(st)) && (!icName || parseWildcards(icName, aChild->className()) || parseWildcards(icName, aChild->getName())))
			all[ndx++] = aChild;
		if(cd == CH_ALL || (cd == CH_SHALLOW && !aChild->getState(st)))
			aChild->getChildren(cd, st, icName, all, &ndx);
	}
	all[ndx] = NULL;
	return(all);
}

CiObject* XmCiWorld::commonParentFor(CiObject* o1, CiObject* o2)
{
	CiObject* parents[MAX_DRAWING_PRIMS], * anObj;
	int n = 0;

	anObj = o1;
	while(anObj = anObj->parent)
		parents[n++] = anObj;
	anObj = o2;
	while(anObj = anObj->parent)
	{	for(int i = 0; i < n; i++)
		{	if(parents[i] == anObj)
				return(anObj);
		}
	}
	return(NULL);
}

void XmCiWorld::restackChild(CiObject* obj, bool dir)
{
	for(int i = 0; i < numChildren; i++)
	{	CiObject* aChild;
		if((aChild = children[i]) == obj)
		{	if(dir)
			{	for(int j = i; j > 0; j--)
					children[j] = children[j - 1];
				children[0] = aChild;
			}
			else
			{	for(int j = i; j < numChildren - 1; j++)
					children[j] = children[j + 1];
				children[numChildren - 1] = aChild;
			}
			break;
		}
	}
}

bool XmCiWorld::userClick(DrawPrim* p, int x, int y, bool buttonDown)
{
	if(p)
		((CiObject* )p)->objSelect(x, y, buttonDown);
	return(TRUE);
}

bool XmCiWorld::userSelect(DrawPrim* p, bool on, int cx, int cy)
{
	if(!p)
		return(unmarkNotify); 
	if(((CiObject* )p)->objMark(on, cx, cy, TRUE, TRUE, TRUE))
	{	// refresh(FALSE);	// automatically done by the drawing class after return...
		((CiObject* )p)->objMark(on, cx, cy, TRUE, TRUE, FALSE);
		return(TRUE);
	}
	return(FALSE);
}

#define validate_move ((bool )((aTarget == anObj->parent ? FALSE : anObj->validateParent(aTarget)) && (aTarget ? aTarget->validateChild(anObj) : TRUE)))
/*
bool XmCiWorld::userMove(DrawPrim*, int, int, int, int)
{
	return(FALSE);
}
*/

bool XmCiWorld::userMove(DrawPrim* p, int x, int y, int, int)
{
	CiObject* anObj = (CiObject* )p, * aRoot, * aTarget = (CiObject* )curDragTarget();

	if(!anObj)
	{	CiObject** tmpPrims = new CiObject*[primCount];
		int count, i;
		count = primCount;			// primCount may change during operation...
		for(i = 0; i < count; i++)
			tmpPrims[i] = (CiObject* )prims[i];
		for(i = 0; i < count; i++)
		{	if((anObj = tmpPrims[i])->reAssigned)
			{	anObj->toForeground(FALSE);
				if((aRoot = anObj->getMarkedRoot()) && anObj == aRoot)
					anObj->objAssign(aTarget, x, y, TRUE, TRUE, FALSE);
				anObj->reAssigned = NULL;
			}
			else if((anObj = tmpPrims[i])->moved)
			{	anObj->objAssign(anObj->parent, x, y, TRUE, TRUE, FALSE);
				anObj->moved = FALSE;
			}
		}
		return(TRUE);
	}
	if(!(aRoot = anObj->getMarkedRoot()))
		return(FALSE);
	bool yesno = TRUE;
	if(aTarget != aRoot->parent)
	{	if(aRoot->validateParent(aTarget))
		{	if(aTarget)
				yesno = aTarget->validateChild(aRoot);
		}
		else
			yesno = FALSE;
	}
	if(yesno && anObj == aRoot)
		anObj->objAssign(aTarget, x, y, TRUE, TRUE, TRUE);
	return(yesno);
}

bool XmCiWorld::userResize(DrawPrim* p, int w, int h, bool originChanged, int x, int y)
{
	if(!p)
	{	for(int i = 0; i < primCount; i++)
		{	CiObject* anObj = (CiObject* )prims[i];
			if(anObj->resized)
			{	anObj->objResize(0, 0, FALSE, 0, 0, TRUE, TRUE, FALSE);
				anObj->resized = FALSE;
			}
		}
		return(TRUE);
	}
	return(((CiObject* )p)->objResize(w, h, originChanged, x, y, TRUE, TRUE, TRUE));
}

void XmCiWorld::userActivate(DrawPrim* p, int, int)
{
	((CiObject* )p)->objActivate();
}

#define validate_drag ((bool )((aTarget == anObj->parent ? TRUE : anObj->validateParent(aTarget)) && (aTarget ? aTarget->validateChild(anObj) : TRUE)))
/*
bool XmCiWorld::userDragEnter(DrawPrim*, DrawPrim**, bool*)
{
	return(FALSE);
}
*/

bool XmCiWorld::userDragEnter(DrawPrim* target, DrawPrim** dragged, bool* vals)
{
	CiObject* anObj, * aTarget = (CiObject* )target;
	int i = 0;
// cerr << "Target: " << (aTarget ? aTarget->instName : "WORLD") << "\n";
	while(anObj = (CiObject* )dragged[i])
	{
// cerr << anObj->instName << " - " << anObj << "/" << anObj->getMarkedRoot() << "\n";
		anObj = anObj->getMarkedRoot();
		// vals[i++] = validate_drag;
		bool yesno = FALSE;
		if(aTarget == anObj->parent)
			yesno = TRUE;
		else
		{	if(anObj->validateParent(aTarget))
			{	if(aTarget)
					yesno = aTarget->validateChild(anObj);
				else
					yesno = TRUE;
			}
		}
		vals[i++] = yesno;
// cerr << i << "(" << anObj->instName << " " << vals[i-1] << ") ";
	}
// cerr << ".\n";
	return(TRUE);
}

// Ci2 Tool CLasses implementation ///////////////////////////////////////////


CiLayout::CiLayout(char* n, int x, int y, int w, int h, ciAttrib attr, bool ort, int spc, bool ats, int rep) : CiObject(new Rectangle(x, y, w, h), n, attr)
{
	orientation = ort;	// TRUE - horizontal, FALSE - vertical
	spacing = spc;
	autoSize = ats;
	maxRepeat = rep;
	setCallback(ChangeContents, this, CBK(CiLayout, contentsChanged), TRUE, FALSE, CB_CI_DATA);
}

void CiLayout::reOrder(CiObject* anObj)
{
	int i = 0;
	bool among = FALSE;
	CiObject* aChild;

	while(aChild = child(i++))
	{	if(aChild == anObj)
		{	among = TRUE;
			continue;
		}
		if(orientation ? (aChild->origin().x > anObj->origin().x) :
						 (aChild->origin().y > anObj->origin().y))
			break;
	}
	restackChild(anObj, i - (among ? 2 : 1));
	reLayout();
}

void CiLayout::handleAdd(CiObject* anObj)
{
	reOrder(anObj);
	anObj->setCallback(Move, this, CBK(CiLayout, reOrder), TRUE, FALSE, CB_OBJ_PTR, USER);
	anObj->setCallback(Resize, this, CBK(CiLayout, reLayout));
}

void CiLayout::handleRemove(CiObject* anObj)
{
	reLayout();
	anObj->setCallback(Move, this, CBK(CiLayout, reOrder), FALSE, FALSE, CB_OBJ_PTR, USER);
	anObj->setCallback(Resize, this, CBK(CiLayout, reLayout), FALSE);
}

void CiLayout::reLayout(void*)
{
	int i = 0, p = spacing, q = spacing;
	CiObject* aChild;

	while(aChild = child(i++))
	{	aChild->move(orientation ? p : spacing, orientation ? spacing : p);
		p += (orientation ? aChild->extent().x : aChild->extent().y) + spacing;
		int woh = (orientation ? aChild->extent().y : aChild->extent().x) + 2 * spacing;
		q = q > woh ? q : woh;
	}
	if(autoSize)
		resize(orientation ? p : q, orientation ? q : p, TRUE);
}

void CiLayout::contentsChanged(ciClientData* d)
{
	if(d->operation == OP_ADD)
		handleAdd(d->obj);
	else
		handleRemove(d->obj);
}


//////////////////////////////////////////////////


DrawPrim* Connector::connObject(connObj shape)
{
	return(shape == CO_ARROW ? ((DrawPrim* )new Arrow(0, 0, 10, 10)) : ((DrawPrim* )new Line(0, 0, 10, 10)));
}

Connector::Connector(char* n, connObj o) : CiObject(connObject(o), n, 0)
{
	from = to = NULL;
	rFrom = rTo = CR_CENTER;
}

bool Connector::connect(CiObject* f, CiObject* t, connRule fr, connRule tr)
{
	if(!changeFrom(f, fr, FALSE) || !changeTo(t, tr, TRUE))
		return(FALSE);
	setCallback(Resize, this, CBK(Connector, resized), TRUE, TRUE);
	setCallback(Resize, this, CBK(Connector, reAdjust), TRUE, FALSE);
	return(TRUE);
}

Connector::~Connector()
{
	from->setCallback(Move, this, CBK(Connector, changed), FALSE, FALSE, CB_OBJ_PTR, USER | APP | PARENT);
	to->setCallback(Move, this, CBK(Connector, changed), FALSE, FALSE, CB_OBJ_PTR, USER | APP | PARENT);
	from->setCallback(Resize, this, CBK(Connector, changed), FALSE, FALSE, CB_OBJ_PTR, USER | APP);
	to->setCallback(Resize, this, CBK(Connector, changed), FALSE, FALSE, CB_OBJ_PTR, USER | APP);
}

bool Connector::changeObj(CiObject** which, CiObject* anObj, connRule cr, bool adj)
{
	if(!anObj || !(which == &from ? validateChild(anObj) : validateParent(anObj)))
		return(FALSE);
	*(which == &from ? &rFrom : &rTo) = cr;
	if(*which == anObj)
	{	if(adj)
			reAdjust();
		return(TRUE);
	}
	if(*which)
	{	(*which)->setCallback(Move, this, CBK(Connector, changed), FALSE, FALSE, CB_OBJ_PTR, USER | APP | PARENT);
		(*which)->setCallback(Resize, this, CBK(Connector, changed), FALSE, FALSE, CB_OBJ_PTR, USER | APP);
	}
	*which = anObj;
	(*which)->setCallback(Move, this, CBK(Connector, changed), TRUE, FALSE, CB_OBJ_PTR, USER | APP | PARENT);
	(*which)->setCallback(Resize, this, CBK(Connector, changed), TRUE, FALSE, CB_OBJ_PTR, USER | APP);
	if(adj)
		reAdjust();
	return(TRUE);
}

void Connector::placeConn(int ndx, CiObject* obj, connRule r)
{
	int nx = 0, ny = 0;
	bool warn = FALSE;

	if(r & CR_LEFT)			{ nx = obj->origin().x; }
	else if(r & CR_RIGHT)	{ nx = obj->corner().x; }
	else if(!(r & CR_CENTER || r & CR_NEXT))
		warn = TRUE;
	if(r & CR_TOP)			{ ny = obj->origin().y; }
	else if(r & CR_BOTTOM)	{ ny = obj->corner().y; }
	else if(!(r & CR_CENTER || r & CR_NEXT))
		warn = TRUE;

	if(warn)
	{	cerr << "Connector: warning - invalid connection rule for object " << obj->getName() << ", centering...\n";
		r |= CR_CENTER;
	}

	if(r & CR_CENTER)
	{	nx = (r & CR_LEFT || r & CR_RIGHT) ? nx : obj->center().x;
		ny = (r & CR_TOP || r & CR_BOTTOM) ? ny : obj->center().y;
	}
	setPoint(ndx, nx, ny);
}

#ifndef min
#define min(a, b) (((a) < (b)) ? (a) : (b))
#define max(a, b) (((a) > (b)) ? (a) : (b))
#endif

gprPoint Connector::placeEnd(int ndx, CiObject* obj, connRule r)
{
	gprPoint pts[100], mypts[2], thePoint;
	int numPts;

	getPoints(mypts, 2);
	thePoint = mypts[ndx];
	if(!(r & CR_NEXT) || !(numPts = obj->getPoints(pts, 100)))
		return(thePoint);
	int a1 = mypts[0].x, a2 = mypts[0].y, b1 = mypts[1].x, b2 = mypts[1].y;
	int myfrox = min(a1, b1), myfroy = min(a2, b2);
	int myfrcx = max(a1, b1), myfrcy = max(a2, b2);
	for(int i = 0; i < numPts; i += 2)
	{	int c1 = pts[i].x, c2 = pts[i].y, d1 = pts[i + 1].x, d2 = pts[i + 1].y;
		float u = float((a1 - c1) * (b2 - a2) - (a2 - c2) * (b1 - a1)) /
			       ((d1 - c1) * (b2 - a2) - (d2 - c2) * (b1 - a1));
		int x1 = int(c1 + u * (d1 - c1));
		int x2 = int(c2 + u * (d2 - c2));
		int frox = min(c1, d1), froy = min(c2, d2);
		int frcx = max(c1, d1), frcy = max(c2, d2);
//cerr << "connector " << a1 << "@" << a2 << " - " << b1 << "@" << b2 << " meets line " << 
//			c1 << "@" << c2 << " - " << d1 << "@" << d2 << " at: " << x1 << "@" << x2 << "\n";
		if(x1 >= frox && x1 <= frcx && x2 >= froy && x2 <= frcy &&
		   x1 >= myfrox && x1 <= myfrcx && x2 >= myfroy && x2 <= myfrcy)
		{	thePoint.x = x1;
			thePoint.y = x2;
			return(thePoint);
		}
	}
//cerr << "invalid connector data, CR_NEXT ignored...\n";
	return(thePoint);
}


void Connector::reAdjust(void*)
{
	if(!getWorld())
	{	if(!(from && from->getWorld() && to && to->getWorld()))
			return;
		from->getWorld()->addChild(this);
	}
/*
	CiObject* aParent = getWorld()->commonParentFor(from, to);

	if(aParent != getParent())
		assign(aParent, 0, 0);
*/
	toForeground();
	placeConn(0, from, rFrom);
	placeConn(1, to, rTo);
	if(rFrom & CR_NEXT || rTo & CR_NEXT)
	{	gprPoint corrFrom, corrTo;
		corrFrom = placeEnd(0, from, rFrom);
		corrTo = placeEnd(1, to, rTo);
		setPoint(0, corrFrom.x, corrFrom.y);
		setPoint(1, corrTo.x, corrTo.y);
	}
	update();
}

void Connector::resized(ciClientData* d)
{
	CiObject* nFrom, * nTo = NULL;
	if(	!(nFrom = getWorld()->childAt(gprPoint(d->x, d->y))) ||
		!(nTo = getWorld()->childAt(gprPoint(d->x1, d->y1))))
		*d->answer = FALSE;
	else
	{	if(nFrom != from)
			changeFrom(nFrom, rFrom);
		else if(nTo != to)
			changeTo(nTo, rTo);
	}
}

void Connector::changed(CiObject*)
{
	reAdjust();
}

