#ifndef LayoutItem_included
#define LayoutItem_included

#include <qlayout.h>
#include <qlist.h>
#include <qstring.h>
#include <qtstream.h>
#include <qwidget.h>

class BoxLayout;
class WidgetLayout;

class LayoutItem
{
public: // Methods

    virtual ~LayoutItem();

    virtual void AddToLayout
    (
	QBoxLayout*	layout
    ) = 0;
    // Add the item to the layout

    virtual BoxLayout* FindLayout
    (
	QWidget*	widget
    ) const;
    // Given the widget representing a layout, return the layout or NULL if not
    // found

    virtual BoxLayout* FindLayout
    (
	LayoutItem*	item
    ) const;
    // Given a layout item, find the layout that it is on or return NULL

    virtual BoxLayout* FindLayout
    (
	const QRect&	rect
    );
    // Find the topmost layout that contains the given rect in global coords

    virtual LayoutItem* FindLayoutItem
    (
	QWidget*	widget
    ) const = 0;
    // Given the widget representing a layout item, return the item or NULL if
    // not found

    virtual bool EditProperties( void );
    // Edit properties for the layout item, return TRUE if any changes were
    // made.

    virtual void LowerWidget( void );
    // Lower any widget associated with the layout item.  Default does nothing.

    virtual void SaveContents( QTextStream&	stream,
			       QString		id ) const = 0;
    // Save the item's contents to the stream with the given id

    virtual bool RestoreKeyValue( const QString&	key,
				  const QString&	value ) = 0;
    // Restore a single key/value pair

    virtual void GenerateSource( QTextStream&	stream,
				 const QString&	layoutVarName,
				 const QString&	layoutId ) const = 0;
    // Generate the source for the layout given by layoutVarName.  If the 
    // layoutVarName is empty, the layout is a top level layout

    virtual QString GetItemName( void ) const = 0;
    // Return a text string for the name of this item

    virtual QWidget* GetPropertyPage
    (
	QWidget*	parent
    );
    // Return a new property page to be used for this item

    virtual QRect GetGlobalGeometry( void ) const = 0;
    // Get the global geometry for this layout item

    bool IsLayout( void ) const;
    // Is the layout item a layout

protected: // Methods

    LayoutItem
    (
	WidgetLayout*	widgetLayout,
	bool		layout = FALSE
    );

    void SetColor
    (
	QWidget*	widget
    );
    // Gives the widget an appropriate color scheme for being a layout item

private: // Methods
    LayoutItem( const LayoutItem& );
    LayoutItem& operator= ( const LayoutItem& );

protected: // Attributes

    WidgetLayout*	itsWidgetLayout;
    // the widget layout where the item lies

private: // Attributes

    bool	isLayout;
    // is the item a layout
};


inline bool LayoutItem::IsLayout( void ) const
{
    return isLayout;
}


#endif // LayoutItem_included
