#ifndef DialogPropDialog_included
#define DialogPropDialog_included

#include "prop/DialogBasePage.h"
#include "prop/DialogGenPage.h"
#include "prop/DialogGeometryPage.h"
#include "prop/DialogWindowPage.h"

#include "layout/BoxLayoutPropPage.h"

#include "DialogPropDialogData.h"

#include "WidgetLayout.h"

class Dialog;
class BoxLayoutPropPage;

class DialogPropDialog : public DialogPropDialogData
{
    Q_OBJECT

public:

    DialogPropDialog
    (
     Dialog* dialog,
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~DialogPropDialog();

private slots:

    void Apply();

    void LayoutTypeChanged
    (	
	WidgetLayout::LayoutType	type
    );
    // The layout type has been changed to the given type

private:

    DialogBasePage	itsBasePage;
    DialogGenPage	itsGenPage;
    DialogWindowPage	itsWindowPage;
    DialogGeometryPage	itsGeometryPage;

    BoxLayoutPropPage	itsBoxLayoutPage;

    Dialog*	itsDialog;

};
#endif // DialogPropDialog_included
